/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.richtext.cellpainter;

import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.extension.nebula.richtext.RichTextCellPainter;
import org.eclipse.nebula.widgets.nattable.layer.cell.CellDisplayConversionUtils;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.style.CellStyleUtil;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.infra.nattable.utils.StyleUtils;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class PapyrusRichTextCellPainter
extends RichTextCellPainter {
    public PapyrusRichTextCellPainter() {
        this(true, false, false);
    }

    public PapyrusRichTextCellPainter(boolean wrapText, boolean calculateByTextLength, boolean calculateByTextHeight) {
        super(wrapText, calculateByTextLength, calculateByTextHeight);
    }

    public int getPreferredHeight(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        this.setupGCFromConfig(gc, CellStyleUtil.getCellStyle((ILayerCell)cell, (IConfigRegistry)configRegistry));
        String htmlText = CellDisplayConversionUtils.convertDataType((ILayerCell)cell, (IConfigRegistry)configRegistry);
        INattableModelManager nattableManager = (INattableModelManager)configRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, DisplayMode.NORMAL, new String[]{"nattable_model_manager_id"});
        boolean calculateWithWrapping = true;
        if (nattableManager != null && nattableManager.getTable() != null) {
            calculateWithWrapping = StyleUtils.getBooleanNamedStyleValue((Table)nattableManager.getTable(), (String)"wrapText");
        }
        this.richTextPainter.preCalculate(htmlText, gc, new Rectangle(0, 0, cell.getBounds().width, 0), calculateWithWrapping);
        return this.richTextPainter.getPreferredSize().y - 2 * this.richTextPainter.getParagraphSpace();
    }
}

