/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.provider;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.utils.TableSelectionWrapper;

public class TableStructuredSelection
implements IStructuredSelection,
IAdaptable {
    private final TableSelectionWrapper wrapper;
    private final IStructuredSelection wrappedSelection;

    public TableStructuredSelection(TableSelectionWrapper wrapper) {
        this.wrapper = wrapper;
        this.wrappedSelection = StructuredSelection.EMPTY;
    }

    public TableStructuredSelection(List<?> elements, IElementComparer comparer, TableSelectionWrapper wrapper) {
        this.wrappedSelection = new StructuredSelection(elements, comparer);
        this.wrapper = wrapper;
    }

    public TableStructuredSelection(List<?> elements, TableSelectionWrapper wrapper) {
        this.wrappedSelection = new StructuredSelection(elements);
        this.wrapper = wrapper;
    }

    public TableStructuredSelection(Object element, TableSelectionWrapper wrapper) {
        this.wrappedSelection = new StructuredSelection(element);
        this.wrapper = wrapper;
    }

    public TableStructuredSelection(Object[] elements, TableSelectionWrapper wrapper) {
        this.wrappedSelection = new StructuredSelection(elements);
        this.wrapper = wrapper;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == TableSelectionWrapper.class) {
            return this.wrapper;
        }
        if (adapter == INattableModelManager.class && this.wrapper != null) {
            return this.wrapper.getNatTableModelManager();
        }
        return null;
    }

    public boolean isEmpty() {
        return this.wrappedSelection.isEmpty();
    }

    public Object getFirstElement() {
        return this.wrappedSelection.getFirstElement();
    }

    public Iterator<?> iterator() {
        return this.wrappedSelection.iterator();
    }

    public int size() {
        return this.wrappedSelection.size();
    }

    public Object[] toArray() {
        return this.wrappedSelection.toArray();
    }

    public List<?> toList() {
        return this.wrappedSelection.toList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TableStructuredSelection)) {
            return false;
        }
        TableStructuredSelection tss2 = (TableStructuredSelection)o;
        return tss2.getTableSelectionWrapper().equals(this.getTableSelectionWrapper()) && tss2.getWrappedSelection().equals(this.getWrappedSelection());
    }

    private TableSelectionWrapper getTableSelectionWrapper() {
        return this.wrapper;
    }

    private IStructuredSelection getWrappedSelection() {
        return this.wrappedSelection;
    }
}

