/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.newchild.ui.preferences;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.papyrus.infra.newchild.CreationMenuRegistry;
import org.eclipse.papyrus.infra.newchild.elementcreationmenumodel.Folder;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class Preferences
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Map<Folder, Button> checkboxes = new HashMap<Folder, Button>();
    private Map<Folder, Boolean> folders = new HashMap<Folder, Boolean>();

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite self = new Composite(parent, 0);
        self.setLayout((Layout)new GridLayout(1, false));
        self.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createHeaderContents(self);
        Label label = new Label(self, 0);
        label.setText("New Child:");
        CreationMenuRegistry creationMenuInstance = CreationMenuRegistry.getInstance();
        List rootFolders = creationMenuInstance.getRootFolder();
        for (Folder folder : rootFolders) {
            boolean applied = folder.isVisible();
            Button checkbox = new Button(self, 32);
            checkbox.setText(this.getName(folder));
            checkbox.setToolTipText(this.getToolTipText(folder));
            checkbox.setSelection(applied);
            final Folder theFolder = folder;
            checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean applied = ((Button)e.widget).getSelection();
                    Preferences.this.folders.put(theFolder, applied);
                }
            });
            this.checkboxes.put(folder, checkbox);
        }
        this.createFooterContents(self);
        return null;
    }

    private String getToolTipText(Folder folder) {
        URI uri = EcoreUtil.getURI((EObject)folder).trimFragment();
        StringBuilder text = new StringBuilder();
        if (uri != null) {
            String FileName = uri.lastSegment();
            text.append(FileName);
            text.append(" - ");
            String pluginName = uri.segment(1);
            text.append(pluginName);
            String type = uri.segment(0);
            text.append("(");
            text.append(type);
            text.append(")");
        }
        return text.toString();
    }

    private String getName(Folder folder) {
        URI uri = EcoreUtil.getURI((EObject)folder).trimFragment();
        StringBuilder name = new StringBuilder();
        name.append(uri.lastSegment());
        name.replace(name.indexOf("." + uri.fileExtension()), name.length(), "");
        if (uri.isPlatformPlugin()) {
            name.append(" (Plugin)");
        } else if (uri.isPlatformResource()) {
            name.append(" (Resource)");
        }
        return name.toString();
    }

    protected void createHeaderContents(Composite parent) {
    }

    protected void createFooterContents(Composite parent) {
    }

    public boolean performOk() {
        return this.saveChanges();
    }

    public void performApply() {
        this.saveChanges();
    }

    public boolean saveChanges() {
        for (Map.Entry<Folder, Boolean> folderEntry : this.folders.entrySet()) {
            CreationMenuRegistry.getInstance().setCreationMenuVisibility(folderEntry.getKey(), folderEntry.getValue());
        }
        return true;
    }

    public void performDefaults() {
        CreationMenuRegistry.getInstance().restoreDefault();
        List rootFolder = CreationMenuRegistry.getInstance().getRootFolder();
        this.folders.clear();
        for (Folder folder : rootFolder) {
            Button button = this.checkboxes.get(folder);
            button.setSelection(folder.isVisible());
        }
    }
}

