/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.decoratormodel.internal.ui.wizards;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.uml.decoratormodel.helper.DecoratorModelUtils;
import org.eclipse.papyrus.uml.decoratormodel.internal.resource.DecoratorModelIndex;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.Activator;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.messages.Messages;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.wizards.AbstractProfileApplicationSelectionPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class AbstractNewDecoratorModelPage<I, P>
extends AbstractProfileApplicationSelectionPage<I, P> {
    private static final String FILE_EXTENSION_SETTING = "fileExtension";
    private Text resourceText;
    private Text modelNameText;
    private String modelName;

    public AbstractNewDecoratorModelPage(String name, String title, ImageDescriptor icon, Class<P> elementType) {
        super(name, title, icon, elementType);
        this.setMessage(Messages.AbstractNewDecoratorModelPage_0);
    }

    @Override
    protected int getLayoutColumnCount() {
        return 3;
    }

    @Override
    protected void createAdditionalContents(Composite mainArea) {
        AbstractNewDecoratorModelPage.lead(AbstractNewDecoratorModelPage.label(mainArea, Messages.AbstractNewDecoratorModelPage_1), 15);
        this.resourceText = new Text(mainArea, 2052);
        AbstractNewDecoratorModelPage.lead(AbstractNewDecoratorModelPage.fill(this.resourceText, true, false), 15);
        this.resourceText.setText(this.defaultResource(this.getInput()));
        this.resourceText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractNewDecoratorModelPage.this.validatePage();
            }
        });
        Button browse = AbstractNewDecoratorModelPage.lead(AbstractNewDecoratorModelPage.button(mainArea, Messages.AbstractNewDecoratorModelPage_2), 15);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractNewDecoratorModelPage.this.browseResource();
            }
        });
        AbstractNewDecoratorModelPage.label(mainArea, Messages.AbstractNewDecoratorModelPage_3);
        this.modelNameText = new Text(mainArea, 2052);
        AbstractNewDecoratorModelPage.span(AbstractNewDecoratorModelPage.fill(this.modelNameText, true, false), 2);
        this.modelName = this.defaultModelName(this.getInput());
        this.modelNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (AbstractNewDecoratorModelPage.this.modelNameText.isEnabled()) {
                    AbstractNewDecoratorModelPage.this.modelName = AbstractNewDecoratorModelPage.this.modelNameText.getText();
                    AbstractNewDecoratorModelPage.this.validatePage();
                }
            }
        });
    }

    public URI getResourceURI() {
        String resourcePath = this.resourceText.getText().trim();
        return resourcePath.length() > 0 ? URI.createPlatformResourceURI((String)resourcePath, (boolean)true) : null;
    }

    protected String defaultModelName(I input) {
        return Messages.AbstractNewDecoratorModelPage_4;
    }

    public String getModelName() {
        return this.modelNameText.getText();
    }

    protected abstract void browseResource();

    protected void browseResource(String title, String message) {
        IFile file = WorkspaceResourceDialog.openNewFile((Shell)this.getShell(), (String)title, (String)message, (IPath)new Path(this.resourceText.getText().trim()), null);
        if (file != null) {
            this.resourceText.setText(file.getFullPath().toString());
        }
    }

    @Override
    protected void validatePage() {
        this.setErrorMessage(null);
        URI resourceURI = this.getResourceURI();
        if (resourceURI == null) {
            this.setPageComplete(false);
        } else if (!resourceURI.isPlatformResource()) {
            this.setErrorMessage(Messages.AbstractNewDecoratorModelPage_5);
            this.setPageComplete(false);
        } else {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(resourceURI.toPlatformString(true)));
            IContainer container = file.getParent();
            if (!container.exists()) {
                this.setErrorMessage(NLS.bind((String)Messages.AbstractNewDecoratorModelPage_6, (Object)container.getFullPath().toString()));
                this.setPageComplete(false);
            } else if (!"uml".equals(resourceURI.fileExtension())) {
                this.setErrorMessage(NLS.bind((String)Messages.AbstractNewDecoratorModelPage_7, (Object)"uml"));
                this.setPageComplete(false);
            } else if (file.exists()) {
                this.modelNameText.setEnabled(false);
                String message = this.validateExistingFile(file);
                if (message != null) {
                    this.setErrorMessage(message);
                    this.setPageComplete(false);
                } else if (!DecoratorModelUtils.isDecoratorModel((URI)this.getResourceURI())) {
                    this.setErrorMessage(Messages.AbstractNewDecoratorModelPage_8);
                    this.setPageComplete(false);
                } else {
                    try {
                        this.modelNameText.setText(DecoratorModelIndex.getInstance().getDecoratorModelName(this.getResourceURI()));
                    }
                    catch (CoreException e) {
                        Activator.getDefault().getLog().log(e.getStatus());
                        StatusManager.getManager().handle(e.getStatus(), 2);
                    }
                    super.validatePage();
                }
            } else {
                if (!this.modelNameText.getText().equals(this.modelName)) {
                    this.modelNameText.setText(this.modelName);
                }
                this.modelNameText.setEnabled(true);
                super.validatePage();
            }
        }
    }

    protected String validateExistingFile(IFile file) {
        return null;
    }

    protected String getFileExtension() {
        String result = this.getDialogSettings().get(FILE_EXTENSION_SETTING);
        if (result == null) {
            result = "profileapp.uml";
        }
        return result;
    }

    void saveSettings() {
        URI uri = this.getResourceURI();
        if (uri != null) {
            String fileExtension = uri.fileExtension();
            uri = uri.trimFileExtension();
            while (uri.fileExtension() != null) {
                fileExtension = String.format("%s.%s", uri.fileExtension(), fileExtension);
                uri = uri.trimFileExtension();
            }
            this.getDialogSettings().put(FILE_EXTENSION_SETTING, fileExtension);
        }
    }

    protected abstract String defaultResource(I var1);
}

