/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.types.generator.ui.internal.wizards;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.papyrus.eclipse.project.editors.project.PluginEditor;
import org.eclipse.papyrus.uml.profile.types.generator.ui.internal.wizards.GeneratorWizardModel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.xml.sax.SAXException;

public class PluginConfigurationBlock {
    private GeneratorWizardModel model;
    private Group pluginGroup;
    private Button extensionPoint;

    public PluginConfigurationBlock(GeneratorWizardModel model) {
        this.model = model;
    }

    void createControl(Composite parent) {
        this.pluginGroup = new Group(parent, 0);
        this.pluginGroup.setText("Plug-in Configuration");
        this.pluginGroup.setLayout((Layout)new GridLayout(1, true));
        this.pluginGroup.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(2, 1).create());
        this.extensionPoint = new Button((Composite)this.pluginGroup, 32);
        this.extensionPoint.setText("Generate extension point");
        this.extensionPoint.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginConfigurationBlock.this.model.setGenerateExtensionPoint(PluginConfigurationBlock.this.extensionPoint.getSelection());
                PluginConfigurationBlock.this.model.validatePage();
            }
        });
        this.extensionPoint.setSelection(this.model.isGenerateExtensionPoint());
    }

    void validatePage() {
        IProject project = this.model.getOutputModelFile().getProject();
        boolean groupEnabled = this.isPlugin(project);
        this.pluginGroup.setEnabled(groupEnabled);
        this.extensionPoint.setEnabled(groupEnabled);
    }

    private boolean isPlugin(IProject project) {
        PluginEditor pluginEditor;
        try {
            pluginEditor = new PluginEditor(project);
        }
        catch (IOException | ParserConfigurationException | CoreException | SAXException e) {
            return false;
        }
        pluginEditor.init();
        return pluginEditor.exists();
    }
}

