/**
 * generated by Xtext
 */
package org.eclipse.papyrus.infra.gmfdiag.css3.formatting2;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.CssSelector;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.CssTok;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.FuncTok;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.PseudoClassFunction;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.SimpleSelectorForNegation;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.UrlTok;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.charset;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.css_declaration;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.font_face;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.importExpression;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.keyframe_selector;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.keyframes;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.media;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.page;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.ruleset;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.selector;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.simple_selector;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.stylesheet;
import org.eclipse.papyrus.infra.gmfdiag.css3.services.CSSGrammarAccess;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatter;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

@SuppressWarnings("all")
public class CSSFormatter extends AbstractCSSFormatter {
  @Inject
  @Extension
  private CSSGrammarAccess _cSSGrammarAccess;

  protected void _format(final stylesheet stylesheet, @Extension final IFormattableDocument document) {
    boolean _hasSyntaxError = this.getTextRegionAccess().hasSyntaxError();
    if (_hasSyntaxError) {
      return;
    }
    this.format(stylesheet.getCharset(), document);
    EList<importExpression> _imports = stylesheet.getImports();
    for (final importExpression imports : _imports) {
      this.format(imports, document);
    }
    EList<ruleset> _ruleset = stylesheet.getRuleset();
    for (final ruleset ruleset : _ruleset) {
      this.format(ruleset, document);
    }
    EList<media> _media = stylesheet.getMedia();
    for (final media media : _media) {
      this.format(media, document);
    }
    EList<page> _page = stylesheet.getPage();
    for (final page page : _page) {
      this.format(page, document);
    }
    EList<font_face> _font_face = stylesheet.getFont_face();
    for (final font_face font_face : _font_face) {
      this.format(font_face, document);
    }
    EList<keyframes> _keyframes = stylesheet.getKeyframes();
    for (final keyframes keyframes : _keyframes) {
      this.format(keyframes, document);
    }
  }

  protected void _format(final charset charset, @Extension final IFormattableDocument document) {
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.setNewLines(2);
    };
    document.<org.eclipse.papyrus.infra.gmfdiag.css3.cSS.charset>append(charset, _function);
  }

  protected void _format(final page page, @Extension final IFormattableDocument document) {
    EList<css_declaration> _declarations = page.getDeclarations();
    for (final css_declaration declarations : _declarations) {
      this.format(declarations, document);
    }
  }

  protected void _format(final media media, @Extension final IFormattableDocument document) {
    EList<ruleset> _rulesets = media.getRulesets();
    for (final ruleset rulesets : _rulesets) {
      this.format(rulesets, document);
    }
  }

  protected void _format(final font_face font_face, @Extension final IFormattableDocument document) {
    EList<css_declaration> _declarations = font_face.getDeclarations();
    for (final css_declaration declarations : _declarations) {
      this.format(declarations, document);
    }
    EList<keyframe_selector> _keyframeselectors = font_face.getKeyframeselectors();
    for (final keyframe_selector keyframeselectors : _keyframeselectors) {
      this.format(keyframeselectors, document);
    }
  }

  protected void _format(final keyframe_selector keyframe_selector, @Extension final IFormattableDocument document) {
    EList<css_declaration> _declarations = keyframe_selector.getDeclarations();
    for (final css_declaration declarations : _declarations) {
      this.format(declarations, document);
    }
  }

  protected void _format(final ruleset ruleset, @Extension final IFormattableDocument document) {
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.append(document.prepend(this.textRegionExtensions.regionFor(ruleset).keyword("{"), _function), _function_1);
    final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
      it.indent();
    };
    document.<org.eclipse.papyrus.infra.gmfdiag.css3.cSS.ruleset>interior(ruleset, _function_2);
    List<ISemanticRegion> _keywords = this.textRegionExtensions.regionFor(ruleset).keywords(
      this._cSSGrammarAccess.getRulesetAccess().getSemicolonKeyword_4_1_0(), 
      this._cSSGrammarAccess.getRulesetAccess().getSemicolonKeyword_4_2());
    for (final ISemanticRegion semicolon : _keywords) {
      final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
        it.setNewLines(1);
      };
      document.set(semicolon.getNextHiddenRegion(), _function_3);
    }
    final Procedure1<IHiddenRegionFormatter> _function_4 = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.prepend(this.textRegionExtensions.regionFor(ruleset).keyword("}"), _function_4);
    final Procedure1<IHiddenRegionFormatter> _function_5 = (IHiddenRegionFormatter it) -> {
      it.setNewLines(2);
    };
    document.<org.eclipse.papyrus.infra.gmfdiag.css3.cSS.ruleset>append(ruleset, _function_5);
    EList<selector> _selectors = ruleset.getSelectors();
    for (final selector selectors : _selectors) {
      this.format(selectors, document);
    }
    EList<css_declaration> _declarations = ruleset.getDeclarations();
    for (final css_declaration declarations : _declarations) {
      this.format(declarations, document);
    }
  }

  protected void _format(final selector selector, @Extension final IFormattableDocument document) {
    EList<simple_selector> _simpleselectors = selector.getSimpleselectors();
    for (final simple_selector simpleselectors : _simpleselectors) {
      this.format(simpleselectors, document);
    }
    this.format(selector.getSelector(), document);
  }

  protected void _format(final SimpleSelectorForNegation simpleselectorfornegation, @Extension final IFormattableDocument document) {
    this.format(simpleselectorfornegation.getElement(), document);
    this.format(simpleselectorfornegation.getUniversal(), document);
    EList<CssSelector> _subSelectors = simpleselectorfornegation.getSubSelectors();
    for (final CssSelector subSelectors : _subSelectors) {
      this.format(subSelectors, document);
    }
  }

  protected void _format(final simple_selector simple_selector, @Extension final IFormattableDocument document) {
    this.format(simple_selector.getElement(), document);
    this.format(simple_selector.getUniversal(), document);
    EList<CssSelector> _subSelectors = simple_selector.getSubSelectors();
    for (final CssSelector subSelectors : _subSelectors) {
      this.format(subSelectors, document);
    }
  }

  protected void _format(final css_declaration css_declaration, @Extension final IFormattableDocument document) {
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.indent();
    };
    document.<org.eclipse.papyrus.infra.gmfdiag.css3.cSS.css_declaration>prepend(css_declaration, _function);
    this.format(css_declaration.getProperty(), document);
    EList<CssTok> _valueTokens = css_declaration.getValueTokens();
    for (final CssTok valueTokens : _valueTokens) {
      this.format(valueTokens, document);
    }
  }

  protected void _format(final PseudoClassFunction pseudoclassfunction, @Extension final IFormattableDocument document) {
    this.format(pseudoclassfunction.getParamSelector(), document);
    EList<CssTok> _params = pseudoclassfunction.getParams();
    for (final CssTok params : _params) {
      this.format(params, document);
    }
  }

  protected void _format(final UrlTok urltok, @Extension final IFormattableDocument document) {
    this.format(urltok.getUrl(), document);
  }

  protected void _format(final FuncTok functok, @Extension final IFormattableDocument document) {
    EList<CssTok> _params = functok.getParams();
    for (final CssTok params : _params) {
      this.format(params, document);
    }
    this.format(functok.getName(), document);
  }

  @XbaseGenerated
  public void format(final Object pseudoclassfunction, final IFormattableDocument document) {
    if (pseudoclassfunction instanceof PseudoClassFunction) {
      _format((PseudoClassFunction)pseudoclassfunction, document);
      return;
    } else if (pseudoclassfunction instanceof XtextResource) {
      _format((XtextResource)pseudoclassfunction, document);
      return;
    } else if (pseudoclassfunction instanceof FuncTok) {
      _format((FuncTok)pseudoclassfunction, document);
      return;
    } else if (pseudoclassfunction instanceof UrlTok) {
      _format((UrlTok)pseudoclassfunction, document);
      return;
    } else if (pseudoclassfunction instanceof font_face) {
      _format((font_face)pseudoclassfunction, document);
      return;
    } else if (pseudoclassfunction instanceof SimpleSelectorForNegation) {
      _format((SimpleSelectorForNegation)pseudoclassfunction, document);
      return;
    } else if (pseudoclassfunction instanceof charset) {
      _format((charset)pseudoclassfunction, document);
      return;
    } else if (pseudoclassfunction instanceof css_declaration) {
      _format((css_declaration)pseudoclassfunction, document);
      return;
    } else if (pseudoclassfunction instanceof keyframe_selector) {
      _format((keyframe_selector)pseudoclassfunction, document);
      return;
    } else if (pseudoclassfunction instanceof media) {
      _format((media)pseudoclassfunction, document);
      return;
    } else if (pseudoclassfunction instanceof page) {
      _format((page)pseudoclassfunction, document);
      return;
    } else if (pseudoclassfunction instanceof ruleset) {
      _format((ruleset)pseudoclassfunction, document);
      return;
    } else if (pseudoclassfunction instanceof selector) {
      _format((selector)pseudoclassfunction, document);
      return;
    } else if (pseudoclassfunction instanceof simple_selector) {
      _format((simple_selector)pseudoclassfunction, document);
      return;
    } else if (pseudoclassfunction instanceof stylesheet) {
      _format((stylesheet)pseudoclassfunction, document);
      return;
    } else if (pseudoclassfunction instanceof EObject) {
      _format((EObject)pseudoclassfunction, document);
      return;
    } else if (pseudoclassfunction == null) {
      _format((Void)null, document);
      return;
    } else if (pseudoclassfunction != null) {
      _format(pseudoclassfunction, document);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(pseudoclassfunction, document).toString());
    }
  }
}
