/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.properties.uml.eef.ide.ui.advanced.controls.editablereference.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.eef.common.ui.api.IEEFFormContainer;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.utils.EvalFactory;
import org.eclipse.eef.ext.widgets.reference.eefextwidgetsreference.EEFExtReferenceDescription;
import org.eclipse.eef.ide.ui.api.widgets.IEEFLifecycleManager;
import org.eclipse.eef.ide.ui.ext.widgets.reference.internal.AbstractEEFExtReferenceLifecycleManager;
import org.eclipse.eef.ide.ui.ext.widgets.reference.internal.EEFExtMultipleReferenceLifecycleManager;
import org.eclipse.eef.ide.ui.ext.widgets.reference.internal.EEFExtReferenceUIPlugin;
import org.eclipse.eef.ide.ui.ext.widgets.reference.internal.Messages;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelector;
import org.eclipse.papyrus.infra.widgets.editors.MultipleValueSelectionDialog;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.selectors.ReferenceSelector;
import org.eclipse.papyrus.infra.widgets.widgets.MultipleValueSelectionWidget;
import org.eclipse.papyrus.sirius.properties.common.utils.ContainerUtil;
import org.eclipse.papyrus.sirius.properties.eef.advanced.controls.eefadvancedcontrols.EEFExtEditableReferenceDescription;
import org.eclipse.papyrus.sirius.properties.uml.eef.ide.ui.advanced.controls.Activator;
import org.eclipse.papyrus.sirius.properties.uml.eef.ide.ui.advanced.controls.editablereference.internal.CustomUMLContentProvider;
import org.eclipse.papyrus.sirius.properties.uml.eef.ide.ui.advanced.controls.editablereference.internal.EditableReferenceController;
import org.eclipse.papyrus.sirius.properties.uml.eef.ide.ui.advanced.controls.editablereference.internal.PapyrusEEFExtEObjectCreationWizard;
import org.eclipse.papyrus.uml.tools.providers.UMLFilteredLabelProvider;
import org.eclipse.sirius.common.interpreter.api.IEvaluationResult;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

public class MultipleEditableReferenceLifecycleManager
extends EEFExtMultipleReferenceLifecycleManager {
    protected static final String CREATE_DIALOG_TITLE = "Create a new UML Element";
    private static final String BROWSE_DIALOG_TITLE = "Browse ";
    private static final String EDIT_BUTTON_TOOLTIP = "Edit the selected value";
    protected Button editButton;
    protected AbstractEEFExtReferenceLifecycleManager.ButtonSelectionListener editButtonListener;

    public MultipleEditableReferenceLifecycleManager(EEFExtEditableReferenceDescription description, EObject target, EReference eReference, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter editingContextAdapter) {
        super((EEFExtReferenceDescription)description, target, eReference, variableManager, interpreter, editingContextAdapter);
    }

    protected void createMainControl(Composite parent, IEEFFormContainer formContainer) {
        super.createMainControl(parent, formContainer);
        this.controller = new EditableReferenceController((IEEFLifecycleManager)this, this.getWidgetDescription(), this.variableManager, this.interpreter, this.editingContextAdapter, this.isEnabled());
    }

    protected EditableReferenceController getController() {
        return (EditableReferenceController)this.controller;
    }

    protected void setEnabled(boolean isEnabled) {
        boolean elementIsSelected;
        Table table = this.tableViewer.getTable();
        boolean manyItems = table.getItemCount() > 1;
        TableItem[] selection = table.getSelection();
        boolean bl = elementIsSelected = selection != null && selection.length > 0;
        if (this.addButton != null && !this.addButton.isDisposed()) {
            if (this.tableViewer.getTable().getItemCount() < this.eReference.getUpperBound() || this.eReference.getUpperBound() == -1) {
                this.addButton.setEnabled(isEnabled);
            } else {
                this.addButton.setEnabled(false);
            }
        }
        if (this.removeButton != null && !this.removeButton.isDisposed()) {
            if (elementIsSelected) {
                this.removeButton.setEnabled(isEnabled);
            } else {
                this.removeButton.setEnabled(false);
            }
        }
        if (this.browseButton != null && !this.browseButton.isDisposed()) {
            if (this.tableViewer.getTable().getItemCount() < this.eReference.getUpperBound() || this.eReference.getUpperBound() == -1) {
                this.browseButton.setEnabled(isEnabled);
            } else {
                this.browseButton.setEnabled(false);
            }
        }
        if (this.editButton != null && !this.editButton.isDisposed()) {
            if (elementIsSelected) {
                this.editButton.setEnabled(isEnabled);
            } else {
                this.editButton.setEnabled(false);
            }
        }
        if (this.upButton != null && !this.upButton.isDisposed()) {
            if (manyItems && elementIsSelected && table.indexOf(selection[0]) > 0) {
                this.upButton.setEnabled(isEnabled);
            } else {
                this.upButton.setEnabled(false);
            }
        }
        if (this.downButton != null && !this.downButton.isDisposed()) {
            if (manyItems && elementIsSelected && table.indexOf(selection[0]) < table.getItemCount() - 1) {
                this.downButton.setEnabled(isEnabled);
            } else {
                this.downButton.setEnabled(false);
            }
        }
    }

    protected EEFExtEditableReferenceDescription getWidgetDescription() {
        return (EEFExtEditableReferenceDescription)this.description;
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (MultipleEditableReferenceLifecycleManager.this.tableViewer.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)MultipleEditableReferenceLifecycleManager.this.tableViewer.getSelection();
                    MultipleEditableReferenceLifecycleManager.this.variableManager.put("selection", MultipleEditableReferenceLifecycleManager.this.selectionToList((ISelection)structuredSelection));
                    MultipleEditableReferenceLifecycleManager.this.setEnabled(MultipleEditableReferenceLifecycleManager.this.isEnabled());
                }
            }
        });
        this.initializeEditButton();
    }

    public void aboutToBeHidden() {
        super.aboutToBeHidden();
        this.removeListener(this.editButton, this.editButtonListener);
    }

    protected void createTable(Composite parent) {
        super.createTable(parent);
        LabelProviderService service = null;
        try {
            ServicesRegistry registry = ServiceUtilsForEObject.getInstance().getServiceRegistry(this.target);
            service = (LabelProviderService)registry.getService(LabelProviderService.class);
        }
        catch (ServiceException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.papyrus.uml.eef.ide.ui.advanced.controls", "Unable to find the corresponding service."));
        }
        if (service != null) {
            ILabelProvider labelProvider = service.getLabelProvider((Object)this.target);
            if (labelProvider instanceof DelegatingStyledCellLabelProvider.IStyledLabelProvider) {
                DelegatingStyledCellLabelProvider.IStyledLabelProvider styledprovider = (DelegatingStyledCellLabelProvider.IStyledLabelProvider)labelProvider;
                this.tableViewer.setLabelProvider((IBaseLabelProvider)styledprovider);
            } else {
                this.tableViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new AdapterFactoryLabelProvider.StyledLabelProvider((AdapterFactory)this.composedAdapterFactory, (Viewer)this.tableViewer)));
            }
        }
    }

    protected void createButtons(Composite parent) {
        if (this.eReference.isOrdered()) {
            Image upImage = ExtendedImageRegistry.INSTANCE.getImage(EEFExtReferenceUIPlugin.getPlugin().getImage("full16/ArrowUp_16x16.gif"));
            this.upButton = this.createButton(parent, upImage);
            Image downImage = ExtendedImageRegistry.INSTANCE.getImage(EEFExtReferenceUIPlugin.getPlugin().getImage("full16/ArrowDown_16x16.gif"));
            this.downButton = this.createButton(parent, downImage);
        }
        if (!this.eReference.isContainment()) {
            Image browseImage = ExtendedImageRegistry.INSTANCE.getImage(EEFExtReferenceUIPlugin.getPlugin().getImage("full16/Browse_16x16.gif"));
            this.browseButton = this.createButton(parent, browseImage);
        }
        Image addImage = ExtendedImageRegistry.INSTANCE.getImage(EEFExtReferenceUIPlugin.getPlugin().getImage("full16/Add_16x16.gif"));
        this.addButton = this.createButton(parent, addImage);
        Image removeImage = ExtendedImageRegistry.INSTANCE.getImage(EEFExtReferenceUIPlugin.getPlugin().getImage("full16/Delete_16x16.gif"));
        this.removeButton = this.createButton(parent, removeImage);
        Image editImage = ExtendedImageRegistry.INSTANCE.getImage((Object)Activator.getDefault().getImage("Edit_16x16.gif"));
        this.editButton = this.createButton(parent, editImage);
    }

    protected void initializeEditButton() {
        this.editButtonListener = new AbstractEEFExtReferenceLifecycleManager.ButtonSelectionListener(this.editingContextAdapter, () -> this.editButtonCallback());
        this.editButton.addSelectionListener((SelectionListener)this.editButtonListener);
        this.editButton.setToolTipText(EDIT_BUTTON_TOOLTIP);
    }

    protected void editButtonCallback() {
        IStructuredSelection selection;
        if (this.tableViewer.getSelection() instanceof IStructuredSelection && (selection = (IStructuredSelection)this.tableViewer.getSelection()).size() == 1) {
            int returnCode;
            EObject element = (EObject)selection.getFirstElement();
            if (this.target != null && (returnCode = this.getController().getPropertiesUtils().displayEditionProperties(this.editingContextAdapter, element, this.variableManager, this.interpreter)) == 0) {
                this.refresh();
            }
        }
    }

    protected void initializeMoveButton(EEFExtMultipleReferenceLifecycleManager.Direction direction) {
        if (this.eReference.isOrdered()) {
            super.initializeMoveButton(direction);
        }
    }

    protected void addButtonCallback() {
        List types = this.getController().getPropertiesUtils().getAllPossibleTypes(this.composedAdapterFactory, this.editingContextAdapter, this.target, this.eReference);
        int returnCode = 1;
        EObject objectCreated = null;
        if (types.size() == 1 && this.eReference.isContainment()) {
            objectCreated = this.createUmlElement(this.target, (EStructuralFeature)this.eReference, ((EObject)types.get(0)).eClass().getName());
            if (objectCreated != null) {
                returnCode = this.getController().getPropertiesUtils().displayCreationProperties(this.editingContextAdapter, objectCreated, this.variableManager, this.interpreter);
            }
        } else {
            PapyrusEEFExtEObjectCreationWizard wizard = new PapyrusEEFExtEObjectCreationWizard(this.target, this.eReference, this.editingContextAdapter);
            wizard.setWindowTitle(CREATE_DIALOG_TITLE);
            WizardDialog wizardDialog = new WizardDialog(this.tableViewer.getTable().getShell(), (IWizard)wizard);
            returnCode = wizardDialog.open();
            if (returnCode != 0) {
                throw new OperationCanceledException();
            }
            objectCreated = this.createUmlElement(wizard.getSelectedEContainer(), wizard.getSelectedEContainerFeature(), wizard.getSelectedTypeName());
            if (objectCreated != null) {
                returnCode = this.getController().getPropertiesUtils().displayCreationProperties(this.editingContextAdapter, objectCreated, this.variableManager, this.interpreter);
                if (returnCode != 0) {
                    throw new OperationCanceledException();
                }
                if (!this.eReference.isContainment()) {
                    this.updateTargetReference(objectCreated, false);
                }
            }
        }
        if (returnCode != 0) {
            throw new OperationCanceledException();
        }
        this.refresh();
        this.tableViewer.getTable().deselectAll();
        this.setEnabled(this.isEnabled());
    }

    protected void browseButtonCallback() {
        UMLFilteredLabelProvider labelProvider = new UMLFilteredLabelProvider();
        ReferenceSelector selector = new ReferenceSelector(true);
        selector.setLabelProvider((ILabelProvider)labelProvider);
        CustomUMLContentProvider contentProvider = new CustomUMLContentProvider(this.target, this.eReference);
        selector.setContentProvider((IStaticContentProvider)contentProvider);
        IEvaluationResult labelExpressionEvaluated = this.interpreter.evaluateExpression(this.variableManager.getVariables(), this.getWidgetDescription().getLabelExpression());
        String value = (String)labelExpressionEvaluated.getValue();
        MultipleValueSelectionDialog dialog = new MultipleValueSelectionDialog(Display.getCurrent().getActiveShell(), (IElementSelector)selector, BROWSE_DIALOG_TITLE + value, true, this.eReference.isOrdered()){

            protected MultipleValueSelectionWidget createWidget(IElementSelector selector, boolean unique, boolean ordered, int upperBound) {
                return new CustomMultipleValueSelectionWidget(selector, unique, ordered, upperBound);
            }
        };
        dialog.setLabelProvider((ILabelProvider)labelProvider);
        dialog.setUpperBound(-1);
        dialog.setContextElement((Object)this.target);
        List initialRefElementsList = (List)this.target.eGet((EStructuralFeature)this.eReference);
        ArrayList copyInitialRefElementsList = new ArrayList(initialRefElementsList);
        Object[] initialRefElements = initialRefElementsList.toArray();
        if (initialRefElementsList.isEmpty()) {
            dialog.setInitialSelections(new Object[0]);
        } else {
            dialog.setInitialSelections(initialRefElements);
        }
        if (dialog.open() != 0) {
            throw new OperationCanceledException();
        }
        List<Object> dialogResult = Arrays.asList(dialog.getResult());
        this.updateTargetReference(dialogResult, true);
        ArrayList<Object> newResultedElements = new ArrayList<Object>(dialogResult);
        newResultedElements.removeAll(copyInitialRefElementsList);
        this.refresh();
        this.tableViewer.getTable().deselectAll();
        this.setEnabled(this.isEnabled());
    }

    protected void updateTargetReference(Object newRef, boolean clearList) {
        String browseExpression = Optional.ofNullable(this.getController().getBrowseExpression()).orElse("");
        if (!browseExpression.isEmpty()) {
            this.variableManager.put("selection", newRef);
            EvalFactory.of((IInterpreter)this.interpreter, (IVariableManager)this.variableManager).evaluate(browseExpression);
        } else if (this.eReference.isMany()) {
            Object ref = this.target.eGet((EStructuralFeature)this.eReference);
            if (clearList) {
                ((List)ref).clear();
            }
            if (newRef instanceof List) {
                ((List)ref).addAll((List)newRef);
            } else if (newRef instanceof EObject) {
                ((List)ref).add(newRef);
            }
        } else if (!this.eReference.isMany() && newRef instanceof EObject) {
            this.target.eSet((EStructuralFeature)this.eReference, newRef);
        }
    }

    protected EObject createUmlElement(EObject container, EStructuralFeature eStructuralFeature, String typeName) {
        EObject objectCreated = null;
        String createExpression = Optional.ofNullable(this.getController().getCreateExpression()).orElse("");
        if (!createExpression.isEmpty()) {
            this.variableManager.put("newElementTypeName", (Object)typeName);
            this.variableManager.put("newElementContainer", (Object)container);
            this.variableManager.put("newElementContainerFeatureName", (Object)eStructuralFeature.getName());
            objectCreated = (EObject)EvalFactory.of((IInterpreter)this.interpreter, (IVariableManager)this.variableManager).evaluate(createExpression);
        } else {
            EClassifier eClassifier = UMLPackage.eINSTANCE.getEClassifier(typeName);
            if (eClassifier instanceof EClass) {
                EClass eClass = (EClass)eClassifier;
                objectCreated = UMLFactory.eINSTANCE.create(eClass);
                ContainerUtil.addToContainer((EObject)container, (EStructuralFeature)eStructuralFeature, (Object)objectCreated);
            }
        }
        return objectCreated;
    }

    public void refresh() {
        super.refresh();
        this.setEnabled(this.isEnabled());
    }

    protected void removeButtonCallback() {
        String removeExpression = this.getWidgetDescription().getRemoveExpression();
        if (removeExpression != null && !removeExpression.isBlank()) {
            EvalFactory.of((IInterpreter)this.interpreter, (IVariableManager)this.variableManager).call(removeExpression);
        } else {
            super.removeButtonCallback();
        }
        this.tableViewer.setSelection(null);
        this.refresh();
    }

    protected void moveButtonCallback(EEFExtMultipleReferenceLifecycleManager.Direction direction) {
        super.moveButtonCallback(direction);
        this.refresh();
    }

    private List<Object> selectionToList(ISelection selection) {
        ArrayList<Object> objects = new ArrayList<Object>();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object[] objectArray = structuredSelection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                objects.add(object);
                ++n2;
            }
        }
        return objects;
    }

    private class CustomMultipleValueSelectionWidget
    extends MultipleValueSelectionWidget {
        CustomMultipleValueSelectionWidget(IElementSelector selector, boolean unique, boolean ordered, int upperBound) {
            super(selector, unique, ordered, upperBound);
        }

        protected void createRightButtonsSection(Composite parent) {
            this.rightButtonsSection = new Composite(parent, 0);
            this.rightButtonsSection.setLayout((Layout)new GridLayout(1, true));
            this.up = new Button(this.rightButtonsSection, 8);
            this.up.setImage(ExtendedImageRegistry.INSTANCE.getImage(EEFExtReferenceUIPlugin.getPlugin().getImage("full16/ArrowUp_16x16.gif")));
            this.up.addSelectionListener((SelectionListener)this);
            this.up.setToolTipText(Messages.ReferenceUpButton_tooltipText);
            this.down = new Button(this.rightButtonsSection, 8);
            this.down.setImage(ExtendedImageRegistry.INSTANCE.getImage(EEFExtReferenceUIPlugin.getPlugin().getImage("full16/ArrowDown_16x16.gif")));
            this.down.addSelectionListener((SelectionListener)this);
            this.down.setToolTipText(Messages.ReferenceDownButton_tooltipText);
        }
    }
}

