/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.types.core.registries;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.type.core.IElementMatcher;
import org.eclipse.papyrus.infra.types.AbstractMatcherConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypesConfigurationsPackage;
import org.eclipse.papyrus.infra.types.core.Activator;
import org.eclipse.papyrus.infra.types.core.factories.IMatcherFactory;
import org.eclipse.papyrus.infra.types.core.factories.impl.DefaultMatcherFactory;

public class MatcherConfigurationTypeRegistry {
    private static volatile MatcherConfigurationTypeRegistry registry;
    protected Map<String, IMatcherFactory<? extends AbstractMatcherConfiguration>> matcherConfigurationTypeToFactory = null;

    private MatcherConfigurationTypeRegistry() {
    }

    public static synchronized MatcherConfigurationTypeRegistry getInstance() {
        if (registry == null) {
            registry = new MatcherConfigurationTypeRegistry();
            registry.init();
        }
        return registry;
    }

    protected void init() {
        IConfigurationElement[] elements;
        this.matcherConfigurationTypeToFactory = new HashMap<String, IMatcherFactory<? extends AbstractMatcherConfiguration>>();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.infra.types.core.matcherConfigurationKind");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            String configurationClass = configurationElement.getAttribute("configurationClass");
            try {
                Object factoryClass = configurationElement.createExecutableExtension("factoryClass");
                if (factoryClass instanceof IMatcherFactory) {
                    this.matcherConfigurationTypeToFactory.put(configurationClass, (IMatcherFactory)factoryClass);
                }
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
            ++n2;
        }
        this.matcherConfigurationTypeToFactory.put(ElementTypesConfigurationsPackage.eINSTANCE.getMatcherConfiguration().getInstanceTypeName(), new DefaultMatcherFactory());
    }

    protected <T extends AbstractMatcherConfiguration> IMatcherFactory<T> getFactory(T matcherConfiguration) {
        String matcherConfigurationType = matcherConfiguration.eClass().getInstanceTypeName();
        IMatcherFactory<? extends AbstractMatcherConfiguration> factory = this.matcherConfigurationTypeToFactory.get(matcherConfigurationType);
        return factory;
    }

    public <T extends AbstractMatcherConfiguration> IElementMatcher getMatcher(T matcherConfiguration) {
        if (matcherConfiguration == null) {
            return null;
        }
        IMatcherFactory<T> factory = this.getFactory(matcherConfiguration);
        if (factory == null) {
            DummyElementMatcher matcher = new DummyElementMatcher();
            return matcher;
        }
        IElementMatcher matcher = factory.createElementMatcher(matcherConfiguration);
        return matcher;
    }

    public class DummyElementMatcher
    implements IElementMatcher {
        public boolean matches(EObject eObject) {
            return true;
        }
    }
}

