/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class UMLNattableStereotypeUtils {
    public static final String PROPERTY_OF_STEREOTYPE_PREFIX = "property_of_stereotype:/";

    private UMLNattableStereotypeUtils() {
    }

    public static Property getRealStereotypeProperty(EObject eobject, String id) {
        return UMLNattableStereotypeUtils.getRealStereotypeProperty(eobject, id, null);
    }

    protected static Property getProperty(Collection<Package> packages, String propertyQN) {
        String propertyName = UMLNattableStereotypeUtils.getNameFromQualifiedName(propertyQN);
        String stereotypeQN = UMLNattableStereotypeUtils.getParentQualifiedName(propertyQN);
        String stereotypeName = UMLNattableStereotypeUtils.getNameFromQualifiedName(stereotypeQN);
        String profileQN = UMLNattableStereotypeUtils.getParentQualifiedName(stereotypeQN);
        for (Package package1 : packages) {
            for (Profile prof : package1.getAppliedProfiles()) {
                NamedElement prop;
                NamedElement ste;
                if (prof.getQualifiedName().equals(profileQN) && (ste = prof.getMember(stereotypeName)) instanceof Stereotype && (prop = ((Stereotype)ste).getMember(propertyName)) instanceof Property && prop.getQualifiedName().equals(propertyQN)) {
                    return (Property)prop;
                }
                Property p = UMLNattableStereotypeUtils.getProperty((Collection<Package>)package1.getNestedPackages(), propertyQN);
                if (p == null) continue;
                return p;
            }
        }
        return null;
    }

    public static Property getRealStereotypeProperty(EObject eobject, String id, Map<?, ?> sharedMap) {
        Property result = null;
        Assert.isTrue((boolean)id.startsWith(PROPERTY_OF_STEREOTYPE_PREFIX));
        if (eobject instanceof Element) {
            Element element = (Element)eobject;
            String propertyQN = id.replace(PROPERTY_OF_STEREOTYPE_PREFIX, "");
            Package nearestPackage = null;
            if (sharedMap != null) {
                Element context = (Element)sharedMap.get("pastedElementContainer");
                nearestPackage = context.getNearestPackage();
            } else {
                nearestPackage = element.getNearestPackage();
            }
            if (nearestPackage != null) {
                Iterator appliedProfilesIterator = nearestPackage.getAllAppliedProfiles().iterator();
                while (appliedProfilesIterator.hasNext() && result == null) {
                    Profile appliedProfile = (Profile)appliedProfilesIterator.next();
                    Iterator<Stereotype> stereotypesIterator = UMLNattableStereotypeUtils.getAllStereotypes(appliedProfile).iterator();
                    while (stereotypesIterator.hasNext() && result == null) {
                        Stereotype ownedStereotype = stereotypesIterator.next();
                        Iterator propertiesIterator = ownedStereotype.getAllAttributes().iterator();
                        while (propertiesIterator.hasNext() && result == null) {
                            Property property = (Property)propertiesIterator.next();
                            if (!property.getQualifiedName().equals(propertyQN)) continue;
                            result = property;
                        }
                    }
                }
                if (result == null) {
                    result = UMLNattableStereotypeUtils.getProperty((Collection<Package>)element.getNearestPackage().getNestedPackages(), propertyQN);
                }
            }
        }
        return result;
    }

    public static List<Stereotype> getAllStereotypes(Profile profile) {
        ArrayList<Stereotype> stereotypes = new ArrayList<Stereotype>((Collection<Stereotype>)profile.getOwnedStereotypes());
        stereotypes.addAll(UMLNattableStereotypeUtils.getStereotypeInMembers((List<NamedElement>)profile.getOwnedMembers()));
        return stereotypes;
    }

    protected static List<Stereotype> getStereotypeInMembers(List<NamedElement> members) {
        ArrayList<Stereotype> stereotypes = new ArrayList<Stereotype>();
        for (NamedElement member : members) {
            if (member instanceof Package) {
                stereotypes.addAll((Collection<Stereotype>)((Package)member).getOwnedStereotypes());
            }
            if (!(member instanceof Namespace)) continue;
            stereotypes.addAll(UMLNattableStereotypeUtils.getStereotypeInMembers((List<NamedElement>)((Namespace)member).getOwnedMembers()));
        }
        return stereotypes;
    }

    public static String getNameFromQualifiedName(String qualifiedName) {
        String name = qualifiedName.substring(qualifiedName.lastIndexOf("::") + "::".length());
        return name != null ? name : "";
    }

    public static String getParentQualifiedName(String childQualifiedName) {
        String childName = UMLNattableStereotypeUtils.getNameFromQualifiedName(childQualifiedName);
        String parentQualifiedName = childQualifiedName.substring(0, childQualifiedName.length() - ("::".length() + childName.length()));
        return parentQualifiedName != null ? parentQualifiedName : "";
    }
}

