/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors.richtext;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.papyrus.infra.widgets.Activator;

class SpellChecker {
    private final HashMap<String, Integer> nWords = new HashMap();

    public SpellChecker() throws URISyntaxException, IOException {
        URL fileURL = Activator.getDefault().getURL("org.eclipse.papyrus.infra.widgets", "files/dictionary.txt");
        File file = null;
        file = new File(FileLocator.resolve((URL)fileURL).toURI());
        BufferedReader in = new BufferedReader(new FileReader(file));
        Pattern p = Pattern.compile("\\w+");
        String temp = "";
        while (temp != null) {
            Matcher m = p.matcher(temp.toLowerCase());
            while (m.find()) {
                this.nWords.put(temp, this.nWords.containsKey(temp = m.group()) ? this.nWords.get(temp) + 1 : 1);
            }
            temp = in.readLine();
        }
        in.close();
    }

    public boolean isInDictionary(String word) {
        return this.nWords.containsKey(word);
    }

    private final ArrayList<String> edits(String word) {
        char c;
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < word.length()) {
            result.add(word.substring(0, i) + word.substring(i + 1));
            ++i;
        }
        i = 0;
        while (i < word.length() - 1) {
            result.add(word.substring(0, i) + word.substring(i + 1, i + 2) + word.substring(i, i + 1) + word.substring(i + 2));
            ++i;
        }
        i = 0;
        while (i < word.length()) {
            c = 'a';
            while (c <= 'z') {
                result.add(word.substring(0, i) + String.valueOf(c) + word.substring(i + 1));
                c = (char)(c + '\u0001');
            }
            ++i;
        }
        i = 0;
        while (i <= word.length()) {
            c = 'a';
            while (c <= 'z') {
                result.add(word.substring(0, i) + String.valueOf(c) + word.substring(i));
                c = (char)(c + '\u0001');
            }
            ++i;
        }
        return result;
    }

    public final String correct(String word) {
        if (this.nWords.containsKey(word)) {
            return word;
        }
        ArrayList<String> list = this.edits(word);
        HashMap<Integer, String> candidates = new HashMap<Integer, String>();
        for (String s : list) {
            if (!this.nWords.containsKey(s)) continue;
            candidates.put(this.nWords.get(s), s);
        }
        if (candidates.size() > 0) {
            return (String)candidates.get(Collections.max(candidates.keySet()));
        }
        for (String s : list) {
            for (String w : this.edits(s)) {
                if (!this.nWords.containsKey(w)) continue;
                candidates.put(this.nWords.get(w), w);
            }
        }
        return candidates.size() > 0 ? (String)candidates.get(Collections.max(candidates.keySet())) : word;
    }

    public final HashMap<Integer, String> suggestions(String word) {
        if (this.nWords.containsKey(word)) {
            HashMap<Integer, String> wordMap = new HashMap<Integer, String>();
            wordMap.put(1, word);
            return wordMap;
        }
        ArrayList<String> list = this.edits(word);
        HashMap<Integer, String> candidates = new HashMap<Integer, String>();
        for (String s : list) {
            if (!this.nWords.containsKey(s)) continue;
            candidates.put(this.nWords.get(s), s);
        }
        if (candidates.size() > 0) {
            return candidates;
        }
        for (String s : list) {
            for (String w : this.edits(s)) {
                if (!this.nWords.containsKey(w)) continue;
                candidates.put(this.nWords.get(w), w);
            }
        }
        return candidates;
    }
}

