/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.fillhandle.action;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.copy.InternalCellClipboard;
import org.eclipse.nebula.widgets.nattable.copy.command.CopyDataToClipboardCommand;
import org.eclipse.nebula.widgets.nattable.fillhandle.action.FillHandleActionHelper;
import org.eclipse.nebula.widgets.nattable.fillhandle.command.FillHandlePasteCommand;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.ui.action.IMouseAction;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Menu;

public class FillHandleColumnAction
implements IMouseAction {
    protected SelectionLayer selectionLayer;
    protected InternalCellClipboard clipboard;
    protected Menu menu;

    public FillHandleColumnAction(SelectionLayer selectionLayer, InternalCellClipboard clipboard) {
        if (selectionLayer == null) {
            throw new IllegalArgumentException("SelectionLayer can not be null");
        }
        this.selectionLayer = selectionLayer;
        this.clipboard = clipboard;
    }

    @Override
    public void run(NatTable natTable, MouseEvent event) {
        if (this.selectionLayer.hasColumnSelection()) {
            if (natTable.doCommand(new CopyDataToClipboardCommand("\t", System.getProperty("line.separator"), natTable.getConfigRegistry()))) {
                int startRow = this.selectionLayer.getSelectedRowPositions().iterator().next().start;
                Rectangle region = new Rectangle(this.selectionLayer.getSelectedColumnPositions()[0], startRow, this.selectionLayer.getSelectedColumnPositions().length, this.selectionLayer.getRowCount() - startRow);
                this.selectionLayer.setFillHandleRegion(region);
                if (this.clipboard != null) {
                    if (this.showMenu(natTable)) {
                        this.openMenu(natTable);
                    } else {
                        natTable.doCommand(new FillHandlePasteCommand(FillHandlePasteCommand.FillHandleOperation.COPY, SelectionLayer.MoveDirectionEnum.DOWN, natTable.getConfigRegistry()));
                        this.reset(natTable);
                    }
                } else {
                    natTable.doCommand(new FillHandlePasteCommand(FillHandlePasteCommand.FillHandleOperation.COPY, SelectionLayer.MoveDirectionEnum.DOWN, natTable.getConfigRegistry()));
                    this.reset(natTable);
                }
            } else {
                this.reset(natTable);
            }
        }
    }

    protected boolean showMenu(NatTable natTable) {
        return FillHandleActionHelper.showMenu(natTable, this.clipboard);
    }

    protected void openMenu(NatTable natTable) {
        if (this.menu == null || this.menu.isDisposed()) {
            this.menu = FillHandleActionHelper.createFillHandleMenu(natTable, () -> SelectionLayer.MoveDirectionEnum.DOWN, n -> this.reset((NatTable)n));
        }
        this.menu.setVisible(true);
    }

    protected void reset(NatTable natTable) {
        this.selectionLayer.setFillHandleRegion(null);
        this.clipboard.clear();
        if (!natTable.isDisposed()) {
            natTable.redraw();
        }
    }
}

