/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml16.requirementsextension.internal.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.papyrus.sysml16.requirementsextension.DesignConstraint;
import org.eclipse.papyrus.sysml16.requirementsextension.FunctionalRequirement;
import org.eclipse.papyrus.sysml16.requirementsextension.InterfaceRequirement;
import org.eclipse.papyrus.sysml16.requirementsextension.PerformanceRequirement;
import org.eclipse.papyrus.sysml16.requirementsextension.PhysicalRequirement;
import org.eclipse.papyrus.sysml16.requirementsextension.RequirementsExtensionFactory;
import org.eclipse.papyrus.sysml16.requirementsextension.RequirementsExtensionPackage;
import org.eclipse.papyrus.sysml16.requirementsextension.RiskKind;
import org.eclipse.papyrus.sysml16.requirementsextension.VerificationMethodKind;
import org.eclipse.papyrus.sysml16.requirementsextension.internal.impl.DesignConstraintImpl;
import org.eclipse.papyrus.sysml16.requirementsextension.internal.impl.FunctionalRequirementImpl;
import org.eclipse.papyrus.sysml16.requirementsextension.internal.impl.InterfaceRequirementImpl;
import org.eclipse.papyrus.sysml16.requirementsextension.internal.impl.PerformanceRequirementImpl;
import org.eclipse.papyrus.sysml16.requirementsextension.internal.impl.PhysicalRequirementImpl;

public class RequirementsExtensionFactoryImpl
extends EFactoryImpl
implements RequirementsExtensionFactory {
    public static RequirementsExtensionFactory init() {
        try {
            RequirementsExtensionFactory theRequirementsExtensionFactory = (RequirementsExtensionFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/papyrus/SysML/1.6/RequirementsExtension");
            if (theRequirementsExtensionFactory != null) {
                return theRequirementsExtensionFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new RequirementsExtensionFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 1: {
                return this.createFunctionalRequirement();
            }
            case 2: {
                return this.createInterfaceRequirement();
            }
            case 3: {
                return this.createPerformanceRequirement();
            }
            case 4: {
                return this.createPhysicalRequirement();
            }
            case 5: {
                return this.createDesignConstraint();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 6: {
                return this.createRiskKindFromString(eDataType, initialValue);
            }
            case 7: {
                return this.createVerificationMethodKindFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 6: {
                return this.convertRiskKindToString(eDataType, instanceValue);
            }
            case 7: {
                return this.convertVerificationMethodKindToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public FunctionalRequirement createFunctionalRequirement() {
        FunctionalRequirementImpl functionalRequirement = new FunctionalRequirementImpl();
        return functionalRequirement;
    }

    @Override
    public InterfaceRequirement createInterfaceRequirement() {
        InterfaceRequirementImpl interfaceRequirement = new InterfaceRequirementImpl();
        return interfaceRequirement;
    }

    @Override
    public PerformanceRequirement createPerformanceRequirement() {
        PerformanceRequirementImpl performanceRequirement = new PerformanceRequirementImpl();
        return performanceRequirement;
    }

    @Override
    public PhysicalRequirement createPhysicalRequirement() {
        PhysicalRequirementImpl physicalRequirement = new PhysicalRequirementImpl();
        return physicalRequirement;
    }

    @Override
    public DesignConstraint createDesignConstraint() {
        DesignConstraintImpl designConstraint = new DesignConstraintImpl();
        return designConstraint;
    }

    public RiskKind createRiskKindFromString(EDataType eDataType, String initialValue) {
        RiskKind result = RiskKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertRiskKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public VerificationMethodKind createVerificationMethodKindFromString(EDataType eDataType, String initialValue) {
        VerificationMethodKind result = VerificationMethodKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertVerificationMethodKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public RequirementsExtensionPackage getRequirementsExtensionPackage() {
        return (RequirementsExtensionPackage)this.getEPackage();
    }

    @Deprecated
    public static RequirementsExtensionPackage getPackage() {
        return RequirementsExtensionPackage.eINSTANCE;
    }
}

