/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml16.diagram.common.css.dom;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementMatcher;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.gmf.runtime.notation.BasicCompartment;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.css.dom.GMFElementAdapter;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ExtendedCSSEngine;
import org.eclipse.papyrus.infra.tools.util.ListHelper;
import org.eclipse.papyrus.sysml16.deprecatedelements.FlowPort;
import org.eclipse.papyrus.sysml16.deprecatedelements.FlowSpecification;
import org.eclipse.papyrus.sysml16.diagram.common.css.helper.CSSDOMSYSMLSemanticElementHelper;
import org.eclipse.papyrus.sysml16.portsandflows.FlowDirectionKind;
import org.eclipse.papyrus.sysml16.portsandflows.FlowProperty;
import org.eclipse.papyrus.sysml16.portsandflows.FullPort;
import org.eclipse.papyrus.sysml16.portsandflows.ProxyPort;
import org.eclipse.papyrus.sysml16.util.DeprecatedElementUtil;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.helper.StereotypeDisplayUtil;
import org.eclipse.uml2.uml.AcceptEventAction;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.TimeEvent;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.util.UMLUtil;

public class GMFSYSMLElementAdapter
extends GMFElementAdapter {
    private static final String STEREOTYPE_COMMENT = "StereotypeComment";
    public final StereotypeDisplayUtil stereotypeHelper = StereotypeDisplayUtil.getInstance();
    private static final String IS_CONSTRAINT = "isConstraint";
    private static final String IS_PART = "isPart";
    private static final String IS_REFERENCE = "isReference";
    public static final String APPLIED_STEREOTYPES_PROPERTY = "appliedStereotypes";
    private static final String TYPE_APPLIED_STEREOTYPES_PROPERTY = "typeAppliedStereotypes";
    public static final String DEPRECATED = "deprecated";
    private static final String IS_ABSTRACT = "isAbstract";
    private static final String IS_TIME_EVENT_ACTION_PROPERTY = "isTimeEventAction";
    public static final String IS_FRAME = "isFrame";
    public static final String PORT_DIRECTION = "portDirection";
    public static final String PORT_DIR_NA = "portDirNA";
    public static final String QUALIFIER_SEPARATOR = "--";

    public GMFSYSMLElementAdapter(View view, ExtendedCSSEngine engine) {
        super(view, engine);
        this.helper = CSSDOMSYSMLSemanticElementHelper.getInstance();
    }

    protected String doGetAttribute(String attr) {
        String value;
        String parentValue = super.doGetAttribute(attr);
        if (parentValue != null) {
            return parentValue;
        }
        if (IS_ABSTRACT.equals(attr)) {
            return null;
        }
        if (this.stereotypeHelper.isStereotypeLabel((Object)this.semanticElement) && (value = this.getStereotypeLabelAttribute(attr)) != null && !value.isEmpty()) {
            return value;
        }
        if ((this.stereotypeHelper.isStereotypeCompartment((Object)this.semanticElement) || this.stereotypeHelper.isStereotypeBrace((Object)this.semanticElement)) && (value = this.getStereotypeCompartmentAttribute(attr)) != null && !value.isEmpty()) {
            return value;
        }
        if ((this.stereotypeHelper.isStereotypeProperty((Object)this.semanticElement) || this.stereotypeHelper.isStereotypeBraceProperty((Object)this.semanticElement)) && (value = this.getStereotypePropertyAttribute(attr)) != null && !value.isEmpty()) {
            return value;
        }
        if (this.semanticElement instanceof Element) {
            Object appliedStereotypes;
            Type type;
            String portDir;
            Element currentElement = (Element)this.semanticElement;
            if (DEPRECATED.equals(attr)) {
                return String.valueOf(DeprecatedElementUtil.isDeprecatedElement((EObject)this.semanticElement));
            }
            boolean isProperty = this.semanticElement instanceof Property;
            if (IS_CONSTRAINT.equals(attr) && isProperty) {
                IElementMatcher constraint = ((ISpecializationType)ElementTypeRegistry.getInstance().getType("org.eclipse.papyrus.SysML16.ConstraintProperty")).getMatcher();
                return String.valueOf(constraint.matches(this.semanticElement));
            }
            if (IS_PART.equals(attr) && isProperty) {
                IElementMatcher part = ((ISpecializationType)ElementTypeRegistry.getInstance().getType("org.eclipse.papyrus.SysML16.Part")).getMatcher();
                return String.valueOf(part.matches(this.semanticElement));
            }
            if (IS_REFERENCE.equals(attr) && isProperty) {
                IElementMatcher reference = ((ISpecializationType)ElementTypeRegistry.getInstance().getType("org.eclipse.papyrus.SysML16.Reference")).getMatcher();
                return String.valueOf(reference.matches(this.semanticElement));
            }
            if (PORT_DIRECTION.equals(attr) && this.semanticElement instanceof Port && (portDir = this.getPortDirection((Port)this.semanticElement)) != null) {
                return portDir;
            }
            if (APPLIED_STEREOTYPES_PROPERTY.equals(attr)) {
                LinkedList<String> appliedStereotypes2 = new LinkedList<String>();
                for (Stereotype stereotype : currentElement.getAppliedStereotypes()) {
                    appliedStereotypes2.add(stereotype.getName());
                    appliedStereotypes2.add(stereotype.getQualifiedName());
                }
                if (!appliedStereotypes2.isEmpty()) {
                    return ListHelper.deepToString(appliedStereotypes2, (String)" ");
                }
                return null;
            }
            if (TYPE_APPLIED_STEREOTYPES_PROPERTY.equals(attr) && this.semanticElement instanceof TypedElement && (type = ((TypedElement)this.semanticElement).getType()) != null) {
                appliedStereotypes = new LinkedList();
                for (Stereotype stereotype : type.getAppliedStereotypes()) {
                    appliedStereotypes.add(stereotype.getName());
                    appliedStereotypes.add(stereotype.getQualifiedName());
                }
                if (!appliedStereotypes.isEmpty()) {
                    return ListHelper.deepToString((List)appliedStereotypes, (String)" ");
                }
            }
            if ((appliedStereotypes = currentElement.getStereotypeApplications().iterator()).hasNext()) {
                EObject stereotypeApplication = (EObject)appliedStereotypes.next();
                EStructuralFeature feature = stereotypeApplication.eClass().getEStructuralFeature(attr);
                if (feature != null) {
                    if (feature.isMany()) {
                        List values = (List)stereotypeApplication.eGet(feature);
                        LinkedList<String> cssValues = new LinkedList<String>();
                        for (Object value2 : values) {
                            cssValues.add(this.getCSSValue(feature, value2));
                        }
                        return ListHelper.deepToString(cssValues, (String)" ");
                    }
                    Object value3 = stereotypeApplication.eGet(feature);
                    return this.getCSSValue(feature, value3);
                }
                return null;
            }
            if (attr.contains(QUALIFIER_SEPARATOR)) {
                EObject stereotypeApplication;
                EStructuralFeature feature;
                List qualifiers = ListHelper.asList((Object[])attr.split(QUALIFIER_SEPARATOR));
                String propertyName = (String)qualifiers.remove(qualifiers.size() - 1);
                String stereotypeName = ListHelper.deepToString((List)qualifiers, (String)"::");
                Stereotype appliedStereotype = currentElement.getAppliedStereotype(stereotypeName);
                if (appliedStereotype != null && (feature = (stereotypeApplication = currentElement.getStereotypeApplication(appliedStereotype)).eClass().getEStructuralFeature(propertyName)) != null) {
                    Object value4 = stereotypeApplication.eGet(feature);
                    return this.getCSSValue(feature, value4);
                }
            }
            if (IS_TIME_EVENT_ACTION_PROPERTY.equals(attr) && this.semanticElement instanceof AcceptEventAction) {
                return String.valueOf(this.isAcceptTimeEventAction((AcceptEventAction)this.semanticElement));
            }
            if (IS_FRAME.equals(attr)) {
                if (this.notationElement.eContainer() == this.notationElement.getDiagram()) {
                    return String.valueOf(true);
                }
                return String.valueOf(false);
            }
        }
        return null;
    }

    protected String getStereotypeCompartmentAttribute(String attr) {
        if ("stereotype".equals(attr)) {
            BasicCompartment propertyCompartment = (BasicCompartment)this.semanticElement;
            return this.stereotypeHelper.getName(propertyCompartment);
        }
        return "";
    }

    protected String getStereotypePropertyAttribute(String attr) {
        EObject propertyCompartment;
        if ("property".equals(attr)) {
            DecorationNode propertyLabel = (DecorationNode)this.semanticElement;
            if (propertyLabel.getElement() instanceof Property) {
                Property prop = (Property)propertyLabel.getElement();
                return prop.getName();
            }
        } else if ("stereotype".equals(attr) && this.stereotypeHelper.isStereotypeCompartment((Object)(propertyCompartment = ((DecorationNode)this.semanticElement).eContainer()))) {
            return this.stereotypeHelper.getName((DecorationNode)propertyCompartment);
        }
        return "";
    }

    protected String getStereotypeLabelAttribute(String attr) {
        if ("stereotype".equals(attr)) {
            DecorationNode label = (DecorationNode)this.semanticElement;
            return this.stereotypeHelper.getName(label);
        }
        if ("kind".equals(attr) && this.stereotypeHelper.isStereotypeLabel((Object)this.semanticElement)) {
            return "StereotypeLabel";
        }
        return null;
    }

    protected String getCSSValue(EStructuralFeature feature, Object value) {
        if (feature instanceof EReference && value instanceof NamedElement) {
            String name = ((NamedElement)value).getName();
            return name == null || name.isEmpty() ? " " : name;
        }
        return super.getCSSValue(feature, value);
    }

    public String getLocalName() {
        if (this.localName == null && this.stereotypeHelper.isStereotypeComment((Object)this.getNotationElement())) {
            return STEREOTYPE_COMMENT;
        }
        return super.getLocalName();
    }

    public boolean isAcceptTimeEventAction(AcceptEventAction action) {
        boolean hasTimeEvent = false;
        boolean hasOthersTriggers = false;
        if (action.getTriggers() != null) {
            for (Trigger trigger : action.getTriggers()) {
                if (trigger == null) continue;
                Event event = trigger.getEvent();
                if (event instanceof TimeEvent) {
                    hasTimeEvent = true;
                    continue;
                }
                hasOthersTriggers = true;
            }
        }
        return hasTimeEvent && !hasOthersTriggers;
    }

    protected String getPortDirection(Port port) {
        FlowPort flowPort = (FlowPort)UMLUtil.getStereotypeApplication((Element)port, FlowPort.class);
        Type type = port.getType();
        if (flowPort != null) {
            FlowDirectionKind fd;
            FlowSpecification flowSpec;
            if (flowPort.isAtomic()) {
                return flowPort.getDirection().getLiteral();
            }
            if (type instanceof Interface && (flowSpec = (FlowSpecification)UMLUtil.getStereotypeApplication((Element)port, FlowSpecification.class)) != null && (fd = this.getDirectionFromFlowProperties((List<Property>)flowSpec.getFlowProperties())) != null) {
                return fd.getLiteral();
            }
            return PORT_DIR_NA;
        }
        FullPort fullPort = (FullPort)UMLUtil.getStereotypeApplication((Element)port, FullPort.class);
        ProxyPort proxyPort = (ProxyPort)UMLUtil.getStereotypeApplication((Element)port, ProxyPort.class);
        if (fullPort != null || proxyPort != null) {
            Class clazz;
            FlowDirectionKind fd;
            if (type instanceof Class && (fd = this.getDirectionFromFlowProperties((List<Property>)(clazz = (Class)type).allAttributes())) != null) {
                return fd.getLiteral();
            }
            return PORT_DIR_NA;
        }
        return null;
    }

    protected FlowDirectionKind getDirectionFromFlowProperties(List<Property> propertyList) {
        FlowDirectionKind fd = null;
        for (Property flowProperty : propertyList) {
            FlowProperty fp = (FlowProperty)UMLUtil.getStereotypeApplication((Element)flowProperty, FlowProperty.class);
            if (fp == null) continue;
            if (fd == null) {
                fd = fp.getDirection();
                continue;
            }
            if (fd == FlowDirectionKind.INOUT || fd == fp.getDirection()) continue;
            fd = FlowDirectionKind.INOUT;
        }
        return fd;
    }
}

