/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.reverse.utils;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.papyrus.robotics.core.utils.PortUtils;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentPort;
import org.eclipse.papyrus.robotics.ros2.reverse.PortInfo;
import org.eclipse.papyrus.robotics.ros2.reverse.utils.ReverseUtils;
import org.eclipse.papyrus.robotics.ros2.reverse.utils.ServiceDefUtils;
import org.eclipse.papyrus.uml.diagram.wizards.Activator;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Port;

public class CreatePortUtils {
    public static Port createPort(Class component, PortInfo pi, Interface sd) {
        try {
            Port port = component.createOwnedPort(pi.topic, null);
            ReverseUtils.setXmlID((NamedElement)port);
            port.setAggregation(AggregationKind.COMPOSITE_LITERAL);
            ComponentPort portSt = (ComponentPort)StereotypeUtil.applyApp((Element)port, ComponentPort.class);
            ICommand csCmd = PortUtils.associateCSCommand((Port)port);
            csCmd.execute(null, null);
            Class cs = (Class)port.getType();
            if (sd != null) {
                if (ServiceDefUtils.isProvided(pi.pk)) {
                    cs.createInterfaceRealization(null, sd);
                } else {
                    cs.createUsage((NamedElement)sd);
                }
            }
            portSt.setQos(pi.qos);
            return port;
        }
        catch (ExecutionException e) {
            Activator.log.error((Throwable)e);
            return null;
        }
    }
}

