/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.base;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.designer.infra.base.StringUtils;
import org.eclipse.papyrus.robotics.ros2.base.Activator;
import org.eclipse.papyrus.robotics.ros2.base.ProcessUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class EnvironmentUtils {
    public static final String BASH_ENV = "BASH_ENV";
    public static final String PATH = "PATH";
    public static final String ROS_PREFIX = "ROS_";
    public static final String DECLARE_X = "declare -x";
    protected static Map<String, String> localEnv = null;
    protected static Job setupJob;
    public static final List<String> checkValues;

    static {
        checkValues = Lists.newArrayList((Object[])new String[]{"CMAKE_PREFIX_PATH", "AMENT_PREFIX_PATH", "PYTHONPATH", PATH, "LD_LIBRARY_PATH"});
    }

    public static Map<String, String> getenv() {
        if (localEnv == null) {
            localEnv = new HashMap<String, String>();
            localEnv.putAll(System.getenv());
        }
        return localEnv;
    }

    public static String get(String key) {
        return EnvironmentUtils.getenv().get(key);
    }

    public static void runCheckAndApplySetupJob(final String pathList) {
        setupJob = new Job("check environment"){

            public IStatus run(IProgressMonitor monitor) {
                boolean ok = EnvironmentUtils.checkAndApplySetup(pathList, monitor);
                setupJob = null;
                if (ok) {
                    return Status.OK_STATUS;
                }
                return Status.CANCEL_STATUS;
            }
        };
        setupJob.schedule();
    }

    public static void waitForSetupJob() {
        if (setupJob != null) {
            try {
                setupJob.join();
            }
            catch (InterruptedException e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    public static boolean checkAndApplySetup(String pathList, IProgressMonitor monitor) {
        if (pathList.length() == 0) {
            return true;
        }
        String[] pathListArray = pathList.split(File.pathSeparator);
        EnvironmentUtils.resetEnvironment();
        monitor.beginTask("source setup.file", pathListArray.length);
        String[] stringArray = pathListArray;
        int n = pathListArray.length;
        int n2 = 0;
        while (n2 < n) {
            final String setupPath = stringArray[n2];
            String setupFile = setupPath + "/setup.bash";
            monitor.subTask(setupFile);
            if (new File(setupFile).exists()) {
                EnvironmentUtils.sourceScript(setupFile);
            } else {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell shell = Display.getCurrent().getActiveShell();
                        MessageDialog.openInformation((Shell)shell, (String)"ROS setup", (String)String.format("Papyrus for Robotics could not find a setup.bash file at location (%s). Please verify the PATH in the ROS 2 preferences.\n=> Window => Preferences => type \"ros\" in filter => setup path list.", setupPath));
                    }
                });
            }
            if (monitor.isCanceled()) {
                return false;
            }
            monitor.worked(1);
            ++n2;
        }
        return true;
    }

    public static void resetEnvironment() {
        if (localEnv != null) {
            for (String var : System.getenv().keySet()) {
                if (!var.startsWith(ROS_PREFIX) && !checkValues.contains(var)) continue;
                String value = System.getenv(var);
                localEnv.put(var, value);
            }
        }
    }

    public static void selectAndSourceScript(String initialFile, Shell shell) {
        if (shell != null) {
            FileDialog fd = new FileDialog(shell, 4096);
            fd.setText("Open");
            String[] filterExt = new String[]{"*.bash;*.sh"};
            String[] filterNames = new String[]{"setup files"};
            fd.setFilterExtensions(filterExt);
            fd.setFilterNames(filterNames);
            fd.setFileName(initialFile);
            String fileName = fd.open();
            if (fileName != null) {
                EnvironmentUtils.sourceScript(fileName);
            }
        }
    }

    public static void sourceWorkspace() {
        Object fileName = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
        if (new File((String)(fileName = (String)fileName + "/install/setup.bash")).exists()) {
            EnvironmentUtils.sourceScript((String)fileName);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void sourceScript(String scriptFile) {
        ProcessBuilder pb = new ProcessBuilder("bash", "-c", "export");
        Map<String, String> pbEnv = pb.environment();
        pbEnv.put(BASH_ENV, scriptFile);
        pbEnv.putAll(EnvironmentUtils.getenv());
        try {
            Process p = pb.start();
            BufferedReader results = new BufferedReader(new InputStreamReader(p.getInputStream()));
            boolean error = ProcessUtils.logErrors(p);
            if (error) {
                return;
            }
            while (true) {
                String line;
                if ((line = results.readLine()) == null) {
                    return;
                }
                String[] lineArray = (line = line.substring(DECLARE_X.length())).split("=");
                if (lineArray.length != 2) continue;
                String var = lineArray[0].trim();
                String value = StringUtils.unquote((String)lineArray[1]);
                if (!var.startsWith(ROS_PREFIX) && !checkValues.contains(var)) continue;
                localEnv.put(var, value);
            }
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
    }

    public static String getFromPath(String executable) {
        String path = EnvironmentUtils.get(PATH);
        if (path != null) {
            String[] pathParts;
            String[] stringArray = pathParts = path.split(File.pathSeparator);
            int n = pathParts.length;
            int n2 = 0;
            while (n2 < n) {
                String pathPart = stringArray[n2];
                File file = new File(pathPart + File.separator + executable);
                if (file.exists()) {
                    return file.getAbsolutePath();
                }
                ++n2;
            }
        }
        return null;
    }
}

