/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.codegen.common.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.designer.transformation.base.utils.ModelManagement;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.transformation.core.transformations.TransformationContext;
import org.eclipse.papyrus.designer.uml.tools.utils.PackageUtil;
import org.eclipse.papyrus.designer.uml.tools.utils.StereotypeUtil;
import org.eclipse.papyrus.robotics.core.utils.ScanUtils;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentDefinitionModel;
import org.eclipse.papyrus.robotics.profile.robotics.components.SystemComponentArchitectureModel;
import org.eclipse.papyrus.robotics.profile.robotics.services.ServiceDefinitionModel;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class PackageTools {
    public static String pkgName(Package model) {
        try {
            if (model == null) {
                throw new TransformationException("pkgName is invoked with a null model (internal generator error)");
            }
            boolean _isApplied = StereotypeUtil.isApplied((Element)model, ServiceDefinitionModel.class);
            if (_isApplied) {
                return model.getName().toLowerCase();
            }
            ComponentDefinitionModel compDefModel = (ComponentDefinitionModel)UMLUtil.getStereotypeApplication((Element)model, ComponentDefinitionModel.class);
            if (compDefModel != null && compDefModel.isExternal()) {
                return model.getName().toLowerCase();
            }
            return PackageTools.getProjectName(model).toLowerCase();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static Class findOrCopyCompDef(Resource srcCompRes) {
        Class compDef = ScanUtils.getCompFromResource((Resource)srcCompRes);
        if (compDef != null) {
            EList _additionalRootPkgs = TransformationContext.current.copier.getAdditionalRootPkgs();
            ArrayList<ModelManagement> mmList = new ArrayList<ModelManagement>((Collection<ModelManagement>)_additionalRootPkgs);
            mmList.add(TransformationContext.current.mm);
            for (ModelManagement pkg : mmList) {
                Class compDefCandidate;
                boolean _isApplied = StereotypeUtil.isApplied((Element)pkg.getModel(), ComponentDefinitionModel.class);
                if (!_isApplied || (compDefCandidate = ScanUtils.getCompFromResource((Resource)pkg.getModel().eResource())) == null || !Objects.equals(compDefCandidate.getName(), compDef.getName())) continue;
                return compDefCandidate;
            }
            return (Class)TransformationContext.current.copier.getCopy((Element)compDef);
        }
        return null;
    }

    public static Class findOrCopySystem(Resource srcSystemRes) {
        Class system = ScanUtils.getSystemFromResource((Resource)srcSystemRes);
        if (system != null) {
            EList _additionalRootPkgs = TransformationContext.current.copier.getAdditionalRootPkgs();
            ArrayList<ModelManagement> mmList = new ArrayList<ModelManagement>((Collection<ModelManagement>)_additionalRootPkgs);
            mmList.add(TransformationContext.current.mm);
            for (ModelManagement pkg : mmList) {
                Class systemCandidate;
                boolean _isApplied = StereotypeUtil.isApplied((Element)pkg.getModel(), SystemComponentArchitectureModel.class);
                if (!_isApplied || (systemCandidate = ScanUtils.getSystemFromResource((Resource)pkg.getModel().eResource())) == null || !Objects.equals(systemCandidate.getName(), system.getName())) continue;
                return systemCandidate;
            }
            return (Class)TransformationContext.current.copier.getCopy((Element)system);
        }
        return null;
    }

    public static ArrayList<Class> getCompDefs(IProject project) {
        try {
            ArrayList compDefsURIs = new ArrayList();
            ArrayList<Class> compDefs = new ArrayList<Class>();
            ScanUtils.processContainer((IContainer)project, (String)".compdef.uml", compDefsURIs);
            ResourceSet srcRS = TransformationContext.current.copier.source.eResource().getResourceSet();
            for (URI compDefURI : compDefsURIs) {
                Package root;
                ComponentDefinitionModel cdm;
                Resource srcCompRes = srcRS.getResource(compDefURI, true);
                Class compDef = PackageTools.findOrCopyCompDef(srcCompRes);
                if (compDef == null || (cdm = (ComponentDefinitionModel)UMLUtil.getStereotypeApplication((Element)(root = PackageUtil.getRootPackage((Element)compDef)), ComponentDefinitionModel.class)) == null || cdm.isExternal()) continue;
                compDefs.add(compDef);
            }
            return compDefs;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static Class getSystem(IProject project) {
        try {
            ArrayList systemURIs = new ArrayList();
            ScanUtils.processContainer((IContainer)project, (String)".system.uml", systemURIs);
            ResourceSet srcRS = TransformationContext.current.copier.source.eResource().getResourceSet();
            boolean _hasNext = systemURIs.iterator().hasNext();
            if (_hasNext) {
                URI systemURI = (URI)systemURIs.iterator().next();
                Resource srcSystemRes = srcRS.getResource(systemURI, true);
                return PackageTools.findOrCopySystem(srcSystemRes);
            }
            return null;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static String getProjectName(Package pkg) {
        try {
            boolean _tripleEquals;
            Resource _eResource = pkg.eResource();
            boolean bl = _tripleEquals = _eResource == null;
            if (_tripleEquals) {
                String _name = pkg.getName();
                String _plus = "Package " + _name;
                String _plus_1 = _plus + " is not in a resource - proxy?";
                throw new TransformationException(_plus_1);
            }
            URI uri = pkg.eResource().getURI();
            if (uri.isPlatformResource() || uri.isPlatformPlugin()) {
                boolean _greaterThan;
                int _size = ((List)Conversions.doWrapArray((Object)uri.segments())).size();
                boolean bl2 = _greaterThan = _size > 5;
                if (_greaterThan) {
                    return uri.segment(3);
                }
                return URI.decode((String)uri.segment(1));
            }
            return URI.decode((String)uri.segment(0));
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

