/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.assertions.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.robotics.assertions.languages.AssertionsHelper;
import org.eclipse.papyrus.robotics.assertions.languages.ExpressionLanguagesHelper;
import org.eclipse.papyrus.robotics.assertions.languages.IExpressionLanguage;
import org.eclipse.papyrus.robotics.assertions.profile.assertions.Assertion;
import org.eclipse.papyrus.robotics.assertions.profile.assertions.Contract;
import org.eclipse.papyrus.robotics.assertions.ui.actions.ScrollableColorMessageDialog;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentDefinition;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentInstance;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentOrSystem;
import org.eclipse.papyrus.robotics.profile.robotics.components.System;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ValidateContractHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        EObject context = ValidateContractHandler.getSelectedElement();
        ComponentDefinition compDefinition = null;
        ComponentInstance compInstance = null;
        System system = null;
        Contract selectedContract = (Contract)UMLUtil.getStereotypeApplication((Element)((Element)context), Contract.class);
        if (context instanceof ComponentDefinition) {
            compDefinition = (ComponentDefinition)context;
        } else if (context instanceof Element && UMLUtil.getStereotypeApplication((Element)((Element)context), ComponentDefinition.class) != null) {
            compDefinition = (ComponentDefinition)UMLUtil.getStereotypeApplication((Element)((Element)context), ComponentDefinition.class);
        }
        if (compDefinition == null) {
            if (context instanceof ComponentInstance) {
                compInstance = (ComponentInstance)context;
            } else if (context instanceof Element && UMLUtil.getStereotypeApplication((Element)((Element)context), ComponentInstance.class) != null) {
                compInstance = (ComponentInstance)UMLUtil.getStereotypeApplication((Element)((Element)context), ComponentInstance.class);
            }
        }
        if (compDefinition == null && compInstance == null) {
            if (context instanceof System) {
                system = (System)context;
            } else if (context instanceof Element && UMLUtil.getStereotypeApplication((Element)((Element)context), System.class) != null) {
                system = (System)UMLUtil.getStereotypeApplication((Element)((Element)context), System.class);
            }
        }
        List<Contract> contracts = new ArrayList<Contract>();
        if (selectedContract != null) {
            contracts.add(selectedContract);
            EObject contractContext = AssertionsHelper.getContractContext((Contract)selectedContract);
            ValidateContractHandler.evaluateContracts(contracts, contractContext);
        } else if (compDefinition != null) {
            contracts = AssertionsHelper.getCompDefinitionContracts((ComponentOrSystem)compDefinition);
            ValidateContractHandler.evaluateContracts(contracts, (EObject)compDefinition);
        } else if (compInstance != null) {
            ComponentOrSystem cd = compInstance.getCompdefOrSys();
            contracts = AssertionsHelper.getCompDefinitionContracts((ComponentOrSystem)cd);
            ValidateContractHandler.evaluateContracts(contracts, (EObject)compInstance);
        } else if (system != null) {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Validate Contract", (String)"Validating contracts of component instances");
            for (ComponentInstance ci : system.getInstances()) {
                ComponentOrSystem cd = ci.getCompdefOrSys();
                contracts = AssertionsHelper.getCompDefinitionContracts((ComponentOrSystem)cd);
                ValidateContractHandler.evaluateContracts(contracts, (EObject)ci);
            }
            contracts = AssertionsHelper.getSystemContracts((System)system);
            if (!contracts.isEmpty()) {
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Validate Contract", (String)"Validating system contracts");
                ValidateContractHandler.evaluateContracts(contracts, (EObject)system);
            }
        }
        if (contracts.isEmpty()) {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Validate Contract", (String)"Contracts validation finished");
        }
        return null;
    }

    public static void evaluateContracts(List<Contract> contracts, EObject context) {
        ArrayList<String> globalLanguages = new ArrayList<String>();
        ArrayList<Integer> okLines = new ArrayList<Integer>();
        ArrayList<Integer> notokLines = new ArrayList<Integer>();
        for (Contract contract : contracts) {
            String lang;
            Object result;
            StringBuffer message = new StringBuffer();
            message.append(contract.getBase_Comment().getBody());
            message.append("\n");
            boolean assumptionsProblem = false;
            boolean guaranteesProblem = false;
            if (!contract.getAssumptions().isEmpty()) {
                message.append("Assumptions\n");
                for (Assertion assumption : contract.getAssumptions()) {
                    if (!AssertionsHelper.isGlobalEvaluationAssertion((Assertion)assumption)) {
                        result = AssertionsHelper.evaluateConstraint((EObject)context, (Constraint)assumption.getBase_Constraint());
                        message.append("(" + String.valueOf(result) + ") ");
                        if (result == null || !result.toString().equalsIgnoreCase("true")) {
                            notokLines.add(ValidateContractHandler.getCurrentLine(message.toString()));
                            assumptionsProblem = true;
                        } else {
                            okLines.add(ValidateContractHandler.getCurrentLine(message.toString()));
                        }
                        message.append(assumption.getBase_Constraint().getLabel() + "\n");
                        continue;
                    }
                    lang = AssertionsHelper.getAssertionLanguage((Assertion)assumption);
                    if (globalLanguages.contains(lang)) continue;
                    globalLanguages.add(lang);
                }
            }
            if (!contract.getGuarantees().isEmpty()) {
                message.append("Guarantees\n");
                for (Assertion guarantee : contract.getGuarantees()) {
                    if (!AssertionsHelper.isGlobalEvaluationAssertion((Assertion)guarantee)) {
                        result = AssertionsHelper.evaluateConstraint((EObject)context, (Constraint)guarantee.getBase_Constraint());
                        message.append("(" + String.valueOf(result) + ") ");
                        if (result == null || !result.toString().equalsIgnoreCase("true")) {
                            notokLines.add(ValidateContractHandler.getCurrentLine(message.toString()));
                            guaranteesProblem = true;
                        } else {
                            okLines.add(ValidateContractHandler.getCurrentLine(message.toString()));
                        }
                        message.append(guarantee.getBase_Constraint().getLabel() + "\n");
                        continue;
                    }
                    lang = AssertionsHelper.getAssertionLanguage((Assertion)guarantee);
                    if (globalLanguages.contains(lang)) continue;
                    globalLanguages.add(lang);
                }
            }
            if (!globalLanguages.isEmpty()) {
                message.append("Global languages\n");
                for (String lang2 : globalLanguages) {
                    message.append(lang2);
                    IExpressionLanguage langImpl = ExpressionLanguagesHelper.getExpressionLanguageByName((String)lang2);
                    Object result2 = langImpl.evaluate(context, null);
                    message.append(" (" + String.valueOf(result2) + ")\n");
                    if (result2 == null || !result2.toString().equalsIgnoreCase("true")) {
                        notokLines.add(ValidateContractHandler.getCurrentLine(message.toString()));
                        guaranteesProblem = true;
                        continue;
                    }
                    okLines.add(ValidateContractHandler.getCurrentLine(message.toString()));
                }
            }
            ArrayList<Color> colors = new ArrayList<Color>();
            Color OK = new Color((Device)Display.getCurrent(), 174, 213, 129);
            Color NOTOK = new Color((Device)Display.getCurrent(), 255, 138, 101);
            colors.add(OK);
            colors.add(NOTOK);
            ArrayList<List<Integer>> colorLines = new ArrayList<List<Integer>>();
            colorLines.add(okLines);
            colorLines.add(notokLines);
            ScrollableColorMessageDialog dialog = null;
            dialog = assumptionsProblem && !guaranteesProblem ? new ScrollableColorMessageDialog(Display.getCurrent().getActiveShell(), "Validate Contract", "Contract validation", message.toString(), colorLines, colors, 2) : (guaranteesProblem ? new ScrollableColorMessageDialog(Display.getCurrent().getActiveShell(), "Validate Contract", "Contract validation", message.toString(), colorLines, colors, 3) : new ScrollableColorMessageDialog(Display.getCurrent().getActiveShell(), "Validate Contract", "Contract validation", message.toString(), colorLines, colors));
            dialog.open();
            OK.dispose();
            NOTOK.dispose();
        }
    }

    private static int getCurrentLine(String string) {
        return string.split("\n").length - 1;
    }

    public static EObject getSelectedElement() {
        EObject eObject = null;
        Object selection = null;
        selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            selection = structuredSelection.getFirstElement();
        }
        if (selection != null) {
            if (selection instanceof IAdaptable) {
                selection = ((IAdaptable)selection).getAdapter(EObject.class);
            }
            if (selection instanceof EObject) {
                eObject = (EObject)selection;
            }
        }
        return eObject;
    }
}

