/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.assertions.tables.properties;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.AbstractEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.papyrus.infra.nattable.layerstack.BodyLayerStack;
import org.eclipse.papyrus.robotics.assertions.types.AssertionElementTypesEnumerator;
import org.eclipse.papyrus.robotics.assertions.ui.actions.CalculateNFPropertyHandler;
import org.eclipse.papyrus.robotics.properties.widgets.TableEditorPlus;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public class PropertyTable
extends TableEditorPlus {
    protected Button calculate;

    public PropertyTable(Composite parent, int style) {
        super(parent, style);
    }

    public AbstractEditCommandRequest createElementRequest() {
        CreateElementRequest createAssertionRequest = new CreateElementRequest(this.context, (IElementType)AssertionElementTypesEnumerator.PROPERTY, UMLPackage.eINSTANCE.getStructuredClassifier_OwnedAttribute());
        return createAssertionRequest;
    }

    public AbstractEditCommandRequest removeElementRequest(Object object) {
        return new DestroyElementRequest((EObject)object, false);
    }

    public void widgetSelected(SelectionEvent e) {
        super.widgetSelected(e);
        if (e.getSource() == this.calculate) {
            ILayer gridLayer = this.natTableWidget.getLayer();
            ILayer bodyLayer = ((GridLayer)gridLayer).getBodyLayer();
            SelectionLayer sl = ((BodyLayerStack)bodyLayer).getSelectionLayer();
            int row = sl.getSelectionAnchor().rowPosition;
            if (row >= 0) {
                Object object = this.nattableManager.getRowElement(row);
                if (object instanceof Property) {
                    Property prop = (Property)object;
                    ValueSpecification vs = prop.getDefaultValue();
                    CalculateNFPropertyHandler.evaluateAndShowResult((ValueSpecification)vs);
                }
            } else {
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Calculate", (String)"No property was selected");
            }
        }
    }

    protected void createListControls() {
        super.createListControls();
        this.calculate = this.createButton(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK"), "Calculate selected element");
    }
}

