/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.assertions.languages.editor;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.properties.ui.modelelement.ModelElement;
import org.eclipse.papyrus.infra.widgets.editors.AbstractEditor;
import org.eclipse.papyrus.infra.widgets.editors.ICommitListener;
import org.eclipse.papyrus.robotics.assertions.languages.editor.StyledStringEditor;
import org.eclipse.papyrus.uml.properties.modelelement.UMLModelElement;
import org.eclipse.papyrus.uml.properties.widgets.BodyEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class P4RBasicLanguageEditor
implements BodyEditor {
    private StyledStringEditor editor;
    private final Set<Listener> changeListeners = new HashSet<Listener>();
    private String currentValue;

    public void createWidget(Composite parent, int style) {
        this.editor = new StyledStringEditor(parent, style | 2 | 0x40){

            protected GridData getDefaultLayoutData() {
                GridData data = super.getDefaultLayoutData();
                data.grabExcessVerticalSpace = true;
                data.verticalAlignment = 4;
                return data;
            }
        };
        this.editor.addCommitListener(new ICommitListener(){

            public void commit(AbstractEditor editor) {
                Event event = new Event();
                P4RBasicLanguageEditor.this.currentValue = (String)P4RBasicLanguageEditor.this.editor.getValue();
                event.text = (String)P4RBasicLanguageEditor.this.editor.getValue();
                for (Listener listener : P4RBasicLanguageEditor.this.changeListeners) {
                    listener.handleEvent(event);
                }
            }
        });
        this.editor.layout();
        this.editor.setKeywords(this.getKeywords());
    }

    public String[] getKeywords() {
        return new String[0];
    }

    public void setInput(String value) {
        this.currentValue = value;
        AbstractObservableValue observable = new AbstractObservableValue(){

            public Object getValueType() {
                return String.class;
            }

            protected Object doGetValue() {
                return P4RBasicLanguageEditor.this.currentValue;
            }

            protected void doSetValue(Object value) {
                if (value instanceof String) {
                    P4RBasicLanguageEditor.this.currentValue = (String)value;
                }
            }
        };
        this.editor.setModelObservable((IObservableValue)observable);
        this.editor.updateSyntaxHighlighting();
    }

    public void dispose() {
        this.editor.dispose();
        this.changeListeners.clear();
    }

    public void addChangeListener(Listener listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(Listener listener) {
        this.changeListeners.remove(listener);
    }

    public String getValue() {
        return this.currentValue;
    }

    public void setReadOnly(boolean readOnly) {
        this.editor.setReadOnly(readOnly);
    }

    public void setContext(ModelElement context) {
        if (context instanceof UMLModelElement) {
            EObject currentEObj = ((UMLModelElement)context).getSource();
            this.editor.setContext(currentEObj);
        }
    }
}

