/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.assertions.languages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.robotics.assertions.languages.AssertionsHelper;
import org.eclipse.papyrus.robotics.assertions.profile.assertions.Property;
import org.eclipse.papyrus.robotics.core.utils.ParameterUtils;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentDefinition;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentInstance;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentOrSystem;
import org.eclipse.papyrus.robotics.profile.robotics.components.System;
import org.eclipse.papyrus.robotics.profile.robotics.parameters.ParameterInstance;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLUtil;

public class P4RExpressionsHelper {
    /*
     * WARNING - void declaration
     */
    public static String updateExpression(EObject context, String expression) {
        Object result;
        Object instanceName;
        ComponentDefinition compDefinition = null;
        ComponentInstance compInstance = null;
        System system = null;
        if (context instanceof ComponentDefinition) {
            compDefinition = (ComponentDefinition)context;
        } else if (context instanceof Element && UMLUtil.getStereotypeApplication((Element)((Element)context), ComponentDefinition.class) != null) {
            compDefinition = (ComponentDefinition)UMLUtil.getStereotypeApplication((Element)((Element)context), ComponentDefinition.class);
        }
        if (compDefinition == null) {
            if (context instanceof ComponentInstance) {
                compInstance = (ComponentInstance)context;
            } else if (context instanceof Element && UMLUtil.getStereotypeApplication((Element)((Element)context), ComponentInstance.class) != null) {
                compInstance = (ComponentInstance)UMLUtil.getStereotypeApplication((Element)((Element)context), ComponentInstance.class);
            }
        }
        if (compDefinition == null && compInstance == null) {
            if (context instanceof System) {
                system = (System)context;
            } else if (context instanceof Element && UMLUtil.getStereotypeApplication((Element)((Element)context), System.class) != null) {
                system = (System)UMLUtil.getStereotypeApplication((Element)((Element)context), System.class);
            }
        }
        if (system != null) {
            expression = P4RExpressionsHelper.handleGlobalSum(system, expression);
        }
        Map<Object, Object> parameters = new HashMap();
        if (compDefinition != null) {
            parameters = P4RExpressionsHelper.getCompDefinitionDefaultParameters((ComponentOrSystem)compDefinition);
        } else if (compInstance != null) {
            parameters = P4RExpressionsHelper.getCompInstanceParameters(compInstance);
        } else if (system != null) {
            EList eList = system.getInstances();
            for (ComponentInstance instance : eList) {
                instanceName = instance.getBase_Property().getName();
                instanceName = instanceName == null || ((String)instanceName).isEmpty() ? "" : (String)instanceName + ".";
                Map<String, String> instanceParameters = P4RExpressionsHelper.getCompInstanceParameters(instance);
                for (String key : instanceParameters.keySet()) {
                    parameters.put((String)instanceName + key, instanceParameters.get(key));
                }
            }
        }
        for (String string : parameters.keySet()) {
            if (!expression.contains(string)) continue;
            expression = expression.replaceAll(string, (String)parameters.get(string));
        }
        if (compDefinition != null || compInstance != null) {
            void var6_12;
            Object var6_9 = null;
            if (compDefinition != null) {
                Class clazz = compDefinition.getBase_Class();
            } else if (compInstance != null) {
                Class clazz = compInstance.getCompdefOrSys().getBase_Class();
            }
            Map<String, ValueSpecification> properties = P4RExpressionsHelper.getProperties((EObject)var6_12);
            for (String string : properties.keySet()) {
                if (!expression.contains(string)) continue;
                result = AssertionsHelper.evaluateValueSpecification((EObject)var6_12, properties.get(string));
                expression = expression.replaceAll(string, result.toString());
            }
        }
        if (system != null) {
            EList eList = system.getInstances();
            for (ComponentInstance instance : eList) {
                instanceName = instance.getBase_Property().getName();
                instanceName = instanceName == null || ((String)instanceName).isEmpty() ? "" : (String)instanceName + ".";
                Map<String, ValueSpecification> instanceProperties = P4RExpressionsHelper.getProperties((EObject)instance.getCompdefOrSys().getBase_Class());
                for (String key : instanceProperties.keySet()) {
                    if (!expression.contains((String)instanceName + key)) continue;
                    Object result2 = AssertionsHelper.evaluateValueSpecification((EObject)instance.getCompdefOrSys(), instanceProperties.get(key));
                    if (result2 == null) {
                        result2 = "null";
                    }
                    expression = expression.replaceAll((String)instanceName + key, result2.toString());
                }
            }
            Map<String, ValueSpecification> systemProperties = P4RExpressionsHelper.getProperties((EObject)system.getBase_Class());
            for (String string : systemProperties.keySet()) {
                if (!expression.contains(string)) continue;
                result = AssertionsHelper.evaluateValueSpecification((EObject)system, systemProperties.get(string));
                if (result == null) {
                    result = "null";
                }
                expression = expression.replaceAll(string, result.toString());
            }
        }
        return expression;
    }

    public static String handleGlobalSum(EObject context, String expression) {
        ArrayList<String> toReplace = new ArrayList<String>();
        int igs = expression.indexOf("GlobalSum(");
        while (igs != -1) {
            String propertyInExpression = expression.substring(igs + "GlobalSum(".length(), expression.indexOf(")", igs));
            if (!toReplace.contains(propertyInExpression)) {
                toReplace.add(propertyInExpression);
            }
            igs = expression.indexOf("GlobalSum(", igs + 1);
        }
        if (toReplace.isEmpty()) {
            return expression;
        }
        System system = (System)context;
        EList instances = system.getInstances();
        for (String propertyInExpression : toReplace) {
            StringBuffer globalSum = new StringBuffer("");
            for (ComponentInstance instance : instances) {
                Map<String, ValueSpecification> instanceProperties = P4RExpressionsHelper.getProperties((EObject)instance.getCompdefOrSys().getBase_Class());
                if (!instanceProperties.containsKey(propertyInExpression)) continue;
                globalSum.append(instance.getBase_Property().getName());
                globalSum.append(".");
                globalSum.append(propertyInExpression);
                globalSum.append(" + ");
            }
            globalSum.setLength(globalSum.length() - " + ".length());
            expression = expression.replaceAll("GlobalSum\\(" + propertyInExpression + "\\)", " (" + String.valueOf(globalSum) + ") ");
        }
        return expression;
    }

    public static Map<String, ValueSpecification> getProperties(EObject context) {
        HashMap<String, ValueSpecification> properties = new HashMap<String, ValueSpecification>();
        TreeIterator it = context.eAllContents();
        while (it.hasNext()) {
            EObject eo = (EObject)it.next();
            Property property = (Property)UMLUtil.getStereotypeApplication((Element)((Element)eo), Property.class);
            if (property == null) continue;
            String name = property.getBase_Property().getName();
            ValueSpecification vs = property.getBase_Property().getDefaultValue();
            properties.put(name, vs);
        }
        return properties;
    }

    public static Map<String, String> getCompInstanceParameters(ComponentInstance compInstance) {
        Map<String, String> parameters = P4RExpressionsHelper.getCompDefinitionDefaultParameters(compInstance.getCompdefOrSys());
        TreeIterator i = compInstance.getBase_Property().eAllContents();
        while (i.hasNext()) {
            InstanceSpecification eo2;
            ParameterInstance paraSpec;
            EList slots;
            EObject eo = (EObject)i.next();
            if (!(eo instanceof InstanceValue) || (slots = (paraSpec = (ParameterInstance)UMLUtil.getStereotypeApplication((Element)((Element)(eo2 = ((InstanceValue)eo).getInstance())), ParameterInstance.class)).getBase_InstanceSpecification().getSlots()) == null || slots.isEmpty()) continue;
            Slot slot = (Slot)paraSpec.getBase_InstanceSpecification().getSlots().get(0);
            String name = slot.getDefiningFeature().getName();
            ValueSpecification vs = (ValueSpecification)slot.getValues().get(0);
            String value = vs.stringValue();
            parameters.put(name, value);
        }
        return parameters;
    }

    public static Map<String, String> getCompDefinitionDefaultParameters(ComponentOrSystem compDef) {
        HashMap<String, String> defaultParameters = new HashMap<String, String>();
        List parameters = ParameterUtils.getAllParameters((Class)compDef.getBase_Class());
        for (org.eclipse.uml2.uml.Property parameter : parameters) {
            String name = parameter.getName();
            String value = "";
            if (parameter.getDefaultValue() != null) {
                Object result = AssertionsHelper.evaluateValueSpecification((EObject)compDef, parameter.getDefaultValue());
                value = result.toString();
            }
            defaultParameters.put(name, value);
        }
        return defaultParameters;
    }
}

