/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.debug.messages;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DebugEventContextKind implements Enumerator
{
    ENGINE(1, "ENGINE", "ENGINE"),
    THREAD(0, "THREAD", "THREAD");

    public static final int ENGINE_VALUE = 1;
    public static final int THREAD_VALUE = 0;
    private static final DebugEventContextKind[] VALUES_ARRAY;
    public static final List<DebugEventContextKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DebugEventContextKind[]{ENGINE, THREAD};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DebugEventContextKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DebugEventContextKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DebugEventContextKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DebugEventContextKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DebugEventContextKind get(int value) {
        switch (value) {
            case 1: {
                return ENGINE;
            }
            case 0: {
                return THREAD;
            }
        }
        return null;
    }

    private DebugEventContextKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

