/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fuml.actions;

import java.util.List;
import org.eclipse.papyrus.moka.fuml.actions.ActionActivation;
import org.eclipse.papyrus.moka.fuml.actions.IDestroyObjectActivation;
import org.eclipse.papyrus.moka.fuml.debug.Debug;
import org.eclipse.papyrus.moka.fuml.profiling.activities.PinActivationProfiler;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.IFeatureValue;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.IValue;
import org.eclipse.papyrus.moka.fuml.structuredclassifiers.IExtensionalValue;
import org.eclipse.papyrus.moka.fuml.structuredclassifiers.ILink;
import org.eclipse.papyrus.moka.fuml.structuredclassifiers.IReference;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.DestroyObjectAction;
import org.eclipse.uml2.uml.InputPin;
import org.eclipse.uml2.uml.Property;

public class DestroyObjectActionActivation
extends ActionActivation
implements IDestroyObjectActivation {
    @Override
    public void doAction() {
        List<IValue> list;
        DestroyObjectAction action = (DestroyObjectAction)this.node;
        InputPin inputPin = action.getTarget();
        DestroyObjectActionActivation destroyObjectActionActivation = this;
        try {
            list = destroyObjectActionActivation.takeTokens(inputPin);
        }
        finally {
            PinActivationProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_fuml_profiling_activities_PinActivationProfiler$2$e210d285(destroyObjectActionActivation, inputPin);
        }
        IValue value = list.get(0);
        this.destroyObject(value, action.isDestroyLinks(), action.isDestroyOwnedObjects());
    }

    public void destroyObject(IValue value, Boolean isDestroyLinks, Boolean isDestroyOwnedObjects) {
        if (value instanceof IReference) {
            int i;
            IReference reference = (IReference)value;
            if (isDestroyLinks | isDestroyOwnedObjects) {
                Debug.println("[destroyObject] Destroying links...");
                List extensionalValues = this.getExecutionLocus().getExtensionalValues();
                i = 0;
                while (i < extensionalValues.size()) {
                    ILink link;
                    IExtensionalValue extensionalValue = (IExtensionalValue)extensionalValues.get(i);
                    if (extensionalValue instanceof ILink && this.valueParticipatesInLink((IValue)reference, link = (ILink)extensionalValue).booleanValue() && isDestroyLinks | this.objectIsComposite(reference, link)) {
                        link.destroy();
                    }
                    ++i;
                }
            }
            if (isDestroyOwnedObjects.booleanValue()) {
                Debug.println("[destroyObject] Destroying owned objects...");
                List objectFeatureValues = reference.getFeatureValues();
                i = 0;
                while (i < objectFeatureValues.size()) {
                    IFeatureValue featureValue = (IFeatureValue)objectFeatureValues.get(i);
                    if (((Property)featureValue.getFeature()).getAggregation() == AggregationKind.COMPOSITE_LITERAL) {
                        List values = featureValue.getValues();
                        int j = 0;
                        while (j < values.size()) {
                            IValue ownedValue = (IValue)values.get(j);
                            this.destroyObject(ownedValue, isDestroyLinks, isDestroyOwnedObjects);
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            reference.destroy();
        }
    }

    public Boolean objectIsComposite(IReference reference, ILink link) {
        List linkFeatureValues = link.getFeatureValues();
        boolean isComposite = false;
        int i = 1;
        while (!isComposite & i <= linkFeatureValues.size()) {
            IFeatureValue featureValue = (IFeatureValue)linkFeatureValues.get(i - 1);
            if (((IValue)featureValue.getValues().get(0)).equals((IValue)reference) == false & ((Property)featureValue.getFeature()).getAggregation() == AggregationKind.COMPOSITE_LITERAL) {
                isComposite = true;
            }
            ++i;
        }
        return isComposite;
    }
}

