/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fuml.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.moka.fuml.actions.ClauseActivation;
import org.eclipse.papyrus.moka.fuml.actions.IConditionalNodeActivation;
import org.eclipse.papyrus.moka.fuml.actions.StructuredActivityNodeActivation;
import org.eclipse.papyrus.moka.fuml.activities.IActivityNodeActivation;
import org.eclipse.papyrus.moka.fuml.activities.IToken;
import org.eclipse.papyrus.moka.fuml.debug.Debug;
import org.eclipse.papyrus.moka.fuml.loci.ChoiceStrategy;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.Clause;
import org.eclipse.uml2.uml.ConditionalNode;
import org.eclipse.uml2.uml.ExecutableNode;
import org.eclipse.uml2.uml.OutputPin;
import org.eclipse.uml2.uml.Pin;

public class ConditionalNodeActivation
extends StructuredActivityNodeActivation
implements IConditionalNodeActivation {
    public List<ClauseActivation> clauseActivations = new ArrayList<ClauseActivation>();
    public List<Clause> selectedClauses = new ArrayList<Clause>();
    public Clause selectedClause;

    @Override
    public void doStructuredActivity() {
        ClauseActivation clauseActivation2;
        ConditionalNode node = (ConditionalNode)this.node;
        List<IActivityNodeActivation> nodeActivations = this.activationGroup.nodeActivations;
        ArrayList<IActivityNodeActivation> nonExecutableNodeActivations = new ArrayList<IActivityNodeActivation>();
        int i = 0;
        while (i < nodeActivations.size()) {
            IActivityNodeActivation nodeActivation = nodeActivations.get(i);
            if (!(nodeActivation.getNode() instanceof ExecutableNode | nodeActivation.getNode() instanceof Pin)) {
                nonExecutableNodeActivations.add(nodeActivation);
            }
            ++i;
        }
        this.activationGroup.run(nonExecutableNodeActivations);
        this.clauseActivations.clear();
        EList clauses = node.getClauses();
        int i2 = 0;
        while (i2 < clauses.size()) {
            Clause clause = (Clause)clauses.get(i2);
            clauseActivation2 = new ClauseActivation();
            clauseActivation2.clause = clause;
            clauseActivation2.conditionalNodeActivation = this;
            this.clauseActivations.add(clauseActivation2);
            ++i2;
        }
        this.selectedClauses.clear();
        ArrayList<ClauseActivation> readyClauseActivations = new ArrayList<ClauseActivation>();
        int i3 = 0;
        while (i3 < this.clauseActivations.size()) {
            clauseActivation2 = this.clauseActivations.get(i3);
            Debug.println("[doStructuredActivity] clauseActivations[" + i3 + "] = " + clauseActivation2);
            if (clauseActivation2.isReady().booleanValue()) {
                Debug.println("[doStructuredActivity] Clause activation is ready.");
                readyClauseActivations.add(clauseActivation2);
            }
            ++i3;
        }
        for (ClauseActivation clauseActivation2 : readyClauseActivations) {
            Debug.println("[doStructuredActivity] Giving control to " + clauseActivation2 + "...");
            clauseActivation2.receiveControl();
        }
        this.selectedClause = null;
        if (this.selectedClauses.size() > 0 & this.isRunning()) {
            Debug.println("[doStructuredActivity] " + this.selectedClauses.size() + " clause(s) selected.");
            i = ((ChoiceStrategy)this.getExecutionLocus().getFactory().getStrategy("choice")).choose(this.selectedClauses.size());
            this.selectedClause = this.selectedClauses.get(i - 1);
            Debug.println("[doStructuredActivity] Running selectedClauses[" + i + "] = " + this.selectedClause);
            int j = 0;
            while (j < clauses.size()) {
                Clause clause = (Clause)clauses.get(j);
                if (clause != this.selectedClause) {
                    EList testNodes = clause.getTests();
                    int k = 0;
                    while (k < testNodes.size()) {
                        ExecutableNode testNode = (ExecutableNode)testNodes.get(k);
                        this.activationGroup.getNodeActivation((ActivityNode)testNode).terminate();
                        ++k;
                    }
                }
                ++j;
            }
            this.activationGroup.runNodes(this.makeActivityNodeList((List<ExecutableNode>)this.selectedClause.getBodies()));
        }
    }

    public void completeBody() {
        if (this.selectedClause != null) {
            ConditionalNode node = (ConditionalNode)this.node;
            EList resultPins = node.getResults();
            EList bodyOutputPins = this.selectedClause.getBodyOutputs();
            int k = 0;
            while (k < resultPins.size()) {
                OutputPin resultPin = (OutputPin)resultPins.get(k);
                OutputPin bodyOutputPin = (OutputPin)bodyOutputPins.get(k);
                this.putTokens(resultPin, this.getPinValues(bodyOutputPin));
                ++k;
            }
        }
        this.activationGroup.terminateAll();
    }

    @Override
    public List<IToken> completeAction() {
        if (!this.isSuspended().booleanValue()) {
            this.completeBody();
        }
        return super.completeAction();
    }

    public ClauseActivation getClauseActivation(Clause clause) {
        ClauseActivation selectedClauseActivation = null;
        int i = 1;
        while (selectedClauseActivation == null & i <= this.clauseActivations.size()) {
            ClauseActivation clauseActivation = this.clauseActivations.get(i - 1);
            if (clauseActivation.clause == clause) {
                selectedClauseActivation = clauseActivation;
            }
            ++i;
        }
        return selectedClauseActivation;
    }

    public void runTest(Clause clause) {
        if (this.isRunning().booleanValue()) {
            this.activationGroup.runNodes(this.makeActivityNodeList((List<ExecutableNode>)clause.getTests()));
        }
    }

    public void selectBody(Clause clause) {
        this.selectedClauses.add(clause);
    }

    @Override
    public void resume() {
        this.completeBody();
        super.resume();
    }
}

