/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.engine.uml.scheduling;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.moka.engine.uml.scheduling.UMLTaskExecution;
import org.eclipse.papyrus.moka.fuml.commonbehavior.IParameterValue;
import org.eclipse.papyrus.moka.fuml.tasks.IUMLRootTaskExecution;
import org.eclipse.papyrus.moka.kernel.scheduling.control.IExecutionLoop;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;

public abstract class UMLRootTaskExecution<RootElementType extends Element>
extends UMLTaskExecution
implements IUMLRootTaskExecution<RootElementType> {
    protected RootElementType root;
    protected List<IParameterValue> parameterValues;

    public UMLRootTaskExecution(IExecutionLoop loop, RootElementType executionRoot) {
        super(loop);
        this.root = executionRoot;
        this.parameterValues = new ArrayList<IParameterValue>();
    }

    public RootElementType getRoot() {
        return this.root;
    }

    @Override
    public void setParameterValue(IParameterValue parameterValue) {
        IParameterValue existingParameterValue = this.getParameterValue(parameterValue.getParameter());
        if (existingParameterValue == null) {
            this.parameterValues.add(parameterValue);
        } else {
            existingParameterValue.setValues(parameterValue.getValues());
        }
    }

    @Override
    public IParameterValue getReturnParameterValue() {
        IParameterValue value = null;
        int i = 0;
        while (value == null && i < this.parameterValues.size()) {
            Parameter parameter = this.parameterValues.get(i).getParameter();
            if (parameter.getDirection() == ParameterDirectionKind.RETURN_LITERAL) {
                value = this.getParameterValues().get(i);
            }
            ++i;
        }
        return value;
    }

    @Override
    public IParameterValue getParameterValue(Parameter parameter) {
        IParameterValue parameterValue = null;
        int i = 1;
        while (parameterValue == null & i <= this.parameterValues.size()) {
            if (this.getParameterValues().get(i - 1).getParameter() == parameter) {
                parameterValue = this.getParameterValues().get(i - 1);
            }
            ++i;
        }
        return parameterValue;
    }

    @Override
    public List<IParameterValue> getOutputParameterValues() {
        ArrayList<IParameterValue> outputs = new ArrayList<IParameterValue>();
        int i = 0;
        while (i < this.parameterValues.size()) {
            IParameterValue parameterValue = this.parameterValues.get(i);
            Parameter parameter = parameterValue.getParameter();
            if (parameter.getDirection() == ParameterDirectionKind.INOUT_LITERAL | parameter.getDirection() == ParameterDirectionKind.OUT_LITERAL | parameter.getDirection() == ParameterDirectionKind.RETURN_LITERAL) {
                outputs.add(parameterValue);
            }
            ++i;
        }
        return outputs;
    }

    @Override
    public List<IParameterValue> getParameterValues() {
        return this.parameterValues;
    }

    public void setInputParameterValues(List<IParameterValue> inputParameterValues) {
        for (IParameterValue inputParameterValue : inputParameterValues) {
            this.setParameterValue(inputParameterValue);
        }
    }

    @Override
    public void suspend() {
    }

    @Override
    public void terminate() {
    }

    public String toString() {
        return "RootExecution()";
    }
}

