/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.engine.uml.debug.data.variables;

import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.papyrus.moka.engine.uml.debug.data.values.MokaValueAdapterList;
import org.eclipse.papyrus.moka.engine.uml.debug.data.values.UMLValueAdapterFactory;
import org.eclipse.papyrus.moka.engine.uml.debug.data.variables.UMLVariableAdapter;
import org.eclipse.papyrus.moka.fuml.actions.IPinActivation;
import org.eclipse.papyrus.moka.fuml.activities.IToken;
import org.eclipse.uml2.uml.Pin;

public class PinActivationVariableAdapter
extends UMLVariableAdapter<IPinActivation> {
    public PinActivationVariableAdapter(IDebugTarget target, IPinActivation variable) {
        super(target, variable);
    }

    @Override
    public IValue getValue() throws DebugException {
        if (this.value == null) {
            List heldTokens = ((IPinActivation)this.variable).getTokens();
            if (heldTokens.size() == 1) {
                this.value = UMLValueAdapterFactory.getInstance().instantiate(heldTokens.iterator().next(), this.getDebugTarget());
            } else if (heldTokens.size() > 1) {
                MokaValueAdapterList tokenValueAdapterList = new MokaValueAdapterList(this.getDebugTarget());
                for (IToken token : heldTokens) {
                    tokenValueAdapterList.add(token);
                }
            } else {
                this.value = UMLValueAdapterFactory.getInstance().instantiate(null, this.getDebugTarget());
            }
        }
        return this.value;
    }

    @Override
    public String getName() throws DebugException {
        Pin pin = (Pin)((IPinActivation)this.variable).getNode();
        if (pin != null) {
            return pin.getName();
        }
        return super.getName();
    }
}

