/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.odt.emf.template2pdf.internal.menu;

import java.util.Collections;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.model2doc.odt.emf.template2pdf.Activator;
import org.eclipse.papyrus.model2doc.odt.emf.template2pdf.internal.messages.Messages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;

public class Template2PDFMenuContributionItem
extends ContributionItem {
    public Template2PDFMenuContributionItem() {
    }

    public Template2PDFMenuContributionItem(String id) {
        super(id);
    }

    public void fill(Menu menu, int index) {
        this.createMenuItem("org.eclipse.papyrus.model2doc.odt.emf.template2pdf.generateStructure_Document_PDF", menu, 0);
        this.createMenuItem("org.eclipse.papyrus.model2doc.odt.emf.template2pdf.generateStructure_Document_PDF_A1B", menu, 1);
        this.createMenuItem("org.eclipse.papyrus.model2doc.odt.emf.template2pdf.generateStructure_Document_PDF_A2B", menu, 2);
    }

    protected void createMenuItem(String commandId, Menu menu, int index) {
        IEclipseContext ctx = this.getEclipseContext();
        ICommandService serv = this.getCommandService();
        final Command command = serv.getCommand(commandId);
        final IHandler handler = command.getHandler();
        ctx.set("generatorMenuLabel", (Object)"noGenerator");
        if (command.isEnabled()) {
            String res = (String)ctx.get("generatorMenuLabel");
            String pdfVersion = (String)ctx.get("pdfVersionMenuLabelId");
            if (pdfVersion == null || pdfVersion.isEmpty()) {
                pdfVersion = "PDF";
            }
            MenuItem item = new MenuItem(menu, 8, index);
            String menuName = res != null && !res.isEmpty() && !res.equals("noGenerator") ? NLS.bind((String)Messages.Template2PDFMenuContributionItem_GenerateAllWith2Parameters, (Object)pdfVersion, (Object)res) : NLS.bind((String)Messages.Template2PDFMenuContributionItem_GenerateAllWithOneParameter, (Object)pdfVersion);
            item.setText(menuName);
            item.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent arg0) {
                    try {
                        handler.execute(new ExecutionEvent(command, Collections.emptyMap(), null, null));
                    }
                    catch (ExecutionException e) {
                        Activator.log.error((Throwable)e);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }
            });
        }
    }

    private IEclipseContext getEclipseContext() {
        IWorkbench workbench = this.getWorkbench();
        if (workbench != null) {
            return (IEclipseContext)workbench.getService(IEclipseContext.class);
        }
        return null;
    }

    private IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    private ICommandService getCommandService() {
        IWorkbench workbench = this.getWorkbench();
        if (workbench != null) {
            return (ICommandService)workbench.getService(ICommandService.class);
        }
        return null;
    }
}

