/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.ui.modelresource;

import java.io.IOException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.infra.core.resource.AbstractDynamicModel;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentTemplate;

public class DocumentTemplateModel
extends AbstractDynamicModel<DocumentTemplate> {
    public static final String DOCUMENT_MODEL_ID = "org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.ui.DocumentTemplate";
    public static final String DOCUMENT_MODEL_FILE_EXTENSION = "pdst";

    protected String getModelFileExtension() {
        return DOCUMENT_MODEL_FILE_EXTENSION;
    }

    public String getIdentifier() {
        return DOCUMENT_MODEL_ID;
    }

    public void loadModel(URI uriWithoutExtension) {
        if (this.exists(uriWithoutExtension)) {
            try {
                super.loadModel(uriWithoutExtension);
            }
            catch (Exception ex) {
                this.createModel(uriWithoutExtension);
            }
        }
        if (this.resource == null) {
            this.createModel(uriWithoutExtension);
        }
    }

    public void addDocument(DocumentTemplate document, EObject context) {
        if (context != null) {
            Resource targetResource;
            Resource contextResource = context.eResource();
            if (!contextResource.getURI().trimFileExtension().equals(this.getResource().getURI().trimFileExtension())) {
                URI uri = contextResource.getURI();
                uri = uri.trimFileExtension();
                uri = uri.appendFileExtension(this.getModelFileExtension());
                ResourceSet set = contextResource.getResourceSet();
                targetResource = set.getResource(uri, true);
            } else {
                targetResource = this.getResource();
            }
            if (targetResource != null) {
                targetResource.getContents().add((Object)document);
            }
        }
    }

    public boolean canPersist(EObject object) {
        return this.getResource() != null && this.isSupportedRoot(object);
    }

    protected boolean isSupportedRoot(EObject object) {
        return object instanceof DocumentTemplate;
    }

    public void persist(EObject object) {
        if (!this.canPersist(object)) {
            throw new IllegalArgumentException("cannot persist " + String.valueOf(object));
        }
        this.getResource().getContents().add((Object)object);
    }

    protected void configureResource(Resource resource) {
        super.configureResource(resource);
    }

    public void saveModel() throws IOException {
        this.resource.save(null);
    }
}

