/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.labels.domains;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.papyrus.uml.domain.services.labels.INamedElementNameProvider;
import org.eclipse.papyrus.uml.domain.services.labels.LabelUtils;
import org.eclipse.papyrus.uml.domain.services.labels.domains.ParameterLabelHelper;
import org.eclipse.papyrus.uml.domain.services.labels.domains.VisibilityLabelHelper;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;

public class OperationLabelHelper {
    private final ParameterLabelHelper parameterLabelHelper;
    private final VisibilityLabelHelper visibilityLabelHelper;
    private final INamedElementNameProvider namedElementNameProvider;

    public OperationLabelHelper(ParameterLabelHelper parameterLabelHelper, VisibilityLabelHelper visibilityLabelHelper, INamedElementNameProvider namedElementNameProvider) {
        this.parameterLabelHelper = Objects.requireNonNull(parameterLabelHelper);
        this.visibilityLabelHelper = Objects.requireNonNull(visibilityLabelHelper);
        this.namedElementNameProvider = Objects.requireNonNull(namedElementNameProvider);
    }

    public String getLabel(Operation operation) {
        String operationLabel = LabelUtils.getNonNullString(this.visibilityLabelHelper.getVisibilityAsSign((NamedElement)operation)) + " ";
        String parameters = this.getInnerParameters(operation);
        String returnType = this.getFirstReturnParameter(operation).map(this::computeReturnParameterLabel).orElse("");
        return operationLabel + this.namedElementNameProvider.getName((NamedElement)operation) + parameters + returnType;
    }

    private String getInnerParameters(Operation operation) {
        return operation.getOwnedParameters().stream().filter(p -> !ParameterDirectionKind.RETURN_LITERAL.equals((Object)p.getDirection())).map(this::computeOperationParameterLabel).collect(Collectors.joining(", ", "(", ")"));
    }

    private String computeOperationParameterLabel(Parameter parameter) {
        return this.parameterLabelHelper.getLabel(parameter);
    }

    private Optional<Parameter> getFirstReturnParameter(Operation operation) {
        return Optional.ofNullable(operation.getReturnResult());
    }

    private String computeReturnParameterLabel(Parameter parameter) {
        return ": " + Optional.ofNullable(parameter.getType()).map(type -> this.namedElementNameProvider.getName((NamedElement)type)).orElse("<Undefined>");
    }
}

