/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.cpp.reverse;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IMethodDeclaration;
import org.eclipse.cdt.core.model.IMethodTemplateDeclaration;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Const;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.ConstInit;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Friend;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Inline;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Variadic;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Virtual;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Volatile;
import org.eclipse.papyrus.designer.languages.cpp.reverse.ASTUtils;
import org.eclipse.papyrus.designer.languages.cpp.reverse.BatchReverseFunctionBody;
import org.eclipse.papyrus.designer.languages.cpp.reverse.CommentUtils;
import org.eclipse.papyrus.designer.languages.cpp.reverse.GetOrCreateP1;
import org.eclipse.papyrus.designer.languages.cpp.reverse.PkgDependencies;
import org.eclipse.papyrus.designer.languages.cpp.reverse.ReverseUtils;
import org.eclipse.papyrus.designer.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioralFeature;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.profile.standard.Create;
import org.eclipse.uml2.uml.profile.standard.Destroy;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class MethodUtils {
    public static Object createMethod(IMethodDeclaration method, Class classifier) {
        Object _xblockexpression = null;
        IASTStandardFunctionDeclarator declarator = ASTUtils.getDeclarator((ISourceReference)method);
        Object _xifexpression = null;
        if (declarator != null) {
            Object _xblockexpression_1 = null;
            Operation op = classifier.createOwnedOperation(method.getElementName(), null, null);
            ReverseUtils.setXmlID((NamedElement)op);
            _xifexpression = _xblockexpression_1 = MethodUtils.updateMethod(classifier, op, method);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public static Object updateMethod(Class classifier, Operation op, IMethodDeclaration method) {
        try {
            IASTParameterDeclaration[] _parameters;
            boolean _isPureVirtual;
            Object _xblockexpression = null;
            op.setName(method.getElementName());
            StereotypeUtil.unapply((Element)op, Inline.class);
            StereotypeUtil.unapply((Element)op, Friend.class);
            StereotypeUtil.unapply((Element)op, Virtual.class);
            StereotypeUtil.unapply((Element)op, Volatile.class);
            StereotypeUtil.unapply((Element)op, Create.class);
            StereotypeUtil.unapply((Element)op, Destroy.class);
            StereotypeUtil.unapply((Element)op, Const.class);
            op.getOwnedParameters().clear();
            List<String> keywords = MethodUtils.getKeywords(method);
            String body = MethodUtils.getBody(method);
            op.setVisibility(ASTUtils.convertVisibility(method.getVisibility()));
            op.setIsStatic(method.isStatic());
            ReverseUtils.applyStereotype((Element)op, method.isInline(), Inline.class);
            ReverseUtils.applyStereotype((Element)op, method.isFriend(), Friend.class);
            ReverseUtils.applyStereotype((Element)op, method.isVirtual(), Virtual.class);
            ReverseUtils.applyStereotype((Element)op, method.isVolatile(), Volatile.class);
            ReverseUtils.applyStereotype((Element)op, method.isConst(), Const.class);
            boolean _isVirtual = method.isVirtual();
            if (_isVirtual && (_isPureVirtual = method.isPureVirtual())) {
                op.setIsAbstract(true);
            }
            ReverseUtils.applyStereotype((Element)op, method.isConstructor(), Create.class);
            ReverseUtils.applyStereotype((Element)op, method.isDestructor(), Destroy.class);
            try {
                String signature = method.getSignature();
                Pattern pattern = Pattern.compile("([\\s]*)(\\.\\.\\.)([\\s]*)(\\))");
                Matcher matcher = pattern.matcher(signature);
                ReverseUtils.applyStereotype((Element)op, matcher.find(), Variadic.class);
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    e.printStackTrace();
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            if (method instanceof IMethodTemplateDeclaration) {
                int i = 0;
                while (i < ((List)Conversions.doWrapArray((Object)((IMethodTemplateDeclaration)method).getTemplateParameterTypes())).size()) {
                    GetOrCreateP1.getOrCreateTemplateParameter((NamedElement)op, ((IMethodTemplateDeclaration)method).getTemplateParameterTypes()[i], keywords.get(i));
                    ++i;
                }
            }
            IASTDeclSpecifier declSpecifier = ASTUtils.getDeclSpecifier((ISourceReference)method);
            IASTStandardFunctionDeclarator declarator = ASTUtils.getDeclarator((ISourceReference)method);
            if (!method.isConstructor() && !method.isDestructor()) {
                boolean _tripleNotEquals;
                String _returnType = method.getReturnType();
                boolean bl = _tripleNotEquals = _returnType != null;
                if (_tripleNotEquals) {
                    Type parameterType = MethodUtils.getParameterTemplateType(op, method, ASTUtils.getQualifiedName(declSpecifier));
                    if (parameterType == null) {
                        parameterType = ReverseUtils.getUMLType(ASTUtils.getQualifiedName(declSpecifier), (ICElement)method);
                    }
                    Parameter ret = op.createOwnedParameter("ret", parameterType);
                    ret.setDirection(ParameterDirectionKind.RETURN_LITERAL);
                    ReverseUtils.analyzeDeclaration((IASTDeclarator)declarator, ret.getType(), (TypedElement)ret, "C++");
                    PkgDependencies.createDependency((NamedElement)classifier, (NamedElement)ret.getType());
                    if (parameterType != null && parameterType.getName().equals("void") && ret.getAppliedStereotypes().isEmpty()) {
                        ret.destroy();
                    }
                    ReverseUtils.applyStereotype((Element)ret, declSpecifier.isConst(), Const.class);
                    ReverseUtils.applyStereotype((Element)ret, declSpecifier.isVolatile(), Volatile.class);
                } else {
                    Parameter ret_1 = op.createOwnedParameter("ret", ReverseUtils.getUMLType("void", (ICElement)method));
                    ret_1.setDirection(ParameterDirectionKind.RETURN_LITERAL);
                    ReverseUtils.analyzeDeclaration((IASTDeclarator)declarator, ret_1.getType(), (TypedElement)ret_1, "C++");
                    boolean _isEmpty = ret_1.getAppliedStereotypes().isEmpty();
                    if (_isEmpty) {
                        ret_1.destroy();
                    }
                }
            }
            IASTParameterDeclaration[] iASTParameterDeclarationArray = _parameters = declarator.getParameters();
            int _isEmpty = _parameters.length;
            int ret_1 = 0;
            while (ret_1 < _isEmpty) {
                IASTParameterDeclaration param = iASTParameterDeclarationArray[ret_1];
                Type parameterType_1 = MethodUtils.getParameterTemplateType(op, method, ASTUtils.getCppTypeName(param.getDeclSpecifier()));
                if (parameterType_1 == null) {
                    parameterType_1 = ReverseUtils.getUMLType(param.getDeclSpecifier(), (ICElement)method);
                }
                Parameter opParam = op.createOwnedParameter(param.getDeclarator().getName().toString(), parameterType_1);
                ReverseUtils.applyStereotype((Element)opParam, param.getDeclSpecifier().isConst(), Const.class);
                ReverseUtils.analyzeDeclaration(param.getDeclarator(), opParam.getType(), (TypedElement)opParam, "C++");
                ReverseUtils.applyStereotype((Element)opParam, param.getDeclSpecifier().isVolatile(), Volatile.class);
                ++ret_1;
            }
            if (body != null) {
                boolean _equals_2;
                boolean _equals;
                boolean _isConstructor = method.isConstructor();
                if (_isConstructor) {
                    boolean _not;
                    String initStr = ReverseUtils.getMemberInit(method);
                    boolean _isEmpty_1 = initStr.isEmpty();
                    boolean bl = _not = !_isEmpty_1;
                    if (_not) {
                        StereotypeUtil.apply((Element)op, ConstInit.class);
                        ConstInit _stereotypeApplication = (ConstInit)UMLUtil.getStereotypeApplication((Element)op, ConstInit.class);
                        _stereotypeApplication.setInitialisation(initStr);
                    }
                }
                OpaqueBehavior ob = null;
                int _size = op.getMethods().size();
                boolean bl = _equals = _size == 0;
                if (_equals) {
                    Behavior _createOwnedBehavior = classifier.createOwnedBehavior(op.getName(), UMLPackage.Literals.OPAQUE_BEHAVIOR);
                    ob = (OpaqueBehavior)_createOwnedBehavior;
                    ob.setSpecification((BehavioralFeature)op);
                    ob.setIsReentrant(false);
                } else {
                    boolean _not_1;
                    Behavior _get = (Behavior)op.getMethods().get(0);
                    ob = (OpaqueBehavior)_get;
                    boolean _equals_1 = ob.getName().equals(op.getName());
                    boolean bl2 = _not_1 = !_equals_1;
                    if (_not_1) {
                        ob.setName(op.getName());
                    }
                }
                int _size_1 = ob.getBodies().size();
                boolean bl3 = _equals_2 = _size_1 == 0;
                if (_equals_2) {
                    ob.getLanguages().add((Object)"C++");
                    ob.getBodies().add((Object)"");
                }
                int i = 0;
                while (i < ob.getLanguages().size()) {
                    boolean _equals_3 = ((String)ob.getLanguages().get(i)).equals("C++");
                    if (_equals_3) {
                        boolean _lessThan;
                        int _size_2 = ob.getBodies().size();
                        boolean bl4 = _lessThan = i < _size_2;
                        if (_lessThan) {
                            ob.getBodies().set(i, (Object)body);
                        }
                    }
                    ++i;
                }
            }
            IASTNode node = ASTUtils.findEnclosingNode((ISourceReference)method);
            CommentUtils.addComment((Element)op, node);
            Object _xifexpression = null;
            if (node instanceof IASTFunctionDefinition) {
                _xifexpression = null;
            }
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static Type getParameterTemplateType(Operation op, IMethodDeclaration imethod, String typeName) {
        Classifier ret = null;
        if (imethod instanceof IMethodTemplateDeclaration) {
            boolean _not;
            Functions.Function1 _function = it -> it.equals(typeName);
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)((IMethodTemplateDeclaration)imethod).getTemplateParameterTypes())), (Functions.Function1)_function));
            boolean bl = _not = !_isEmpty;
            if (_not) {
                ret = GetOrCreateP1.getOrCreateTemplateParameter((NamedElement)op, typeName, "class");
            }
        }
        return ret;
    }

    public static List<String> getKeywords(IMethodDeclaration method) {
        try {
            IASTNode node = ASTUtils.findEnclosingNode((ISourceReference)method);
            ArrayList<String> keywords = new ArrayList<String>();
            if (node instanceof ICPPASTTemplateDeclaration) {
                IASTNode[] _children;
                IASTNode[] iASTNodeArray = _children = ((ICPPASTTemplateDeclaration)node).getChildren();
                int n = _children.length;
                int n2 = 0;
                while (n2 < n) {
                    IASTNode child = iASTNodeArray[n2];
                    if (child instanceof ICPPASTTemplateParameter) {
                        IToken token = ((ICPPASTTemplateParameter)child).getSyntax();
                        String keyword = "class";
                        while (token != null) {
                            boolean _equals;
                            int _type = token.getType();
                            boolean bl = _equals = _type == 118;
                            if (_equals) {
                                keyword = "typename";
                            }
                            token = token.getNext();
                        }
                        keywords.add(keyword);
                    }
                    ++n2;
                }
            }
            return keywords;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static String getBody(IMethodDeclaration method) {
        IASTFunctionDeclarator declarator = null;
        IASTNode node = ASTUtils.findEnclosingNode((ISourceReference)method);
        String body = null;
        if (node instanceof ICPPASTFunctionDefinition) {
            declarator = ((ICPPASTFunctionDefinition)node).getDeclarator();
            body = BatchReverseFunctionBody.getBody(method.getTranslationUnit(), (IASTFunctionDefinition)((ICPPASTFunctionDefinition)node));
        } else {
            boolean cfr_ignored_0 = node instanceof IASTFunctionDeclarator;
        }
        return body;
    }
}

