/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.cpp.reverse;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTEqualsInitializer;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTInitializerList;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorInitializer;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.IMethod;
import org.eclipse.cdt.core.model.IMethodDeclaration;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.IStructure;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IVariableDeclaration;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.papyrus.designer.infra.base.StringUtils;
import org.eclipse.papyrus.designer.languages.common.base.codesync.SyncStatus;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.ConstInit;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Include;
import org.eclipse.papyrus.designer.languages.cpp.reverse.ASTUtils;
import org.eclipse.papyrus.designer.languages.cpp.reverse.ReverseCpp2Uml;
import org.eclipse.papyrus.designer.languages.cpp.reverse.ReverseUtils;
import org.eclipse.papyrus.designer.languages.cpp.reverse.utils.RoundtripCppUtils;
import org.eclipse.papyrus.designer.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.BehavioralFeature;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLUtil;

public class BatchReverseFunctionBody {
    private static final String DEFAULT_VALUE = "defaultValue";
    private static final String EMPTY = "";
    private static final String SEP = "::";
    public static final String sAtParam = "@param";
    public static final String ansiCLib = "AnsiCLibrary";
    public static final String[] ansiTypes = new String[]{"char", "double", "float", "int", "void", "long", "long double", "short", "unsigned int", "unsigned short", "unsigned char", "unsigned long", "bool", "int16", "uint16", "int32", "uint32", "int64", "uint64", "wchar_t", "int8_t", "uint8_t", "uint16_t", "int16_t", "uint32_t", "int32_t", "uint64_t", "int64_t"};
    public static final String[] names = new String[]{"UMLRTNotify"};
    private ITranslationUnit m_iTu;
    private Model m_model;
    public final String langID = "C/C++";
    protected Classifier m_classifier;
    protected String m_projectName;

    public BatchReverseFunctionBody(ITranslationUnit iTu, String projectName) {
        this.m_iTu = iTu;
        this.m_projectName = projectName;
    }

    public BatchReverseFunctionBody(ITranslationUnit iTu, String projectName, Classifier classifier) {
        this.m_iTu = iTu;
        this.m_projectName = projectName;
        this.m_classifier = classifier;
    }

    public BatchReverseFunctionBody(ITranslationUnit iTu, String projectName, Model model) {
        this.m_iTu = iTu;
        this.m_projectName = projectName;
        this.m_model = model;
    }

    private List<Classifier> getOrCreateClassifiers(IParent iTu) throws Exception {
        UniqueEList ret = new UniqueEList();
        ICElement[] childrend = iTu.getChildren();
        int i = 0;
        while (i < childrend.length) {
            if (childrend[i] instanceof IStructure) {
                IStructure istructure = (IStructure)childrend[i];
                ret.add(RoundtripCppUtils.getOrCreateClassifier(istructure, istructure.getTranslationUnit(), this.m_projectName, this.m_model));
            } else if (childrend[i] instanceof IParent) {
                ret.addAll(this.getOrCreateClassifiers((IParent)childrend[i]));
            } else if (childrend[i] instanceof IVariableDeclaration || childrend[i] instanceof IMethod) {
                ret.add(ReverseUtils.getTypeOfVariableOrMethod(childrend[i], this.m_iTu));
            }
            ++i;
        }
        return ret;
    }

    public boolean isAnsiType(String name) {
        String[] stringArray = ansiTypes;
        int n = ansiTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (item.equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void run() throws Exception {
        SyncStatus.syncFromEditor = true;
        Object classifiers = new UniqueEList();
        try {
            classifiers = this.getOrCreateClassifiers((IParent)this.m_iTu);
        }
        catch (CModelException e1) {
            e1.printStackTrace();
        }
        Iterator iterator = classifiers.iterator();
        while (iterator.hasNext()) {
            this.m_classifier = (Classifier)iterator.next();
            ICProject project = CoreModel.getDefault().getCModel().getCProject(this.m_projectName);
            IIndex index = null;
            try {
                index = CCorePlugin.getIndexManager().getIndex(project);
                index.acquireReadLock();
                ITranslationUnit itu = this.m_iTu;
                IASTNodeSelector selector = ASTUtils.getSelector(itu);
                this.reverseCpp(itu, selector, (IParent)itu);
                if (itu instanceof IWorkingCopy) {
                    ((IWorkingCopy)itu).reconcile(true, (IProgressMonitor)new NullProgressMonitor());
                }
                index.releaseReadLock();
            }
            catch (CModelException e) {
                e.printStackTrace();
                if (index == null) continue;
                index.releaseReadLock();
                continue;
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                    continue;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (index != null) {
                        index.releaseReadLock();
                    }
                }
            }
            if (index == null) continue;
            index.releaseReadLock();
        }
        SyncStatus.syncFromEditor = false;
    }

    public void reverseHeader(IASTTranslationUnit header) {
    }

    public void reverseCpp(ITranslationUnit itu, IASTNodeSelector selector, IParent parent) {
        try {
            this.examineChildren(itu, selector, (IParent)itu);
        }
        catch (CModelException e) {
            e.printStackTrace();
        }
        this.updateCppInclude(itu);
    }

    public void examineChildren(ITranslationUnit itu, IASTNodeSelector selector, IParent parent) throws CModelException {
        int position = 0;
        ICElement[] iCElementArray = parent.getChildren();
        int n = iCElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICElement child = iCElementArray[n2];
            if (child instanceof IParent) {
                this.examineChildren(itu, selector, (IParent)child);
            }
            ISourceRange range = null;
            if (child instanceof ISourceReference) {
                range = ((ISourceReference)child).getSourceRange();
            }
            if (child instanceof IFunctionDeclaration) {
                name = ((IFunctionDeclaration)child).getElementName();
                IASTNode node = selector.findEnclosingNode(range.getStartPos(), range.getLength());
                if (node instanceof IASTFunctionDefinition) {
                    IASTFunctionDefinition definition = (IASTFunctionDefinition)node;
                    IASTFunctionDeclarator declarator = definition.getDeclarator();
                    String body = BatchReverseFunctionBody.getBody(itu, definition);
                    Operation operation = this.updateMethod((IFunctionDeclaration)child, node, position, parent, name, body, declarator);
                }
                ++position;
            } else if (child instanceof IVariableDeclaration) {
                IASTDeclarator declarator;
                IASTSimpleDeclaration declaration;
                name = ((IVariableDeclaration)child).getElementName();
                String typeName = ((IVariableDeclaration)child).getTypeName();
                Object value = null;
                IASTNode node = selector.findEnclosingNode(range.getStartPos(), range.getLength());
                if (node instanceof IASTSimpleDeclaration && (declaration = (IASTSimpleDeclaration)node).getDeclarators().length > 0 && (declarator = declaration.getDeclarators()[0]) != null) {
                    IASTInitializerList listInitializer;
                    IASTInitializerClause[] clauses;
                    IASTInitializer initializer = declarator.getInitializer();
                    if (initializer instanceof IASTEqualsInitializer) {
                        IASTEqualsInitializer equalsInitializer = (IASTEqualsInitializer)initializer;
                        IASTInitializerClause clause = equalsInitializer.getInitializerClause();
                        if (clause != null) {
                            value = clause.getRawSignature();
                        }
                    } else if (initializer instanceof ICPPASTConstructorInitializer) {
                        ICPPASTConstructorInitializer constructorInitializer = (ICPPASTConstructorInitializer)initializer;
                        clauses = constructorInitializer.getArguments();
                        if (clauses != null && clauses.length > 0) {
                            value = "(";
                            i = 0;
                            while (i < clauses.length) {
                                value = (String)value + clauses[i].getRawSignature();
                                if (i != clauses.length - 1) {
                                    value = (String)value + ",";
                                }
                                ++i;
                            }
                            value = (String)value + ")";
                        }
                    } else if (initializer instanceof IASTInitializerList && (clauses = (listInitializer = (IASTInitializerList)initializer).getClauses()) != null && clauses.length > 0) {
                        value = "{";
                        i = 0;
                        while (i < clauses.length) {
                            value = (String)value + clauses[i].getRawSignature();
                            if (i != clauses.length - 1) {
                                value = (String)value + ",";
                            }
                            ++i;
                        }
                        value = (String)value + "}";
                    }
                }
                if (value != null) {
                    this.updateProperty(name, typeName, (String)value, this.m_classifier);
                }
            }
            ++n2;
        }
    }

    public void updateCppInclude(ITranslationUnit itu) {
        BatchReverseFunctionBody.updateCppInclude(itu, this.m_classifier);
    }

    public static void updateCppInclude(ITranslationUnit itu, Classifier classifier) {
        if (itu == null || classifier == null) {
            return;
        }
        String contents = new String(itu.getContents());
        int preBodyStart = contents.indexOf("// Include from Include stereotype (pre-body)");
        int preBodyEnd = contents.indexOf("// End of Include stereotype (pre-body)");
        String preBody = EMPTY;
        String body = EMPTY;
        if (preBodyStart != -1 && preBodyEnd > (preBodyStart += "// Include from Include stereotype (pre-body)".length())) {
            preBody = contents.substring(preBodyStart, preBodyEnd).trim();
        }
        int bodyStart = contents.indexOf("// Include from Include declaration (body)");
        int bodyEnd = contents.indexOf("// End of Include declaration (body)");
        if (bodyStart != -1 && bodyEnd > (bodyStart += "// Include from Include declaration (body)".length() + 1)) {
            body = contents.substring(bodyStart, bodyEnd).trim();
        }
        if (body.length() > 0 || preBody.length() > 0) {
            Include Include2 = (Include)StereotypeUtil.applyApp((Element)classifier, Include.class);
            Include2.setPreBody(preBody);
            Include2.setBody(body);
        }
    }

    private void updateProperty(String name, String typeName, String value, Classifier classifier) {
        if (name != null && typeName != null && value != null && classifier != null) {
            String[] typeNameTokens;
            String[] nameTokens = name.split(SEP);
            if (nameTokens.length > 1) {
                name = nameTokens[nameTokens.length - 1];
            }
            if ((typeNameTokens = typeName.split(SEP)).length > 1) {
                typeName = typeNameTokens[typeNameTokens.length - 1];
            }
            typeName = ReverseUtils.getCppTypeName(typeName);
            for (Property property : classifier.getAttributes()) {
                if (!property.getName().equals(name) || property.getType() == null || !property.getType().getName().equals(typeName)) continue;
                for (Element element : property.getOwnedElements()) {
                    if (!(element instanceof ValueSpecification) || !((ValueSpecification)element).getName().equals(DEFAULT_VALUE)) continue;
                    element.destroy();
                    break;
                }
                ValueSpecification valueSpecification = property.createDefaultValue(DEFAULT_VALUE, property.getType(), UMLPackage.Literals.OPAQUE_EXPRESSION);
                if (!(valueSpecification instanceof OpaqueExpression)) continue;
                OpaqueExpression opaqueExpression = (OpaqueExpression)valueSpecification;
                opaqueExpression.getLanguages().add((Object)ReverseCpp2Uml.Cpp_LangID);
                opaqueExpression.getBodies().add((Object)value);
            }
        }
    }

    public Operation updateMethod(IFunctionDeclaration function, IASTNode functionNode, int position, IParent parent, String qualifiedName, String body, IASTFunctionDeclarator declarator) {
        String[] names = qualifiedName.split(SEP);
        String name = names[names.length - 1];
        Operation operation = RoundtripCppUtils.findMatchOperation(this.m_classifier, declarator, names, this.m_iTu);
        if (operation == null) {
            return null;
        }
        if (function instanceof IMethodDeclaration) {
            IMethodDeclaration method = (IMethodDeclaration)function;
            try {
                String initStr;
                if (method.isConstructor() && !(initStr = ReverseUtils.getMemberInit(functionNode)).isEmpty()) {
                    StereotypeUtil.apply((Element)operation, ConstInit.class);
                    ((ConstInit)UMLUtil.getStereotypeApplication((Element)operation, ConstInit.class)).setInitialisation(initStr);
                }
            }
            catch (CModelException e) {
                e.printStackTrace();
            }
        }
        OpaqueBehavior ob = null;
        if (operation.getMethods().size() == 0) {
            if (this.m_classifier instanceof Class) {
                ob = (OpaqueBehavior)((Class)this.m_classifier).createOwnedBehavior(name, UMLPackage.eINSTANCE.getOpaqueBehavior());
            }
            ob.setSpecification((BehavioralFeature)operation);
            ob.setIsReentrant(false);
        } else {
            ob = (OpaqueBehavior)operation.getMethods().get(0);
            if (!ob.getName().equals(name)) {
                ob.setName(name);
            }
        }
        if (ob.getBodies().size() == 0) {
            ob.getLanguages().add((Object)"C/C++");
            ob.getBodies().add((Object)EMPTY);
        }
        int i = 0;
        while (i < ob.getLanguages().size()) {
            if (((String)ob.getLanguages().get(i)).equals("C/C++") && i < ob.getBodies().size()) {
                ob.getBodies().set(i, (Object)body);
            }
            ++i;
        }
        return operation;
    }

    public static String getBody(ITranslationUnit itu, IASTFunctionDefinition definition) {
        IASTStatement body = definition.getBody();
        if (body instanceof IASTCompoundStatement) {
            IASTCompoundStatement bodyComp = (IASTCompoundStatement)body;
            IASTFileLocation bodyLoc = bodyComp.getFileLocation();
            int start = bodyLoc.getNodeOffset();
            int end = start + bodyLoc.getNodeLength();
            char[] contents = itu.getContents();
            int indentation = BatchReverseFunctionBody.getIndentation(contents);
            return StringUtils.decreaseIndent((char[])contents, (int)(start + 2), (int)(end - 2), (int)indentation);
        }
        return EMPTY;
    }

    private static int getIndentation(char[] contents) {
        if (contents != null && contents.length > 0) {
            String stringContent = new String(contents);
            int indentation = 4;
            BufferedReader bufReader = new BufferedReader(new StringReader(stringContent));
            String line = null;
            try {
                while ((line = bufReader.readLine()) != null) {
                    char[] lineChars = line.toCharArray();
                    int leadingSpaces = 0;
                    int i = 0;
                    while (i < lineChars.length) {
                        char c = lineChars[i];
                        if (c == ' ') {
                            ++leadingSpaces;
                        }
                        if (leadingSpaces == 4) break;
                        ++i;
                    }
                    if (leadingSpaces >= indentation) continue;
                    indentation = leadingSpaces;
                }
            }
            catch (IOException e) {
                return 0;
            }
            return indentation;
        }
        return 0;
    }

    public void updateComment(ITranslationUnit itu, IASTFunctionDefinition definition, Operation operation) {
        int start;
        IASTFileLocation bodyLoc = definition.getFileLocation();
        int end = start = bodyLoc.getNodeOffset() - 1;
        char[] contents = itu.getContents();
        Object comment = EMPTY;
        while (start > 0) {
            if (contents[start] == '/' && contents[start + 1] == '*') {
                int i = start += "/**".length();
                while (i < end) {
                    comment = (String)comment + contents[i];
                    ++i;
                }
                comment = ((String)comment).replace("\n * ", "\n").replace("*/", EMPTY).trim();
                break;
            }
            --start;
        }
        if (((String)comment).length() > 0) {
            Comment commentUML;
            int atParam = ((String)comment).indexOf(sAtParam);
            Object commentMethodOnly = atParam != -1 ? ((String)comment).substring(0, atParam).trim() : comment;
            EList commentsUML = operation.getOwnedComments();
            if (commentsUML.size() == 0) {
                commentUML = operation.createOwnedComment();
                commentUML.getAnnotatedElements().add((Object)commentUML);
            } else {
                commentUML = (Comment)commentsUML.get(0);
            }
            while (atParam != -1) {
                int currentAtParam = atParam;
                String commentParam = (atParam = ((String)comment).indexOf(sAtParam, atParam + 1)) != -1 ? ((String)comment).substring(currentAtParam, atParam) : ((String)comment).substring(currentAtParam);
                int atParamName = sAtParam.length();
                while (atParamName < commentParam.length() && Character.isWhitespace(commentParam.charAt(atParamName))) {
                    ++atParamName;
                }
                int atParamNameEnd = atParamName;
                while (atParamNameEnd < commentParam.length() && !Character.isWhitespace(commentParam.charAt(atParamNameEnd))) {
                    ++atParamNameEnd;
                }
                if (atParamNameEnd >= commentParam.length() - 1) continue;
                String parameterName = commentParam.substring(atParamName, atParamNameEnd);
                String commentParamText = commentParam.substring(atParamNameEnd).trim();
                Parameter parameter = operation.getOwnedParameter(parameterName, null, false, false);
                if (parameter != null) {
                    Comment commentParamUML;
                    EList commentsParamUML = parameter.getOwnedComments();
                    if (commentsParamUML.size() == 0) {
                        commentParamUML = parameter.createOwnedComment();
                        commentParamUML.getAnnotatedElements().add((Object)commentParamUML);
                    } else {
                        commentParamUML = (Comment)commentsParamUML.get(0);
                    }
                    commentParamUML.setBody(commentParamText);
                    continue;
                }
                commentMethodOnly = (String)commentMethodOnly + "\n @param" + parameterName + " not found(!) " + commentParamText;
            }
            commentUML.setBody((String)commentMethodOnly);
        }
    }
}

