/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.c.codegen.lib;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.papyrus.designer.languages.c.codegen.lib.AcslScript;
import org.eclipse.papyrus.designer.languages.c.codegen.preferences.CCodeGenConstants;
import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.FinalState;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class StateMachineScript {
    private static List<Transition> transitions = new ArrayList<Transition>();
    public static Region region;
    public List<State> states = new ArrayList<State>();
    public static String ACTIVE_ROOT_STATE_ID;

    static {
        ACTIVE_ROOT_STATE_ID = "activeStateID";
    }

    public static String genProcessCompletionEventMethodBody(Class clazz) {
        boolean _greaterThan;
        region = (Region)IterableExtensions.head((Iterable)((StateMachine)IterableExtensions.head((Iterable)Iterables.filter((Iterable)clazz.getOwnedBehaviors(), StateMachine.class))).getRegions());
        Functions.Function1 _function = it -> it.getSource() != null && it.getTarget() != null;
        Iterables.addAll(transitions, (Iterable)IterableExtensions.filter((Iterable)region.getTransitions(), (Functions.Function1)_function));
        ArrayList NonTriggeredTrans = new ArrayList();
        Consumer<Transition> _function_1 = it -> {
            if (it.getSource() instanceof State && !(it.getTarget() instanceof FinalState) && ListExtensions.map((List)it.getTriggers(), it_1 -> it_1.getEvent()).size() == 0) {
                NonTriggeredTrans.add(it);
            }
        };
        transitions.forEach(_function_1);
        Functions.Function1 _function_2 = it -> it.getSource();
        Set sources = IterableExtensions.toSet((Iterable)Iterables.filter((Iterable)ListExtensions.map(NonTriggeredTrans, (Functions.Function1)_function_2), State.class));
        Set setTransitions = IterableExtensions.toSet(NonTriggeredTrans);
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        int _size = NonTriggeredTrans.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _builder.append("switch(self->");
            _builder.append(ACTIVE_ROOT_STATE_ID);
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            for (State state : sources) {
                _builder.append("\t");
                _builder.append("case ");
                String _name = state.getName();
                _builder.append(_name, "\t");
                _builder.append(": ");
                _builder.newLineIfNotEmpty();
                for (Transition t : setTransitions) {
                    Vertex _source = t.getSource();
                    boolean _equals = Objects.equals(_source, state);
                    if (!_equals) continue;
                    _builder.append("\t");
                    _builder.append("\t");
                    Vertex _source_1 = t.getSource();
                    String _generateTransitionCode = StateMachineScript.generateTransitionCode((State)_source_1, t);
                    _builder.append(_generateTransitionCode, "\t\t");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("{}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("break;");
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.append("default:");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("// do nothing");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("break;");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        String body = _builder.toString();
        return body;
    }

    public static String genProcessMethodBody(Event callevent, Class clazz) {
        boolean _greaterThan;
        region = (Region)IterableExtensions.head((Iterable)((StateMachine)IterableExtensions.head((Iterable)Iterables.filter((Iterable)clazz.getOwnedBehaviors(), StateMachine.class))).getRegions());
        Functions.Function1 _function = it -> it.getSource() != null && it.getTarget() != null;
        Iterables.addAll(transitions, (Iterable)IterableExtensions.filter((Iterable)region.getTransitions(), (Functions.Function1)_function));
        ArrayList TriggeredTrans = new ArrayList();
        Consumer<Transition> _function_1 = it -> {
            if (it.getSource() instanceof State && ListExtensions.map((List)it.getTriggers(), it_1 -> it_1.getEvent()).size() != 0) {
                Functions.Function1 _function_2 = it_1 -> it_1.getEvent();
                List events = IterableExtensions.toList((Iterable)ListExtensions.map((List)it.getTriggers(), (Functions.Function1)_function_2));
                boolean _contains = events.contains(callevent);
                if (_contains) {
                    boolean _not;
                    boolean _contains_1 = TriggeredTrans.contains(it);
                    boolean bl = _not = !_contains_1;
                    if (_not) {
                        TriggeredTrans.add(it);
                    }
                }
            }
        };
        transitions.forEach(_function_1);
        Functions.Function1 _function_2 = it -> it.getSource();
        Set sources = IterableExtensions.toSet((Iterable)Iterables.filter((Iterable)ListExtensions.map(TriggeredTrans, (Functions.Function1)_function_2), State.class));
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        int _size = TriggeredTrans.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _builder.append("switch(self->");
            _builder.append(ACTIVE_ROOT_STATE_ID);
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            for (State state : sources) {
                _builder.append("\t\t\t\t\t");
                _builder.append("case ");
                String _name = state.getName();
                _builder.append(_name, "\t\t\t\t\t");
                _builder.append(": ");
                _builder.newLineIfNotEmpty();
                for (Transition t : TriggeredTrans) {
                    Vertex _source = t.getSource();
                    boolean _equals = Objects.equals(_source, state);
                    if (!_equals) continue;
                    _builder.append("\t\t\t\t\t");
                    _builder.append("\t");
                    Vertex _source_1 = t.getSource();
                    String _generateTransitionCode = StateMachineScript.generateTransitionCode((State)_source_1, t);
                    _builder.append(_generateTransitionCode, "\t\t\t\t\t\t");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t\t\t\t\t");
                _builder.append("\t");
                _builder.append("{}");
                _builder.newLine();
                _builder.append("\t\t\t\t\t");
                _builder.append("\t");
                _builder.newLine();
                _builder.append("\t\t\t\t\t");
                _builder.append("break;");
                _builder.newLine();
            }
            _builder.append("\t\t\t\t\t");
            _builder.append("default:");
            _builder.newLine();
            _builder.append("\t\t\t\t\t");
            _builder.append("//do nothing");
            _builder.newLine();
            _builder.append("\t\t\t\t\t");
            _builder.append("break;");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        String body = _builder.toString();
        return body;
    }

    public static String generateTransitionCode(State s, Transition t) {
        StringConcatenation _builder = new StringConcatenation();
        String ret = _builder.toString();
        String cGuard = StateMachineScript.getGuard(t);
        String acslGuard = AcslScript.getGuard(t);
        Vertex _target = t.getTarget();
        if (_target instanceof State) {
            boolean _not_1;
            boolean _not;
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("/*  transition guard */");
            _builder_1.newLine();
            boolean _isEmpty = acslGuard.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                _builder_1.append(acslGuard);
            }
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("if (");
            boolean _isEmpty_1 = cGuard.isEmpty();
            boolean bl2 = _not_1 = !_isEmpty_1;
            if (_not_1) {
                _builder_1.append(cGuard);
            } else {
                _builder_1.append("1");
            }
            _builder_1.append(") {");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("\t");
            _builder_1.append("/* exit Transition source */");
            _builder_1.newLine();
            _builder_1.append("\t");
            _builder_1.append("if (self->states[");
            String _name = t.getSource().getName();
            _builder_1.append(_name, "\t");
            _builder_1.append("].exit != NULL) {");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("\t\t");
            _builder_1.append("self->states[");
            String _name_1 = t.getSource().getName();
            _builder_1.append(_name_1, "\t\t");
            _builder_1.append("].exit();");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("\t");
            _builder_1.append("}");
            _builder_1.newLine();
            _builder_1.append("\t");
            _builder_1.newLine();
            _builder_1.append("\t");
            _builder_1.append("/* transition effect*/");
            _builder_1.newLine();
            _builder_1.append("\t");
            String _transitionEffect = StateMachineScript.getTransitionEffect(t);
            _builder_1.append(_transitionEffect, "\t");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("\t");
            _builder_1.newLine();
            _builder_1.append("\t");
            _builder_1.append("/* update current state */");
            _builder_1.newLine();
            _builder_1.append("\t");
            _builder_1.append("self->");
            _builder_1.append(ACTIVE_ROOT_STATE_ID, "\t");
            _builder_1.append(" = ");
            String _name_2 = t.getTarget().getName();
            _builder_1.append(_name_2, "\t");
            _builder_1.append(" ;");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("\t");
            _builder_1.newLine();
            _builder_1.append("\t");
            _builder_1.append("/* entry of the new state */");
            _builder_1.newLine();
            _builder_1.append("\t");
            _builder_1.append("if (self->states[");
            String _name_3 = t.getTarget().getName();
            _builder_1.append(_name_3, "\t");
            _builder_1.append("].entry != NULL) {");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("\t\t");
            _builder_1.append("self->states[");
            String _name_4 = t.getTarget().getName();
            _builder_1.append(_name_4, "\t\t");
            _builder_1.append("].entry();");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("\t");
            _builder_1.append("}");
            _builder_1.newLine();
            _builder_1.append("\t");
            _builder_1.newLine();
            _builder_1.append("\t");
            _builder_1.append("/* doActivity of the new state */");
            _builder_1.newLine();
            _builder_1.append("\t");
            _builder_1.append("if (self->states[");
            String _name_5 = t.getTarget().getName();
            _builder_1.append(_name_5, "\t");
            _builder_1.append("].doActivity != NULL) {");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("\t\t");
            _builder_1.append("self->states[");
            String _name_6 = t.getTarget().getName();
            _builder_1.append(_name_6, "\t\t");
            _builder_1.append("].doActivity();");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("\t");
            _builder_1.append("}");
            _builder_1.newLine();
            _builder_1.append("\t");
            _builder_1.newLine();
            _builder_1.append("\t");
            _builder_1.append("/* always call process completion event to handle completion transition */");
            _builder_1.newLine();
            _builder_1.append("\t");
            _builder_1.append("ProcessCompletionEvent(self);");
            _builder_1.newLine();
            _builder_1.append("} else");
            ret = _builder_1.toString();
        }
        return ret;
    }

    public static String getTransitionEffect(Transition t) {
        if (t.getEffect() != null && t.getEffect() instanceof OpaqueBehavior) {
            Behavior _effect = t.getEffect();
            return (String)IterableExtensions.head((Iterable)((OpaqueBehavior)_effect).getBodies());
        }
        StringConcatenation _builder = new StringConcatenation();
        return _builder.toString();
    }

    public static String getGuard(Transition t) {
        if (t.getGuard() != null && t.getGuard().getSpecification() instanceof OpaqueExpression) {
            int _size_1;
            boolean _tripleEquals;
            ValueSpecification _specification = t.getGuard().getSpecification();
            OpaqueExpression opaqueExpression = (OpaqueExpression)_specification;
            int _size = opaqueExpression.getLanguages().size();
            boolean bl = _tripleEquals = _size == (_size_1 = opaqueExpression.getBodies().size());
            if (_tripleEquals) {
                int i = 0;
                while (i < opaqueExpression.getLanguages().size()) {
                    String language = (String)opaqueExpression.getLanguages().get(i);
                    Matcher matcher = CCodeGenConstants.supportedLanguages.matcher(language);
                    boolean _matches = matcher.matches();
                    if (_matches) {
                        return GenUtils.cleanCR((String)((String)opaqueExpression.getBodies().get(i)));
                    }
                    ++i;
                }
            }
        }
        return "";
    }

    public static String getGuard(Transition t, Pattern selectedLanguages) {
        if (t.getGuard() != null && t.getGuard().getSpecification() instanceof OpaqueExpression) {
            int _size_1;
            boolean _tripleEquals;
            ValueSpecification _specification = t.getGuard().getSpecification();
            OpaqueExpression opaqueExpression = (OpaqueExpression)_specification;
            int _size = opaqueExpression.getLanguages().size();
            boolean bl = _tripleEquals = _size == (_size_1 = opaqueExpression.getBodies().size());
            if (_tripleEquals) {
                int i = 0;
                while (i < opaqueExpression.getLanguages().size()) {
                    String language = (String)opaqueExpression.getLanguages().get(i);
                    Matcher matcher = selectedLanguages.matcher(language);
                    boolean _matches = matcher.matches();
                    if (_matches) {
                        return GenUtils.cleanCR((String)((String)opaqueExpression.getBodies().get(i)));
                    }
                    ++i;
                }
            }
        }
        return "";
    }
}

