/**
 * Copyright (c) 2015 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * Contributors:
 *     CEA LIST - initial API and implementation
 */
package org.eclipse.papyrus.designer.languages.c.codegen.module;

import org.eclipse.papyrus.designer.languages.c.codegen.lib.CommonScript;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public class CommonModuleScript {
  public static CharSequence genHeadingModule(final NamedElement namedElement) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("#ifndef ");
    CharSequence _genName = CommonScript.genName(namedElement);
    String _upperCase = ((String) _genName).toUpperCase();
    _builder.append(_upperCase);
    _builder.append("_C_");
    _builder.newLineIfNotEmpty();
    _builder.append("#define ");
    CharSequence _genName_1 = CommonScript.genName(namedElement);
    String _upperCase_1 = ((String) _genName_1).toUpperCase();
    _builder.append(_upperCase_1);
    _builder.append("_C_");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public static CharSequence genEndModule(final NamedElement namedElement) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("#endif /*");
    CharSequence _genName = CommonScript.genName(namedElement);
    String _upperCase = ((String) _genName).toUpperCase();
    _builder.append(_upperCase);
    _builder.append("_C_*/");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
}
