/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.filter.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.emf.Activator;
import org.eclipse.papyrus.infra.nattable.filter.configuration.IFilterConfiguration;
import org.eclipse.papyrus.infra.nattable.filter.configuration.TextEditorFilterConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestylePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.StringValueStyle;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;

public class FilterConfigurationRegistry {
    private Map<Integer, List<IFilterConfiguration>> contributionByOrder;
    private Map<String, IFilterConfiguration> configurationById;
    public static final String EXTENSION_ID = "org.eclipse.papyrus.infra.nattable.filter.configuration";
    public static final String CELL_EDITOR_CONFIGURATION_CLASS_ATTRIBUTE = "class";
    public static final String ORDER_ATTRIBUTE = "order";
    public static final FilterConfigurationRegistry INSTANCE = new FilterConfigurationRegistry();

    private FilterConfigurationRegistry() {
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
        this.contributionByOrder = new TreeMap<Integer, List<IFilterConfiguration>>();
        this.configurationById = new HashMap<String, IFilterConfiguration>();
        IConfigurationElement[] iConfigurationElementArray = configElements;
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            String orderAttribute = iConfigurationElement.getAttribute(ORDER_ATTRIBUTE);
            if (!TypeUtils.isIntegerValue((String)orderAttribute)) {
                Activator.log.warn(NLS.bind((String)"The order declared for a filter configuration in the plugin {0} is not an integer", (Object)iConfigurationElement.getNamespaceIdentifier()));
            } else {
                Integer order = Integer.parseInt(orderAttribute);
                try {
                    Object tmp = iConfigurationElement.createExecutableExtension(CELL_EDITOR_CONFIGURATION_CLASS_ATTRIBUTE);
                    if (!(tmp instanceof IFilterConfiguration)) {
                        Activator.log.warn(NLS.bind((String)"The class {0} declared as filter configuration doesn't implements the interface {1}", (Object)tmp.getClass().getName(), (Object)IFilterConfiguration.class.getName()));
                    } else {
                        IFilterConfiguration factory = (IFilterConfiguration)tmp;
                        if (factory != null) {
                            String id = factory.getConfigurationId();
                            if (id == null || id.isEmpty()) {
                                Activator.log.warn(NLS.bind((String)"The id returned by the class {0} is null or empty, so this contribution will be ignored", (Object)factory.getClass().getName()));
                            } else {
                                if (this.configurationById.containsKey(id)) {
                                    Activator.log.warn(NLS.bind((String)"The id returned by the class {0} already exists, so the previous contribution will be erased", (Object)factory.getClass().getName()));
                                }
                                this.configurationById.put(id, factory);
                                List<IFilterConfiguration> list = this.contributionByOrder.get(order);
                                if (list == null) {
                                    list = new ArrayList<IFilterConfiguration>();
                                    this.contributionByOrder.put(order, list);
                                }
                                list.add(factory);
                            }
                        }
                    }
                }
                catch (CoreException e) {
                    Activator.log.error((Throwable)e);
                }
            }
            ++n2;
        }
    }

    public void configureFilter(IConfigRegistry configRegistry, Object axis, String configLabel) {
        IFilterConfiguration conf = this.getFilterConfigurationToUse(configRegistry, axis);
        if (conf == null) {
            conf = new TextEditorFilterConfiguration();
        }
        conf.configureFilter(configRegistry, axis, configLabel);
    }

    private IFilterConfiguration getFilterConfigurationToUse(IConfigRegistry configRegistry, Object axis) {
        if (axis instanceof IAxis) {
            IFilterConfiguration conf;
            StringValueStyle style = (StringValueStyle)((IAxis)axis).getNamedStyle(NattablestylePackage.eINSTANCE.getStringValueStyle(), "filterForcedByUserId");
            if (style == null) {
                style = (StringValueStyle)((IAxis)axis).getNamedStyle(NattablestylePackage.eINSTANCE.getStringValueStyle(), "filterId");
            }
            if (style != null && (conf = this.getFilterConfiguration(style.getStringValue())) != null) {
                return conf;
            }
        }
        for (Map.Entry<Integer, List<IFilterConfiguration>> entry : this.contributionByOrder.entrySet()) {
            for (IFilterConfiguration current : entry.getValue()) {
                if (!current.handles(configRegistry, axis)) continue;
                return current;
            }
        }
        return null;
    }

    private IFilterConfiguration getFilterConfiguration(String filterConfigurationId) {
        return this.configurationById.get(filterConfigurationId);
    }
}

