/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.providers;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IPrimaryEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.editpolicy.CreateEditPoliciesOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.editpolicy.IEditPolicyProvider;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.PapyrusPopupBarEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.service.ProviderServiceUtil;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.ServiceUtilsForEditPart;

public class PopupBarEditPolicyProvider
extends AbstractProvider
implements IEditPolicyProvider {
    public boolean provides(IOperation operation) {
        if (operation instanceof CreateEditPoliciesOperation) {
            CreateEditPoliciesOperation epOperation = (CreateEditPoliciesOperation)operation;
            EditPart editPart = epOperation.getEditPart();
            if (!ProviderServiceUtil.isPapyrusPart(editPart)) {
                return false;
            }
            try {
                ServicesRegistry registry = ServiceUtilsForEditPart.getInstance().getServiceRegistry(editPart);
                if (registry == null) {
                    return false;
                }
            }
            catch (ServiceException ex) {
                return false;
            }
            return editPart instanceof IGraphicalEditPart;
        }
        return false;
    }

    public void createEditPolicies(EditPart editPart) {
        if (editPart instanceof IPrimaryEditPart) {
            editPart.installEditPolicy((Object)"PopupBarEditPolicy", (EditPolicy)new PapyrusPopupBarEditPolicy());
        }
    }
}

