/*
 * Decompiled with CFR 0.152.
 */
package xpt.providers;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import metamodel.MetaModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenClassifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagramElementTarget;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDomainElementTarget;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenExpressionInterpreter;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenExpressionProviderBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenJavaExpressionProvider;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenMeasurable;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenMetricContainer;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenMetricRule;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNotationElementTarget;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.MetaDef;
import org.eclipse.papyrus.gmf.internal.common.codegen.Conversions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import plugin.Activator;
import xpt.CodeStyle;
import xpt.Common;
import xpt.Common_qvto;
import xpt.editor.DiagramEditorUtil;
import xpt.editor.VisualIDRegistry;
import xpt.expressions.getExpression;
import xpt.providers.ElementTypes;
import xpt.providers.MetricsResultView;
import xpt.providers.Metrics_qvto;

@Singleton
public class MetricProvider {
    @Inject
    @Extension
    private Common _common;
    @Inject
    @Extension
    private Common_qvto _common_qvto;
    @Inject
    @Extension
    private Metrics_qvto _metrics_qvto;
    @Inject
    @Extension
    private CodeStyle _codeStyle;
    @Inject
    private Activator xptActivator;
    @Inject
    private MetaModel xptMetaModel;
    @Inject
    private MetricsResultView xptMetricsResultView;
    @Inject
    private VisualIDRegistry xptVisualIDRegistry;
    @Inject
    private getExpression xptGetExpression;
    @Inject
    private ElementTypes xptElementTypes;
    @Inject
    private DiagramEditorUtil xptDiagramEditorUtil;

    @MetaDef
    public CharSequence invokeCalcMethod(GenMetricRule it, String accessor, boolean isSpecific) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.qualifiedClassName(it.getContainer().getEditorGen().getDiagram());
        _builder.append((Object)_qualifiedClassName);
        _builder.append(".");
        String _calcMethodName = this._metrics_qvto.calcMethodName(it);
        _builder.append(_calcMethodName);
        _builder.append("(");
        if (!isSpecific) {
            _builder.append("(");
            CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName(it.getTarget().getContext());
            _builder.append((Object)_QualifiedClassName);
            _builder.append(") ");
        }
        _builder.append(accessor);
        _builder.append(")");
        return _builder;
    }

    public CharSequence className(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        String _metricProviderClassName = it.getMetricProviderClassName();
        _builder.append(_metricProviderClassName);
        return _builder;
    }

    public CharSequence packageName(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        String _providersPackageName = it.getProvidersPackageName();
        _builder.append(_providersPackageName);
        return _builder;
    }

    public CharSequence qualifiedClassName(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _packageName = this.packageName(it);
        _builder.append((Object)_packageName);
        _builder.append(".");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className);
        return _builder;
    }

    public CharSequence fullPath(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName);
        return _builder;
    }

    public CharSequence MetricProvider(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _copyright = this._common.copyright(it.getEditorGen());
        _builder.append((Object)_copyright);
        _builder.newLineIfNotEmpty();
        _builder.append("package ");
        CharSequence _packageName = this.packageName(it);
        _builder.append((Object)_packageName);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generatedClassComment = this._common.generatedClassComment();
        _builder.append((Object)_generatedClassComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public class ");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("public static class MetricsAction extends org.eclipse.jface.action.Action {");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_1, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("private org.eclipse.ui.IWorkbenchPage page;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_2, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("public MetricsAction(org.eclipse.ui.IWorkbenchPage page) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("setText(\"Metrics\");");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("this.page = page;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _generatedMemberComment_3 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_3, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("public void run() {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("org.eclipse.ui.IWorkbenchPart workbenchPart = page.getActivePart();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("org.eclipse.ui.IViewPart metricsView = null;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("try {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("metricsView = page.findView(");
        CharSequence _resultViewID = this.resultViewID(it);
        _builder.append((Object)_resultViewID, "\t\t\t\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        _builder.append("if (metricsView == null) {");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("metricsView = page.showView(");
        CharSequence _resultViewID_1 = this.resultViewID(it);
        _builder.append((Object)_resultViewID_1, "\t\t\t\t\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("if (metricsView != null && workbenchPart instanceof org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart) {");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t");
        _builder.append("final org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart part = (org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart) workbenchPart;");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t");
        _builder.append("((ResultView) metricsView).setInput(part);");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("page.activate(metricsView);");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("} catch (org.eclipse.ui.PartInitException e) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
        _builder.append((Object)_qualifiedClassName, "\t\t\t\t");
        _builder.append(".getInstance().logError(\"Diagram metric view failure\", e); ");
        CharSequence _nonNLS = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS, "\t\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        CharSequence _calculateMetricsMethods = this.calculateMetricsMethods(it);
        _builder.append((Object)_calculateMetricsMethods);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _formatNotationElementNameMethod = this.formatNotationElementNameMethod(it);
        _builder.append((Object)_formatNotationElementNameMethod);
        _builder.newLineIfNotEmpty();
        CharSequence _formatSemanticElementNameMethod = this.formatSemanticElementNameMethod(it);
        _builder.append((Object)_formatSemanticElementNameMethod);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _metricsClasses = this.metricsClasses(it);
        _builder.append((Object)_metricsClasses);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _keysAndToolTipsMethods = this.keysAndToolTipsMethods(it.getEditorGen().getMetrics());
        _builder.append((Object)_keysAndToolTipsMethods);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        Functions.Function1 _function = m -> m.getRule() != null && m.getTarget() != null && m.getTarget().getContext() != null;
        Iterable _filter = IterableExtensions.filter((Iterable)it.getEditorGen().getMetrics().getMetrics(), (Functions.Function1)_function);
        for (GenMetricRule m2 : _filter) {
            CharSequence _metricCalcMethod = this.metricCalcMethod(m2);
            _builder.append((Object)_metricCalcMethod);
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        CharSequence _MetricsResultView = this.xptMetricsResultView.MetricsResultView(it);
        _builder.append((Object)_MetricsResultView, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence resultViewQualifiedClassName(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName);
        _builder.append(".");
        CharSequence _className = this.xptMetricsResultView.className(it);
        _builder.append((Object)_className);
        return _builder;
    }

    public CharSequence resultViewID(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _resultViewQualifiedClassName = this.resultViewQualifiedClassName(it);
        _builder.append((Object)_resultViewQualifiedClassName);
        _builder.append(".VIEW_ID");
        return _builder;
    }

    public CharSequence calculateMetricsMethods(GenDiagram it) {
        boolean _notEmpty_2;
        boolean _notEmpty_1;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("static java.util.List calculateMetrics(org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart diagramPart) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("final org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart diagramEditPart = diagramPart.getDiagramEditPart();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("try {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return (java.util.List) diagramPart.getDiagramEditPart().getEditingDomain().runExclusive(new org.eclipse.emf.transaction.RunnableWithResult.Impl() {");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void run() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("org.eclipse.gmf.runtime.notation.Diagram diagram = diagramEditPart.getDiagramView();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("java.util.ArrayList<ElementMetrics> metrics = new java.util.ArrayList<");
        String _diamondOp = this._codeStyle.diamondOp((GenCommonBase)it, "ElementMetrics");
        _builder.append(_diamondOp, "\t\t");
        _builder.append(">(50);");
        _builder.newLineIfNotEmpty();
        boolean _notEmpty = this._common_qvto.notEmpty(this._metrics_qvto.getNotationMetrics(it.getEditorGen().getMetrics()));
        if (_notEmpty) {
            _builder.append("\t\t");
            _builder.append("calculateNotationElementMetrics(diagram, metrics);");
            _builder.newLine();
        }
        if (_notEmpty_1 = this._common_qvto.notEmpty(this._metrics_qvto.getDiagramMetrics(it.getEditorGen().getMetrics()))) {
            _builder.append("\t\t");
            _builder.append("calculateDiagramElementMetrics(diagram, metrics);");
            _builder.newLine();
        }
        if (_notEmpty_2 = this._common_qvto.notEmpty(this._metrics_qvto.getDomainMetrics(it.getEditorGen().getMetrics()))) {
            _builder.append("\t\t");
            _builder.append("calculateSemanticElementMetrics(diagramEditPart, metrics);");
            _builder.newLine();
        }
        _builder.append("\t\t");
        _builder.append("setResult(metrics);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("});");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("} catch (InterruptedException e) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return java.util.Collections.EMPTY_LIST;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        boolean _notEmpty_3 = this._common_qvto.notEmpty(this._metrics_qvto.getNotationMetrics(it.getEditorGen().getMetrics()));
        if (_notEmpty_3) {
            CharSequence _calcNotationMetricsMethod = this.calcNotationMetricsMethod(it.getEditorGen());
            _builder.append((Object)_calcNotationMetricsMethod);
        }
        _builder.newLineIfNotEmpty();
        boolean _notEmpty_4 = this._common_qvto.notEmpty(this._metrics_qvto.getDiagramMetrics(it.getEditorGen().getMetrics()));
        if (_notEmpty_4) {
            CharSequence _calcDiagramMetricsMethod = this.calcDiagramMetricsMethod(it.getEditorGen());
            _builder.append((Object)_calcDiagramMetricsMethod);
        }
        _builder.newLineIfNotEmpty();
        boolean _notEmpty_5 = this._common_qvto.notEmpty(this._metrics_qvto.getDomainMetrics(it.getEditorGen().getMetrics()));
        if (_notEmpty_5) {
            CharSequence _calcDomainMetricsMethod = this.calcDomainMetricsMethod(it.getEditorGen());
            _builder.append((Object)_calcDomainMetricsMethod);
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence metricsClasses(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("private static class ElementMetrics {");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("final Metric[] metrics;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_2, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("final String targetElementQName;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_3 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_3, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("final org.eclipse.swt.graphics.Image elementImage;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_4 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_4, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("String diagramElementID; ");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_5 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_5, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("ElementMetrics(org.eclipse.emf.ecore.EObject target, String name, Metric[] metrics) {");
        _builder.newLine();
        _builder.append("\t");
        CharSequence __assert = this._common._assert("metrics.length > 0");
        _builder.append((Object)__assert, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence __assert_1 = this._common._assert("name != null");
        _builder.append((Object)__assert_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("this.metrics = metrics;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("this.targetElementQName = name;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("org.eclipse.emf.ecore.EClass imageTarget = target.eClass();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (target instanceof org.eclipse.gmf.runtime.notation.View) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("org.eclipse.gmf.runtime.notation.View viewTarget = (org.eclipse.gmf.runtime.notation.View) target;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (\"\".equals(viewTarget.getType()) && viewTarget.getElement() != null) { ");
        CharSequence _nonNLS = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("imageTarget = viewTarget.getElement().eClass();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("this.elementImage = ");
        CharSequence _imageAccessor = this.getImageAccessor(it, "imageTarget");
        _builder.append((Object)_imageAccessor, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_6 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_6, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("Metric getMetricByKey(String key) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("for (int i = 0; i < metrics.length; i++) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (metrics[i].key.equals(key)) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return metrics[i];");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return null;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generatedMemberComment_7 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_7);
        _builder.newLineIfNotEmpty();
        _builder.append("private static class Metric implements Comparable {");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_8 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_8, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("final String key;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_9 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_9, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("final Double value;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_10 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_10, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("final Double lowLimit;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_11 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_11, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("final Double highLimit;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_12 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_12, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("final String displayValue;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_13 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_13, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("Metric(String key, Double value) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("this(key, value, null, null);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_14 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_14, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("Metric(String key, Double value, Double low, Double high) {");
        _builder.newLine();
        _builder.append("\t");
        CharSequence __assert_2 = this._common._assert("key != null");
        _builder.append((Object)__assert_2, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("this.key = key;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("this.value = value;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("this.lowLimit = low;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("this.highLimit = high;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("this.displayValue = (value != null) ? java.text.NumberFormat.getInstance().format(value) : \"null\"; //$NON-NLS-1$");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_15 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_15, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("public int compareTo(Object other) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("Metric otherMetric = (Metric) other;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (value != null && otherMetric.value != null) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return (value.longValue() < otherMetric.value.longValue()) ? -1");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append(": (value.longValue() == otherMetric.value.longValue() ? 0 : 1);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return (value == null && otherMetric.value == null) ? 0");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append(": (value == null) ? -1 : 1;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getImageAccessor(GenDiagram it, String imageClassVar) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.xptElementTypes.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName);
        _builder.append(".getImage(");
        _builder.append(imageClassVar);
        _builder.append(")");
        return _builder;
    }

    public CharSequence calcNotationMetricsMethod(GenEditorGenerator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("static void calculateNotationElementMetrics(org.eclipse.gmf.runtime.notation.Diagram diagram, java.util.List<ElementMetrics> metricsList) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ElementMetrics row = null;");
        _builder.newLine();
        _builder.append("\t");
        Functions.Function1 _function = m -> {
            GenMeasurable _target = m.getTarget();
            String _name = ((GenNotationElementTarget)_target).getElement().getEcoreClass().getName();
            return Objects.equals(_name, "Diagram");
        };
        Iterable diagramMetrics = IterableExtensions.filter(this._metrics_qvto.getNotationMetrics(it.getMetrics()), (Functions.Function1)_function);
        _builder.newLineIfNotEmpty();
        boolean _notEmpty = this._common_qvto.notEmpty(diagramMetrics);
        if (_notEmpty) {
            _builder.append("\t");
            _builder.append("row = new ElementMetrics(diagram, formatViewName(diagram), new Metric[] {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            boolean _hasElements = false;
            for (GenMetricRule m2 : diagramMetrics) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)",\n", "\t\t");
                }
                CharSequence _metricResult = this.metricResult(m2, "diagram", false);
                _builder.append((Object)_metricResult, "\t\t");
            }
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("});");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("row.diagramElementID = diagram.eResource().getURIFragment(diagram);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("metricsList.add(row);");
            _builder.newLine();
        }
        _builder.append("\t");
        Functions.Function1 _function_1 = m_1 -> {
            GenMeasurable _target = m_1.getTarget();
            return ((GenNotationElementTarget)_target).getElement();
        };
        Set notationTargets = IterableExtensions.toSet((Iterable)IterableExtensions.map(this._metrics_qvto.getNotationMetrics(it.getMetrics()), (Functions.Function1)_function_1));
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("for (java.util.Iterator it<org.eclipse.emf.ecore.EObjectzz> = diagram.eAllContents(); it.hasNext(); ) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("Object next = it.next();");
        _builder.newLine();
        Iterable _filter = Iterables.filter((Iterable)notationTargets, GenClass.class);
        for (GenClass nt : _filter) {
            _builder.append("\t\t");
            _builder.append("if (");
            CharSequence _IsInstance = this.xptMetaModel.IsInstance(nt, "next");
            _builder.append((Object)_IsInstance, "\t\t");
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            String _lowerCase = nt.getEcoreClass().getName().toLowerCase();
            String _plus = "_" + _lowerCase;
            CharSequence _DeclareAndAssign = this.xptMetaModel.DeclareAndAssign((GenClassifier)nt, _plus, "next", true);
            _builder.append((Object)_DeclareAndAssign, "\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("row = new ElementMetrics(");
            String _lowerCase_1 = nt.getEcoreClass().getName().toLowerCase();
            String _plus_1 = "_" + _lowerCase_1;
            _builder.append(_plus_1, "\t\t\t");
            _builder.append(", formatViewName(");
            String _lowerCase_2 = nt.getEcoreClass().getName().toLowerCase();
            String _plus_2 = "_" + _lowerCase_2;
            _builder.append(_plus_2, "\t\t\t");
            _builder.append("), new Metric[] {");
            _builder.newLineIfNotEmpty();
            Functions.Function1 _function_2 = m_1 -> {
                GenMeasurable _target = m_1.getTarget();
                GenClass _element = ((GenNotationElementTarget)_target).getElement();
                return Objects.equals(_element, nt);
            };
            Iterable _filter_1 = IterableExtensions.filter(this._metrics_qvto.getNotationMetrics(it.getMetrics()), (Functions.Function1)_function_2);
            boolean _hasElements_1 = false;
            for (GenMetricRule m_12 : _filter_1) {
                if (!_hasElements_1) {
                    _hasElements_1 = true;
                } else {
                    _builder.appendImmediate((Object)",", "\t\t\t");
                }
                _builder.append("\t\t");
                _builder.append("\t");
                String _lowerCase_3 = nt.getEcoreClass().getName().toLowerCase();
                String _plus_3 = "_" + _lowerCase_3;
                CharSequence _metricResult_1 = this.metricResult(m_12, _plus_3, false);
                _builder.append((Object)_metricResult_1, "\t\t\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("});");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("row.diagramElementID = ");
            String _lowerCase_4 = nt.getEcoreClass().getName().toLowerCase();
            String _plus_4 = "_" + _lowerCase_4;
            _builder.append(_plus_4, "\t\t\t");
            _builder.append(".eResource().getURIFragment(");
            String _lowerCase_5 = nt.getEcoreClass().getName().toLowerCase();
            String _plus_5 = "_" + _lowerCase_5;
            _builder.append(_plus_5, "\t\t\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("metricsList.add(row);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence calcDiagramMetricsMethod(GenEditorGenerator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("static void calculateDiagramElementMetrics(org.eclipse.gmf.runtime.notation.Diagram diagram, java.util.List<ElementMetrics> metricsList) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("org.eclipse.emf.ecore.EObject next = diagram;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("java.util.Iterator/*<EObject>*/ it = diagram.eAllContents();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("do {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (next instanceof org.eclipse.gmf.runtime.notation.View) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("org.eclipse.gmf.runtime.notation.View view = (org.eclipse.gmf.runtime.notation.View) next;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("final int vid = ");
        CharSequence _visualIDMethodCall = this.xptVisualIDRegistry.getVisualIDMethodCall(it.getDiagram());
        _builder.append((Object)_visualIDMethodCall, "\t\t\t");
        _builder.append("(view);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("java.util.ArrayList/*<Metric>*/ res = new java.util.ArrayList/*<Metric>*/(5);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("switch (vid) {");
        _builder.newLine();
        Functions.Function1 _function = m -> {
            GenMeasurable _target = m.getTarget();
            return ((GenDiagramElementTarget)_target).getElement();
        };
        Iterable _flatten = Iterables.concat((Iterable)IterableExtensions.map(this._metrics_qvto.getDiagramMetrics(it.getMetrics()), (Functions.Function1)_function));
        for (GenCommonBase cb : _flatten) {
            _builder.append("\t\t\t");
            _builder.append("case ");
            CharSequence _visualID = VisualIDRegistry.visualID(cb);
            _builder.append((Object)_visualID, "\t\t\t");
            _builder.append(" : {");
            _builder.newLineIfNotEmpty();
            Functions.Function1 _function_1 = mm -> {
                GenMeasurable _target = mm.getTarget();
                return ((GenDiagramElementTarget)_target).getElement().contains((Object)cb);
            };
            Iterable _filter = IterableExtensions.filter(this._metrics_qvto.getDiagramMetrics(it.getMetrics()), (Functions.Function1)_function_1);
            for (GenMetricRule m2 : _filter) {
                _builder.append("\t\t\t");
                _builder.append("res.add(");
                CharSequence _metricResult = this.metricResult(m2, "view", true);
                _builder.append((Object)_metricResult, "\t\t\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t\t\t");
            _builder.append("break;");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if (!res.isEmpty()) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("ElementMetrics row = new ElementMetrics(view, formatViewName(view), (Metric[]) res.toArray(new Metric[res.size()]));");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("row.diagramElementID = view.eResource().getURIFragment(view);");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("metricsList.add(row);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("next = it.hasNext() ? (org.eclipse.emf.ecore.EObject) it.next() : null;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("} while (next != null);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence calcDomainMetricsMethod(GenEditorGenerator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment("NOTE: metrics are being collected for domain elements contained in the semantic element associated with diagram view, actual diagram content (elements present there) is not taken into account.");
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("static void calculateSemanticElementMetrics(org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart diagramEditPart, java.util.List<ElementMetrics> metricsList) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("org.eclipse.gmf.runtime.notation.Diagram diagram = diagramEditPart.getDiagramView();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("org.eclipse.emf.ecore.EObject next = diagram.getElement();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("java.util.Iterator/*<EObject>*/ it = next != null ? next.eAllContents() : java.util.Collections.EMPTY_LIST.iterator();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("java.util.HashMap<org.eclipse.emf.ecore.EObject, ElementMetrics> target2row = new java.util.HashMap<org.eclipse.emf.ecore.EObject, ElementMetrics>();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("while (next != null) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("java.util.ArrayList<Metric> res = new java.util.ArrayList<");
        String _diamondOp = this._codeStyle.diamondOp((GenCommonBase)it.getDiagram(), "Metric");
        _builder.append(_diamondOp, "\t\t");
        _builder.append(">(5);");
        _builder.newLineIfNotEmpty();
        Functions.Function1 _function = m -> m.getTarget();
        Functions.Function1 _function_1 = t -> t.getElement();
        Iterable _map = IterableExtensions.map((Iterable)Iterables.filter((Iterable)ListExtensions.map((List)it.getMetrics().getMetrics(), (Functions.Function1)_function), GenDomainElementTarget.class), (Functions.Function1)_function_1);
        for (GenClass e : _map) {
            _builder.append("\t\t");
            _builder.append("if (");
            CharSequence _MetaClass = this.xptMetaModel.MetaClass((GenClassifier)e);
            _builder.append((Object)_MetaClass, "\t\t");
            _builder.append(".isInstance(next)) {");
            _builder.newLineIfNotEmpty();
            Functions.Function1 _function_2 = m -> {
                GenClassifier _context = m.getTarget().getContext();
                return Objects.equals(_context, e);
            };
            Iterable _filter = IterableExtensions.filter((Iterable)it.getMetrics().getMetrics(), (Functions.Function1)_function_2);
            for (GenMetricRule m2 : _filter) {
                _builder.append("\t\t");
                _builder.append("res.add(");
                CharSequence _metricResult = this.metricResult(m2, "next", true);
                _builder.append((Object)_metricResult, "\t\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t\t");
        _builder.append("if (!res.isEmpty()) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("ElementMetrics row = new ElementMetrics(next, formatElementName(next), (Metric[]) res.toArray(new Metric[res.size()]));");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("metricsList.add(row);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("target2row.put(next, row);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("next = it.hasNext() ? (org.eclipse.emf.ecore.EObject) it.next() : null;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (!target2row.isEmpty()) { // list was modified, need to process only semantic metrics");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// bind semantic elements to notation");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _qualifiedClassName = this.xptDiagramEditorUtil.qualifiedClassName(it.getDiagram());
        _builder.append((Object)_qualifiedClassName, "\t\t");
        _builder.append(".LazyElement2ViewMap element2ViewMap = new ");
        CharSequence _qualifiedClassName_1 = this.xptDiagramEditorUtil.qualifiedClassName(it.getDiagram());
        _builder.append((Object)_qualifiedClassName_1, "\t\t");
        _builder.append(".LazyElement2ViewMap(diagram, target2row.keySet());");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("for (java.util.Iterator it2 = target2row.entrySet().iterator(); it2.hasNext();) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("java.util.Map.Entry entry = (java.util.Map.Entry) it2.next();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("org.eclipse.emf.ecore.EObject semanticElement = (org.eclipse.emf.ecore.EObject) entry.getKey();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("org.eclipse.gmf.runtime.notation.View targetView = ");
        CharSequence _qualifiedClassName_2 = this.xptDiagramEditorUtil.qualifiedClassName(it.getDiagram());
        _builder.append((Object)_qualifiedClassName_2, "\t\t\t");
        _builder.append(".findView(diagramEditPart, semanticElement, element2ViewMap);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("ElementMetrics elementMetrics = (ElementMetrics) entry.getValue();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("elementMetrics.diagramElementID = targetView.eResource().getURIFragment(targetView);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence formatNotationElementNameMethod(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("private static String formatViewName(org.eclipse.gmf.runtime.notation.View viewTarget) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("StringBuffer notationQNameBuf = new StringBuffer();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("notationQNameBuf.append(formatElementName(viewTarget));");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (viewTarget.getElement() != null) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("notationQNameBuf.append(\"->\").append(formatElementName(viewTarget.getElement()));\t");
        CharSequence _nonNLS = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("int visualID = ");
        CharSequence _visualIDMethodCall = this.xptVisualIDRegistry.getVisualIDMethodCall(it);
        _builder.append((Object)_visualIDMethodCall, "\t");
        _builder.append("(viewTarget);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("notationQNameBuf.append('[').append(visualID < 0 ? Integer.toString(System.identityHashCode(viewTarget)) : Integer.toString(visualID)).append(']');");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return notationQNameBuf.toString();");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence formatSemanticElementNameMethod(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("private static String formatElementName(org.eclipse.emf.ecore.EObject object) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil.getQualifiedName(object, true);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence metricCalcMethod(GenMetricRule it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public static");
        _builder.append(" Double ");
        String _calcMethodName = this._metrics_qvto.calcMethodName(it);
        _builder.append(_calcMethodName);
        _builder.append("(");
        CharSequence _calcMethodArgs = this.calcMethodArgs(it.getTarget(), it);
        _builder.append((Object)_calcMethodArgs);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _calcMethodBody = this.calcMethodBody(it.getRule().getProvider(), it);
        _builder.append((Object)_calcMethodBody, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _calcMethodArgs(GenMeasurable it, GenMetricRule metric) {
        StringConcatenation _builder = new StringConcatenation();
        this._common_qvto.ERROR("Unrecognized metric target: " + String.valueOf(it));
        return _builder;
    }

    protected CharSequence _calcMethodArgs(GenDomainElementTarget it, GenMetricRule metric) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName((GenClassifier)it.getElement());
        _builder.append((Object)_QualifiedClassName);
        _builder.append(" target");
        return _builder;
    }

    protected CharSequence _calcMethodArgs(GenDiagramElementTarget it, GenMetricRule metric) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("org.eclipse.gmf.runtime.notation.");
        boolean _allOfType = this.allOfType(it, GenNode.class);
        if (_allOfType) {
            _builder.append("Node");
        } else {
            boolean _allOfType_1 = this.allOfType(it, GenLink.class);
            if (_allOfType_1) {
                _builder.append("Edge");
            } else {
                boolean _allOfType_2 = this.allOfType(it, GenDiagram.class);
                if (_allOfType_2) {
                    _builder.append("Diagram");
                } else {
                    _builder.append("View");
                }
            }
        }
        _builder.append(" target");
        return _builder;
    }

    public boolean allOfType(GenDiagramElementTarget it, Class<? extends GenCommonBase> type) {
        Functions.Function1 _function = e -> this._common_qvto.oclIsKindOf(e, type);
        return IterableExtensions.forall((Iterable)it.getElement(), (Functions.Function1)_function);
    }

    protected CharSequence _calcMethodArgs(GenNotationElementTarget it, GenMetricRule metric) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName((GenClassifier)it.getElement());
        _builder.append((Object)_QualifiedClassName);
        _builder.append(" target");
        return _builder;
    }

    protected CharSequence _calcMethodBody(GenExpressionProviderBase it, GenMetricRule metric) {
        StringConcatenation _builder = new StringConcatenation();
        this._common_qvto.ERROR("No idea how to calculate metric's value for " + String.valueOf(it));
        return _builder;
    }

    protected CharSequence _calcMethodBody(GenExpressionInterpreter it, GenMetricRule metric) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Object val = ");
        CharSequence _expression = this.xptGetExpression.getExpression((GenExpressionProviderBase)it, metric.getRule(), metric.getTarget().getContext());
        _builder.append((Object)_expression);
        _builder.append(".evaluate(target);");
        _builder.newLineIfNotEmpty();
        _builder.append("if (val instanceof Number) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return val.getClass() == Double.class ? (Double) val : new Double(((Number) val).doubleValue());");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.append("return null;");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _calcMethodBody(GenJavaExpressionProvider it, GenMetricRule metric) {
        StringConcatenation _builder = new StringConcatenation();
        if (it.isInjectExpressionBody() && !StringExtensions.isNullOrEmpty((String)metric.getRule().getBody())) {
            String _body = metric.getRule().getBody();
            _builder.append(_body);
            _builder.newLineIfNotEmpty();
        } else if (it.isThrowException() || it.isInjectExpressionBody() && StringExtensions.isNullOrEmpty((String)metric.getRule().getBody())) {
            _builder.append("// TODO: implement this method");
            _builder.newLine();
            _builder.append("// Ensure that you remove @generated or mark it @generated NOT");
            _builder.newLine();
            _builder.append("throw new java.lang.UnsupportedOperationException(\"No user java implementation provided\"); ");
            CharSequence _nonNLS = this._common.nonNLS(1);
            _builder.append((Object)_nonNLS);
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("return new Double(Double.NaN);");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence keysAndToolTipsMethods(GenMetricContainer it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("private static String[] getMetricKeys() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return new String[] {");
        _builder.newLine();
        _builder.append("\t\t");
        EList _metrics = it.getMetrics();
        boolean _hasElements = false;
        for (GenMetricRule m : _metrics) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",\n", "\t\t");
            }
            String _stringLiteral = this.toStringLiteral(m.getKey());
            _builder.append(_stringLiteral, "\t\t");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("};");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_1);
        _builder.newLineIfNotEmpty();
        _builder.append("private static String[] getMetricToolTips() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return new String[] {");
        _builder.newLine();
        _builder.append("\t\t");
        EList _metrics_1 = it.getMetrics();
        boolean _hasElements_1 = false;
        for (GenMetricRule m_1 : _metrics_1) {
            if (!_hasElements_1) {
                _hasElements_1 = true;
            } else {
                _builder.appendImmediate((Object)",\n", "\t\t");
            }
            CharSequence _singleMetricTooltip = this.singleMetricTooltip(m_1);
            _builder.append((Object)_singleMetricTooltip, "\t\t");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("};");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence singleMetricTooltip(GenMetricRule m) {
        Double _highLimit;
        boolean _tripleNotEquals_2;
        Double _lowLimit;
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        String _stringLiteral = this.toStringLiteral(this.nameOrKey(m));
        _builder.append(_stringLiteral);
        String _description = m.getDescription();
        boolean bl = _tripleNotEquals = _description != null;
        if (_tripleNotEquals) {
            _builder.append(" + '\\n' + ");
            String _stringLiteral_1 = this.toStringLiteral(m.getDescription());
            _builder.append(_stringLiteral_1);
            _builder.append(" + '\\n'");
        }
        boolean bl2 = _tripleNotEquals_1 = (_lowLimit = m.getLowLimit()) != null;
        if (_tripleNotEquals_1) {
            _builder.append(" + ");
            Double _lowLimit_1 = m.getLowLimit();
            String _plus = "low: " + String.valueOf(_lowLimit_1);
            String _stringLiteral_2 = this.toStringLiteral(_plus);
            _builder.append(_stringLiteral_2);
        }
        boolean bl3 = _tripleNotEquals_2 = (_highLimit = m.getHighLimit()) != null;
        if (_tripleNotEquals_2) {
            _builder.append(" + ");
            Double _highLimit_1 = m.getHighLimit();
            String _plus_1 = "high: " + String.valueOf(_highLimit_1);
            String _stringLiteral_3 = this.toStringLiteral(_plus_1);
            _builder.append(_stringLiteral_3);
        }
        return _builder;
    }

    protected String nameOrKey(GenMetricRule metric) {
        String _xifexpression = null;
        String _name = metric.getName();
        boolean _tripleEquals = _name == null;
        _xifexpression = _tripleEquals ? metric.getKey() : metric.getName();
        return _xifexpression;
    }

    protected CharSequence doubleOrNull(Double d) {
        StringConcatenation _builder = new StringConcatenation();
        if (d == null) {
            _builder.append("null");
        } else {
            _builder.append("new Double(");
            _builder.append((Object)d);
            _builder.append(")");
        }
        return _builder;
    }

    protected CharSequence castIfNeeded(GenMetricRule it, String targetAccessor, boolean isJustEObject) {
        StringConcatenation _builder = new StringConcatenation();
        if (isJustEObject && this._common_qvto.oclIsKindOf(it.getTarget().getContext(), GenClass.class)) {
            GenClassifier _context = it.getTarget().getContext();
            CharSequence _CastEObject = this.xptMetaModel.CastEObject((GenClass)_context, targetAccessor);
            _builder.append((Object)_CastEObject);
        } else {
            _builder.append(targetAccessor);
        }
        return _builder;
    }

    public String toStringLiteral(String key) {
        return Conversions.toStringLiteral((String)key);
    }

    public CharSequence metricResult(GenMetricRule it, String targetAccessor, boolean isJustEObject) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("new Metric(");
        String _stringLiteral = this.toStringLiteral(it.getKey());
        _builder.append(_stringLiteral);
        _builder.append(", ");
        String _calcMethodName = this._metrics_qvto.calcMethodName(it);
        _builder.append(_calcMethodName);
        _builder.append("(");
        CharSequence _castIfNeeded = this.castIfNeeded(it, targetAccessor, isJustEObject);
        _builder.append((Object)_castIfNeeded);
        _builder.append("), ");
        CharSequence _doubleOrNull = this.doubleOrNull(it.getLowLimit());
        _builder.append((Object)_doubleOrNull);
        _builder.append(", ");
        CharSequence _doubleOrNull_1 = this.doubleOrNull(it.getHighLimit());
        _builder.append((Object)_doubleOrNull_1);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence calcMethodArgs(GenMeasurable it, GenMetricRule metric) {
        if (it instanceof GenDiagramElementTarget) {
            return this._calcMethodArgs((GenDiagramElementTarget)it, metric);
        }
        if (it instanceof GenDomainElementTarget) {
            return this._calcMethodArgs((GenDomainElementTarget)it, metric);
        }
        if (it instanceof GenNotationElementTarget) {
            return this._calcMethodArgs((GenNotationElementTarget)it, metric);
        }
        if (it != null) {
            return this._calcMethodArgs(it, metric);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, metric).toString());
    }

    public CharSequence calcMethodBody(GenExpressionProviderBase it, GenMetricRule metric) {
        if (it instanceof GenExpressionInterpreter) {
            return this._calcMethodBody((GenExpressionInterpreter)it, metric);
        }
        if (it instanceof GenJavaExpressionProvider) {
            return this._calcMethodBody((GenJavaExpressionProvider)it, metric);
        }
        if (it != null) {
            return this._calcMethodBody(it, metric);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, metric).toString());
    }
}

