/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.util;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContextInformationValidator;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.util.DoNothingCompletionProposal;
import org.eclipse.papyrus.infra.widgets.util.IPapyrusConverter;

public class ReferenceContentAssistProcessor
implements IContentAssistProcessor {
    private int MAX_ELEMENTS_TO_DISPLAY = 15;
    public static final String MORE_ELEMENTS = "...";
    private String lastError = null;
    private IContextInformationValidator contextInfoValidator;
    private IPapyrusConverter parser;
    private boolean isMany;

    public ReferenceContentAssistProcessor(IPapyrusConverter parser, boolean isMany) {
        this.parser = parser;
        this.isMany = isMany;
        this.contextInfoValidator = new ContextInformationValidator((IContentAssistProcessor)this);
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer textViewer, int documentOffset) {
        IDocument document = textViewer.getDocument();
        int currOffset = documentOffset - 1;
        String currentStr = textViewer.getTextWidget().getText();
        Map parse = this.parser.getSubStringsWithTheirPositions(currentStr);
        String stringToComplete = null;
        for (Map.Entry current : parse.entrySet()) {
            int start = (Integer)((List)current.getKey()).get(0);
            int end = (Integer)((List)current.getKey()).get(1);
            if (currOffset < start || currOffset >= end) continue;
            stringToComplete = (String)current.getValue();
            break;
        }
        if (stringToComplete == null) {
            stringToComplete = "";
        }
        try {
            char currChar;
            Object currWord = "";
            while (currOffset > 0 && !Character.isWhitespace(currChar = document.getChar(currOffset))) {
                currWord = currChar + (String)currWord;
                --currOffset;
            }
            currWord = textViewer.getTextWidget().getText();
            List<String> suggestions = this.suggest(stringToComplete);
            ICompletionProposal[] proposals = null;
            if (suggestions.size() > 0) {
                proposals = this.buildProposals(suggestions, stringToComplete, documentOffset - stringToComplete.length());
                this.lastError = null;
            } else {
                this.lastError = "There is no suggestion for you.";
            }
            return proposals;
        }
        catch (BadLocationException e) {
            Activator.log.error((Throwable)e);
            this.lastError = e.getMessage();
            return null;
        }
    }

    public List<String> suggest(String word) {
        LinkedList<String> suggestions = new LinkedList<String>();
        if (word == null || word.length() == 0) {
            suggestions.addAll(this.buildSuggest(word));
        } else {
            List val = this.parser.splitFullStringToSubElementString(word);
            if (val.size() == 1) {
                suggestions.addAll(this.buildSuggest((String)val.get(0)));
            } else {
                String subWord = (String)val.get(val.size() - 1);
                suggestions.addAll(this.buildSuggest(subWord));
            }
        }
        return suggestions;
    }

    protected List<String> buildSuggest(String word) {
        boolean isEmpty;
        LinkedList<String> suggestions = new LinkedList<String>();
        boolean bl = isEmpty = word == null || word.length() == 0;
        if (!isEmpty) {
            boolean escapedName = word.startsWith("'");
            if (escapedName) {
                word = word.substring(1);
            }
            List elements = this.parser.getMatchingElements(word);
            int i = 0;
            while (i < elements.size() && i < this.MAX_ELEMENTS_TO_DISPLAY) {
                Object current = elements.get(i);
                String name = this.parser.canonicalToDisplayValue(current, 0);
                if (!escapedName || name.contains(",")) {
                    suggestions.add(name);
                }
                ++i;
            }
            if (elements.size() > this.MAX_ELEMENTS_TO_DISPLAY) {
                suggestions.add(0, MORE_ELEMENTS);
            }
        } else {
            suggestions.add(0, MORE_ELEMENTS);
        }
        suggestions.add(0, "<Undefined>");
        return suggestions;
    }

    private ICompletionProposal[] buildProposals(List<String> suggestions, String replacedWord, int offset) {
        ICompletionProposal[] proposals = new ICompletionProposal[suggestions.size()];
        int index = 0;
        for (String currSuggestion : suggestions) {
            if (MORE_ELEMENTS.equals(currSuggestion)) {
                proposals[index] = new DoNothingCompletionProposal("", 0, replacedWord.length() + offset, currSuggestion.length(), null, currSuggestion, null, null);
            } else if ("<Undefined>".equals(currSuggestion)) {
                proposals[index] = new CompletionProposal(currSuggestion, 0, replacedWord.length() + offset, currSuggestion.length());
            } else if (",".equals(currSuggestion)) {
                StringBuilder builder = new StringBuilder();
                builder.append(replacedWord);
                builder.append(currSuggestion);
                proposals[index] = new CompletionProposal(builder.toString(), offset, replacedWord.length(), builder.length(), null, currSuggestion, null, null);
            } else {
                String replacementString = this.parser.displayToEditValue(currSuggestion);
                proposals[index] = new CompletionProposal(replacementString, offset, replacedWord.length(), replacementString.length(), null, currSuggestion, null, null);
            }
            ++index;
        }
        return proposals;
    }

    public IContextInformation[] computeContextInformation(ITextViewer textViewer, int documentOffset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return this.lastError;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return this.contextInfoValidator;
    }
}

