/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.properties.ui.provider;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.papyrus.infra.properties.ui.provider.CompositeWidgetItemProvider;
import org.eclipse.papyrus.infra.properties.ui.provider.ElementItemProvider;
import org.eclipse.papyrus.infra.properties.ui.provider.LayoutItemProvider;
import org.eclipse.papyrus.infra.properties.ui.provider.PropertyEditorItemProvider;
import org.eclipse.papyrus.infra.properties.ui.provider.ReferenceAttributeItemProvider;
import org.eclipse.papyrus.infra.properties.ui.provider.StandardWidgetItemProvider;
import org.eclipse.papyrus.infra.properties.ui.provider.UnknownComponentItemProvider;
import org.eclipse.papyrus.infra.properties.ui.provider.ValueAttributeItemProvider;
import org.eclipse.papyrus.infra.properties.ui.util.UiAdapterFactory;

public class UiItemProviderAdapterFactory
extends UiAdapterFactory
implements ComposeableAdapterFactory,
IChangeNotifier,
IDisposable {
    protected ComposedAdapterFactory parentAdapterFactory;
    protected IChangeNotifier changeNotifier = new ChangeNotifier();
    protected Collection<Object> supportedTypes = new ArrayList<Object>();
    protected ElementItemProvider elementItemProvider;
    protected StandardWidgetItemProvider standardWidgetItemProvider;
    protected PropertyEditorItemProvider propertyEditorItemProvider;
    protected CompositeWidgetItemProvider compositeWidgetItemProvider;
    protected UnknownComponentItemProvider unknownComponentItemProvider;
    protected LayoutItemProvider layoutItemProvider;
    protected ValueAttributeItemProvider valueAttributeItemProvider;
    protected ReferenceAttributeItemProvider referenceAttributeItemProvider;

    public UiItemProviderAdapterFactory() {
        this.supportedTypes.add(IEditingDomainItemProvider.class);
        this.supportedTypes.add(IStructuredItemContentProvider.class);
        this.supportedTypes.add(ITreeItemContentProvider.class);
        this.supportedTypes.add(IItemLabelProvider.class);
        this.supportedTypes.add(IItemPropertySource.class);
    }

    public Adapter createElementAdapter() {
        if (this.elementItemProvider == null) {
            this.elementItemProvider = new ElementItemProvider((AdapterFactory)this);
        }
        return this.elementItemProvider;
    }

    public Adapter createStandardWidgetAdapter() {
        if (this.standardWidgetItemProvider == null) {
            this.standardWidgetItemProvider = new StandardWidgetItemProvider((AdapterFactory)this);
        }
        return this.standardWidgetItemProvider;
    }

    public Adapter createPropertyEditorAdapter() {
        if (this.propertyEditorItemProvider == null) {
            this.propertyEditorItemProvider = new PropertyEditorItemProvider((AdapterFactory)this);
        }
        return this.propertyEditorItemProvider;
    }

    public Adapter createCompositeWidgetAdapter() {
        if (this.compositeWidgetItemProvider == null) {
            this.compositeWidgetItemProvider = new CompositeWidgetItemProvider((AdapterFactory)this);
        }
        return this.compositeWidgetItemProvider;
    }

    public Adapter createUnknownComponentAdapter() {
        if (this.unknownComponentItemProvider == null) {
            this.unknownComponentItemProvider = new UnknownComponentItemProvider((AdapterFactory)this);
        }
        return this.unknownComponentItemProvider;
    }

    public Adapter createLayoutAdapter() {
        if (this.layoutItemProvider == null) {
            this.layoutItemProvider = new LayoutItemProvider((AdapterFactory)this);
        }
        return this.layoutItemProvider;
    }

    public Adapter createValueAttributeAdapter() {
        if (this.valueAttributeItemProvider == null) {
            this.valueAttributeItemProvider = new ValueAttributeItemProvider((AdapterFactory)this);
        }
        return this.valueAttributeItemProvider;
    }

    public Adapter createReferenceAttributeAdapter() {
        if (this.referenceAttributeItemProvider == null) {
            this.referenceAttributeItemProvider = new ReferenceAttributeItemProvider((AdapterFactory)this);
        }
        return this.referenceAttributeItemProvider;
    }

    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    public boolean isFactoryForType(Object type) {
        return this.supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, (Object)this);
    }

    public Object adapt(Object object, Object type) {
        if (this.isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class) || ((Class)type).isInstance(adapter)) {
                return adapter;
            }
        }
        return null;
    }

    public void addListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    public void removeListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    public void fireNotifyChanged(Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);
        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    public void dispose() {
        if (this.elementItemProvider != null) {
            this.elementItemProvider.dispose();
        }
        if (this.standardWidgetItemProvider != null) {
            this.standardWidgetItemProvider.dispose();
        }
        if (this.propertyEditorItemProvider != null) {
            this.propertyEditorItemProvider.dispose();
        }
        if (this.unknownComponentItemProvider != null) {
            this.unknownComponentItemProvider.dispose();
        }
        if (this.layoutItemProvider != null) {
            this.layoutItemProvider.dispose();
        }
        if (this.valueAttributeItemProvider != null) {
            this.valueAttributeItemProvider.dispose();
        }
        if (this.referenceAttributeItemProvider != null) {
            this.referenceAttributeItemProvider.dispose();
        }
        if (this.compositeWidgetItemProvider != null) {
            this.compositeWidgetItemProvider.dispose();
        }
    }
}

