/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.utils;

public class PasteHelper {
    public static final String DEFAULT_ROW_SEPARATOR = "\n";
    public static final String DEFAULT_COLUMN_SEPARATOR = "\t";
    public static final String DEFAULT_MULTI_VALUE_SEPARATOR = ",";
    private final String rowSeparator;
    private final String columnSeparator;
    private final String multiValueSeparator;

    public PasteHelper() {
        this(DEFAULT_COLUMN_SEPARATOR, DEFAULT_ROW_SEPARATOR, DEFAULT_MULTI_VALUE_SEPARATOR);
    }

    public PasteHelper(String columnSeparator, String rowSeparator, String multiValueSeparator) {
        this.columnSeparator = columnSeparator;
        this.rowSeparator = rowSeparator;
        this.multiValueSeparator = multiValueSeparator;
    }

    public String[] getCellsAsStringFromAxis(String axisAsString) {
        return axisAsString.split(this.columnSeparator);
    }

    public final String[] getRows(String fullContents) {
        String[] rows = fullContents.split(this.rowSeparator);
        return rows;
    }

    public final String[] getColumns(String fullContents) {
        String[] rows = fullContents.split(this.rowSeparator);
        if (rows.length > 0) {
            int nbColumn = rows[0].split(this.columnSeparator).length;
            String[] columns = new String[nbColumn];
            int columnIndex = 0;
            while (columnIndex < nbColumn) {
                columns[columnIndex] = "";
                ++columnIndex;
            }
            int rowIndex = 0;
            while (rowIndex < rows.length) {
                String row = rows[rowIndex];
                String[] currentColumns = row.split(this.columnSeparator);
                int columnIndex2 = 0;
                while (columnIndex2 < nbColumn) {
                    if (currentColumns.length != 0) {
                        int n = columnIndex2;
                        columns[n] = String.valueOf(columns[n]) + currentColumns[columnIndex2];
                    } else {
                        int n = columnIndex2;
                        columns[n] = String.valueOf(columns[n]);
                    }
                    if (rowIndex < rows.length + 1) {
                        int n = columnIndex2;
                        columns[n] = String.valueOf(columns[n]) + this.columnSeparator;
                    } else {
                        int n = columnIndex2;
                        columns[n] = String.valueOf(columns[n]) + this.rowSeparator;
                    }
                    ++columnIndex2;
                }
                ++rowIndex;
            }
            return columns;
        }
        return null;
    }

    public String getRowSeparator() {
        return this.rowSeparator;
    }

    public String getColumnSeparator() {
        return this.columnSeparator;
    }

    public String getMultiValueSeparator() {
        return this.multiValueSeparator;
    }
}

