/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.internationalization.resource;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.emf.gmf.util.GMFUnsafe;
import org.eclipse.papyrus.infra.internationalization.Activator;
import org.eclipse.papyrus.infra.internationalization.InternationalizationEntry;
import org.eclipse.papyrus.infra.internationalization.InternationalizationFactory;
import org.eclipse.papyrus.infra.internationalization.InternationalizationLibrary;
import org.eclipse.papyrus.infra.internationalization.common.utils.LocaleNameResolver;
import org.eclipse.papyrus.infra.internationalization.utils.InternationalizationKeyResolver;
import org.eclipse.papyrus.infra.internationalization.utils.PropertiesFilesUtils;
import org.eclipse.papyrus.infra.internationalization.utils.ResourceBundleAndURI;

public class InternationalizationResource
extends XMIResourceImpl {
    public InternationalizationResource(URI uri) {
        super(uri);
    }

    public void load(Map<?, ?> options) throws IOException {
        ResourceBundleAndURI resourceBundleAndURI;
        InternationalizationKeyResolver keyResolver = this.loadKeyResolverOption(options, this.defaultLoadOptions);
        URI initialURI = this.loadURIOption(options, this.defaultLoadOptions);
        Object saveOptionLocale = options != null && options.containsKey("internationalizationLocale") ? options.get("internationalizationLocale") : (this.defaultLoadOptions != null ? this.defaultLoadOptions.get("internationalizationLocale") : null);
        Locale locale = null;
        if (saveOptionLocale != null) {
            if (saveOptionLocale instanceof Locale) {
                locale = saveOptionLocale;
            } else if (saveOptionLocale instanceof String) {
                locale = LocaleNameResolver.getLocaleFromString((String)saveOptionLocale);
            }
        }
        if ((resourceBundleAndURI = PropertiesFilesUtils.getResourceBundle(initialURI.trimFileExtension().appendFileExtension("properties"), locale)) != null && resourceBundleAndURI.getResourceBundle() != null) {
            InternationalizationLibrary library = InternationalizationFactory.eINSTANCE.createInternationalizationLibrary();
            Enumeration<String> keys = resourceBundleAndURI.getResourceBundle().getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                InternationalizationEntry entry = keyResolver.createInternationalizationEntryByKey(key, this.getResourceSet(), initialURI);
                entry.setValue(resourceBundleAndURI.getResourceBundle().getString(key));
                library.getEntries().add((Object)entry);
            }
            this.defaultSaveOptions.put("resourceContent", library);
        }
    }

    public void save(Map<?, ?> options) throws IOException {
        Object library;
        InternationalizationKeyResolver keyResolver = this.loadKeyResolverOption(options, this.defaultSaveOptions);
        Object saveOptionDeletedObjects = options != null && options.containsKey("internationalizationDeletedObjects") ? options.get("internationalizationDeletedObjects") : (this.defaultSaveOptions != null ? this.defaultSaveOptions.get("internationalizationDeletedObjects") : null);
        Set deletedObjects = null;
        if (saveOptionDeletedObjects != null && saveOptionDeletedObjects instanceof Set) {
            deletedObjects = saveOptionDeletedObjects;
        }
        Object saveOptionSort = options != null && options.containsKey("internationalizationSort") ? options.get("internationalizationSort") : (this.defaultSaveOptions != null ? this.defaultSaveOptions.get("internationalizationSort") : null);
        boolean sort = false;
        if (saveOptionSort != null && saveOptionSort instanceof Boolean) {
            sort = saveOptionSort;
        }
        SortedProperties properties = new SortedProperties(sort);
        Object v0 = options != null && options.containsKey("resourceContent") ? options.get("resourceContent") : (library = this.defaultSaveOptions != null ? this.defaultSaveOptions.get("resourceContent") : null);
        if (library instanceof InternationalizationLibrary) {
            for (InternationalizationEntry entry : ((InternationalizationLibrary)library).getEntries()) {
                if (deletedObjects != null && deletedObjects.contains(entry.getKey()) || entry.getValue().isEmpty()) continue;
                if (keyResolver != null) {
                    properties.setProperty(keyResolver.getKey(entry), entry.getValue());
                    continue;
                }
                properties.setProperty(entry.getKey().toString(), entry.getValue());
            }
            ExtensibleURIConverterImpl uriConverter = new ExtensibleURIConverterImpl();
            properties.store(uriConverter.createOutputStream(this.getURI()), null);
        }
        this.setModified(false);
    }

    protected void doUnload() {
        Object library;
        InternationalizationKeyResolver keyResolver;
        TreeIterator allContents = this.getAllProperContents(this.unloadingContents);
        if (!this.getContents().isEmpty()) {
            Object needUnsafe;
            Object v0 = needUnsafe = this.defaultLoadOptions != null ? this.defaultLoadOptions.get("unsafeAddCommand") : null;
            if (needUnsafe instanceof Boolean && ((Boolean)needUnsafe).booleanValue()) {
                try {
                    GMFUnsafe.write((TransactionalEditingDomain)((ModelSet)this.getResourceSet()).getTransactionalEditingDomain(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            InternationalizationResource.this.getContents().clear();
                        }
                    });
                }
                catch (InterruptedException | RollbackException e) {
                    Activator.log.error(e);
                }
            } else {
                this.getContents().clear();
            }
        }
        if ((keyResolver = this.loadKeyResolverOption(null, this.defaultLoadOptions)) != null) {
            keyResolver.dispose();
        }
        Object v1 = library = this.defaultSaveOptions != null ? this.defaultSaveOptions.get("resourceContent") : null;
        if (library != null) {
            library = null;
        }
        this.getErrors().clear();
        this.getWarnings().clear();
        while (allContents.hasNext()) {
            this.unloaded((InternalEObject)allContents.next());
        }
        if (this.idToEObjectMap != null) {
            this.idToEObjectMap.clear();
        }
        if (this.eObjectToIDMap != null) {
            this.eObjectToIDMap.clear();
        }
        if (this.eObjectToExtensionMap != null) {
            this.eObjectToExtensionMap.clear();
        }
    }

    protected InternationalizationKeyResolver loadKeyResolverOption(Map<?, ?> options, Map<?, ?> defaultOptions) {
        Object saveOptionKeyResolver = options != null && options.containsKey("internationalizationKeyResolver") ? options.get("internationalizationKeyResolver") : (defaultOptions != null ? defaultOptions.get("internationalizationKeyResolver") : null);
        InternationalizationKeyResolver keyResolver = null;
        if (saveOptionKeyResolver != null && saveOptionKeyResolver instanceof InternationalizationKeyResolver) {
            keyResolver = saveOptionKeyResolver;
        } else {
            Activator.log.error("The 'keyResolver' option for the internationalization resource must be set.", null);
        }
        return keyResolver;
    }

    protected URI loadURIOption(Map<?, ?> options, Map<?, ?> defaultOptions) {
        Object saveOptionURI = options != null && options.containsKey("internationalizationURI") ? options.get("internationalizationURI") : (defaultOptions != null ? defaultOptions.get("internationalizationURI") : null);
        URI initialURI = null;
        if (saveOptionURI != null && saveOptionURI instanceof URI) {
            initialURI = saveOptionURI;
        } else {
            Activator.log.error("The initial 'URI' option for the internationalization resource must be set.", null);
        }
        return initialURI;
    }

    private class SortedProperties
    extends Properties {
        private static final long serialVersionUID = 1L;
        private boolean sort = false;

        public SortedProperties(boolean sort) {
            this.sort = sort;
        }

        @Override
        public Enumeration keys() {
            Enumeration<Object> keysEnum = super.keys();
            if (this.sort) {
                Vector<String> keyList = new Vector<String>();
                while (keysEnum.hasMoreElements()) {
                    keyList.add((String)keysEnum.nextElement());
                }
                Collections.sort(keyList);
                keysEnum = keyList.elements();
            }
            return keysEnum;
        }
    }
}

