/*
 * Copyright (c) 2005, 2018 IBM Corporation, Embarcadero Technologies, CEA, and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 *
 * Contributors:
 *   IBM - initial API and implementation
 *   Kenn Hussey (Embarcadero Technologies) - 204200
 *   Kenn Hussey - 286329, 323181, 535301
 *   Kenn Hussey (CEA) - 327039, 351774, 418466, 454400, 451350, 485756
 *
 */
package org.eclipse.uml2.uml.cdo.internal.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.DiagnosticChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.resource.Resource;

import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.uml2.common.util.CacheAdapter;
import org.eclipse.uml2.common.util.DerivedUnionEObjectEList;

import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.DeployedArtifact;
import org.eclipse.uml2.uml.Deployment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.StringExpression;
import org.eclipse.uml2.uml.TemplateParameter;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.VisibilityKind;

import org.eclipse.uml2.uml.internal.operations.InstanceSpecificationOperations;
import org.eclipse.uml2.uml.internal.operations.PackageableElementOperations;
import org.eclipse.uml2.uml.internal.operations.ParameterableElementOperations;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Instance Specification</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.uml2.uml.cdo.internal.impl.InstanceSpecificationImpl#getOwner <em>Owner</em>}</li>
 *   <li>{@link org.eclipse.uml2.uml.cdo.internal.impl.InstanceSpecificationImpl#getTemplateParameter <em>Template Parameter</em>}</li>
 *   <li>{@link org.eclipse.uml2.uml.cdo.internal.impl.InstanceSpecificationImpl#getOwningTemplateParameter <em>Owning Template Parameter</em>}</li>
 *   <li>{@link org.eclipse.uml2.uml.cdo.internal.impl.InstanceSpecificationImpl#getVisibility <em>Visibility</em>}</li>
 *   <li>{@link org.eclipse.uml2.uml.cdo.internal.impl.InstanceSpecificationImpl#getOwnedElements <em>Owned Element</em>}</li>
 *   <li>{@link org.eclipse.uml2.uml.cdo.internal.impl.InstanceSpecificationImpl#getClassifiers <em>Classifier</em>}</li>
 *   <li>{@link org.eclipse.uml2.uml.cdo.internal.impl.InstanceSpecificationImpl#getSlots <em>Slot</em>}</li>
 *   <li>{@link org.eclipse.uml2.uml.cdo.internal.impl.InstanceSpecificationImpl#getSpecification <em>Specification</em>}</li>
 * </ul>
 *
 * @generated
 */
public class InstanceSpecificationImpl
		extends DeploymentTargetImpl
		implements InstanceSpecification {

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InstanceSpecificationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return UMLPackage.Literals.INSTANCE_SPECIFICATION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Element getOwner() {
		Element owner = basicGetOwner();
		return owner != null && owner.eIsProxy() ? (Element) eResolveProxy((InternalEObject) owner) : owner;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TemplateParameter getTemplateParameter() {
		return (TemplateParameter) eDynamicGet(UMLPackage.INSTANCE_SPECIFICATION__TEMPLATE_PARAMETER - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.PARAMETERABLE_ELEMENT__TEMPLATE_PARAMETER, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TemplateParameter basicGetTemplateParameter() {
		return (TemplateParameter) eDynamicGet(UMLPackage.INSTANCE_SPECIFICATION__TEMPLATE_PARAMETER - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.PARAMETERABLE_ELEMENT__TEMPLATE_PARAMETER, false, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetTemplateParameter(
			TemplateParameter newTemplateParameter, NotificationChain msgs) {
		msgs = eDynamicInverseAdd((InternalEObject) newTemplateParameter, UMLPackage.INSTANCE_SPECIFICATION__TEMPLATE_PARAMETER, msgs);
		Resource.Internal eInternalResource = eInternalResource();
		if (eInternalResource == null || !eInternalResource.isLoading()) {
			TemplateParameter owningTemplateParameter = basicGetOwningTemplateParameter();
			if (owningTemplateParameter != null && owningTemplateParameter != newTemplateParameter) {
				setOwningTemplateParameter(null);
			}
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTemplateParameter(TemplateParameter newTemplateParameter) {
		eDynamicSet(UMLPackage.INSTANCE_SPECIFICATION__TEMPLATE_PARAMETER - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.PARAMETERABLE_ELEMENT__TEMPLATE_PARAMETER, newTemplateParameter);
		Resource.Internal eInternalResource = eInternalResource();
		if (eInternalResource == null || !eInternalResource.isLoading()) {
			TemplateParameter owningTemplateParameter = basicGetOwningTemplateParameter();
			if (owningTemplateParameter != null && owningTemplateParameter != newTemplateParameter) {
				setOwningTemplateParameter(null);
			}
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TemplateParameter getOwningTemplateParameter() {
		return (TemplateParameter) eDynamicGet(UMLPackage.INSTANCE_SPECIFICATION__OWNING_TEMPLATE_PARAMETER - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.PARAMETERABLE_ELEMENT__OWNING_TEMPLATE_PARAMETER, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TemplateParameter basicGetOwningTemplateParameter() {
		return (TemplateParameter) eDynamicGet(UMLPackage.INSTANCE_SPECIFICATION__OWNING_TEMPLATE_PARAMETER - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.PARAMETERABLE_ELEMENT__OWNING_TEMPLATE_PARAMETER, false, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetOwningTemplateParameter(
			TemplateParameter newOwningTemplateParameter,
			NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject) newOwningTemplateParameter, UMLPackage.INSTANCE_SPECIFICATION__OWNING_TEMPLATE_PARAMETER, msgs);
		Resource.Internal eInternalResource = eInternalResource();
		if (eInternalResource == null || !eInternalResource.isLoading()) {
			if (newOwningTemplateParameter != null) {
				if (newOwningTemplateParameter != getTemplateParameter()) {
					setTemplateParameter(newOwningTemplateParameter);
				}
			}
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOwningTemplateParameter(
			TemplateParameter newOwningTemplateParameter) {
		eDynamicSet(UMLPackage.INSTANCE_SPECIFICATION__OWNING_TEMPLATE_PARAMETER - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.PARAMETERABLE_ELEMENT__OWNING_TEMPLATE_PARAMETER, newOwningTemplateParameter);
		Resource.Internal eInternalResource = eInternalResource();
		if (eInternalResource == null || !eInternalResource.isLoading()) {
			if (newOwningTemplateParameter != null) {
				if (newOwningTemplateParameter != getTemplateParameter()) {
					setTemplateParameter(newOwningTemplateParameter);
				}
			}
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public VisibilityKind getVisibility() {
		return (VisibilityKind) eDynamicGet(UMLPackage.INSTANCE_SPECIFICATION__VISIBILITY - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.NAMED_ELEMENT__VISIBILITY, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setVisibility(VisibilityKind newVisibility) {
		eDynamicSet(UMLPackage.INSTANCE_SPECIFICATION__VISIBILITY - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.NAMED_ELEMENT__VISIBILITY, newVisibility);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void unsetVisibility() {
		eDynamicUnset(UMLPackage.INSTANCE_SPECIFICATION__VISIBILITY - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.NAMED_ELEMENT__VISIBILITY);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isSetVisibility() {
		return eDynamicIsSet(UMLPackage.INSTANCE_SPECIFICATION__VISIBILITY - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.NAMED_ELEMENT__VISIBILITY);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Element> getOwnedElements() {
		CacheAdapter cache = getCacheAdapter();
		if (cache != null) {
			Resource eResource = eResource();
			@SuppressWarnings("unchecked")
			EList<Element> ownedElements = (EList<Element>) cache.get(eResource, this, UMLPackage.Literals.ELEMENT__OWNED_ELEMENT);
			if (ownedElements == null) {
				cache.put(eResource, this, UMLPackage.Literals.ELEMENT__OWNED_ELEMENT, ownedElements = new DerivedUnionEObjectEList<Element>(Element.class, this, UMLPackage.INSTANCE_SPECIFICATION__OWNED_ELEMENT, OWNED_ELEMENT_ESUBSETS));
			}
			return ownedElements;
		}
		return new DerivedUnionEObjectEList<Element>(Element.class, this, UMLPackage.INSTANCE_SPECIFICATION__OWNED_ELEMENT, OWNED_ELEMENT_ESUBSETS);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	public EList<Classifier> getClassifiers() {
		return (EList<Classifier>) eDynamicGet(UMLPackage.INSTANCE_SPECIFICATION__CLASSIFIER - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.INSTANCE_SPECIFICATION__CLASSIFIER, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Classifier getClassifier(String name) {
		return getClassifier(name, false, null);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Classifier getClassifier(String name, boolean ignoreCase,
			EClass eClass) {
		classifierLoop: for (Classifier classifier : getClassifiers()) {
			if (eClass != null && !eClass.isInstance(classifier))
				continue classifierLoop;
			if (name != null && !(ignoreCase ? name.equalsIgnoreCase(classifier.getName()) : name.equals(classifier.getName())))
				continue classifierLoop;
			return classifier;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ValueSpecification getSpecification() {
		return (ValueSpecification) eDynamicGet(UMLPackage.INSTANCE_SPECIFICATION__SPECIFICATION - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.INSTANCE_SPECIFICATION__SPECIFICATION, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ValueSpecification basicGetSpecification() {
		return (ValueSpecification) eDynamicGet(UMLPackage.INSTANCE_SPECIFICATION__SPECIFICATION - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.INSTANCE_SPECIFICATION__SPECIFICATION, false, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSpecification(
			ValueSpecification newSpecification, NotificationChain msgs) {
		msgs = eDynamicInverseAdd((InternalEObject) newSpecification, UMLPackage.INSTANCE_SPECIFICATION__SPECIFICATION, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSpecification(ValueSpecification newSpecification) {
		eDynamicSet(UMLPackage.INSTANCE_SPECIFICATION__SPECIFICATION - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.INSTANCE_SPECIFICATION__SPECIFICATION, newSpecification);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ValueSpecification createSpecification(String name, Type type,
			EClass eClass) {
		ValueSpecification newSpecification = (ValueSpecification) create(eClass);
		setSpecification(newSpecification);
		if (name != null)
			newSpecification.setName(name);
		if (type != null)
			newSpecification.setType(type);
		return newSpecification;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	public EList<Slot> getSlots() {
		return (EList<Slot>) eDynamicGet(UMLPackage.INSTANCE_SPECIFICATION__SLOT - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.INSTANCE_SPECIFICATION__SLOT, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Slot createSlot() {
		Slot newSlot = (Slot) create(UMLPackage.Literals.SLOT);
		getSlots().add(newSlot);
		return newSlot;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isCompatibleWith(ParameterableElement p) {
		return ParameterableElementOperations.isCompatibleWith(this, p);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isTemplateParameter() {
		return ParameterableElementOperations.isTemplateParameter(this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateNamespaceNeedsVisibility(DiagnosticChain diagnostics,
			Map<Object, Object> context) {
		return PackageableElementOperations.validateNamespaceNeedsVisibility(this, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateDefiningFeature(DiagnosticChain diagnostics,
			Map<Object, Object> context) {
		return InstanceSpecificationOperations.validateDefiningFeature(this, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateStructuralFeature(DiagnosticChain diagnostics,
			Map<Object, Object> context) {
		return InstanceSpecificationOperations.validateStructuralFeature(this, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateDeploymentTarget(DiagnosticChain diagnostics,
			Map<Object, Object> context) {
		return InstanceSpecificationOperations.validateDeploymentTarget(this, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateDeploymentArtifact(DiagnosticChain diagnostics,
			Map<Object, Object> context) {
		return InstanceSpecificationOperations.validateDeploymentArtifact(this, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd,
			int featureID, NotificationChain msgs) {
		switch (featureID) {
		case UMLPackage.INSTANCE_SPECIFICATION__EANNOTATIONS:
			return ((InternalEList<InternalEObject>) (InternalEList<?>) getEAnnotations()).basicAdd(otherEnd, msgs);
		case UMLPackage.INSTANCE_SPECIFICATION__DEPLOYMENT:
			return ((InternalEList<InternalEObject>) (InternalEList<?>) getDeployments()).basicAdd(otherEnd, msgs);
		case UMLPackage.INSTANCE_SPECIFICATION__OWNING_TEMPLATE_PARAMETER:
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			return basicSetOwningTemplateParameter((TemplateParameter) otherEnd, msgs);
		case UMLPackage.INSTANCE_SPECIFICATION__TEMPLATE_PARAMETER:
			TemplateParameter templateParameter = basicGetTemplateParameter();
			if (templateParameter != null)
				msgs = ((InternalEObject) templateParameter).eInverseRemove(this, UMLPackage.TEMPLATE_PARAMETER__PARAMETERED_ELEMENT, TemplateParameter.class, msgs);
			return basicSetTemplateParameter((TemplateParameter) otherEnd, msgs);
		case UMLPackage.INSTANCE_SPECIFICATION__SLOT:
			return ((InternalEList<InternalEObject>) (InternalEList<?>) getSlots()).basicAdd(otherEnd, msgs);
		}
		return eDynamicInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd,
			int featureID, NotificationChain msgs) {
		switch (featureID) {
		case UMLPackage.INSTANCE_SPECIFICATION__EANNOTATIONS:
			return ((InternalEList<?>) getEAnnotations()).basicRemove(otherEnd, msgs);
		case UMLPackage.INSTANCE_SPECIFICATION__OWNED_COMMENT:
			return ((InternalEList<?>) getOwnedComments()).basicRemove(otherEnd, msgs);
		case UMLPackage.INSTANCE_SPECIFICATION__NAME_EXPRESSION:
			return basicSetNameExpression(null, msgs);
		case UMLPackage.INSTANCE_SPECIFICATION__DEPLOYMENT:
			return ((InternalEList<?>) getDeployments()).basicRemove(otherEnd, msgs);
		case UMLPackage.INSTANCE_SPECIFICATION__OWNING_TEMPLATE_PARAMETER:
			return basicSetOwningTemplateParameter(null, msgs);
		case UMLPackage.INSTANCE_SPECIFICATION__TEMPLATE_PARAMETER:
			return basicSetTemplateParameter(null, msgs);
		case UMLPackage.INSTANCE_SPECIFICATION__SLOT:
			return ((InternalEList<?>) getSlots()).basicRemove(otherEnd, msgs);
		case UMLPackage.INSTANCE_SPECIFICATION__SPECIFICATION:
			return basicSetSpecification(null, msgs);
		}
		return eDynamicInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(
			NotificationChain msgs) {
		switch (eContainerFeatureID()) {
		case UMLPackage.INSTANCE_SPECIFICATION__OWNING_TEMPLATE_PARAMETER:
			return eInternalContainer().eInverseRemove(this, UMLPackage.TEMPLATE_PARAMETER__OWNED_PARAMETERED_ELEMENT, TemplateParameter.class, msgs);
		}
		return eDynamicBasicRemoveFromContainer(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case UMLPackage.INSTANCE_SPECIFICATION__EANNOTATIONS:
			return getEAnnotations();
		case UMLPackage.INSTANCE_SPECIFICATION__OWNED_COMMENT:
			return getOwnedComments();
		case UMLPackage.INSTANCE_SPECIFICATION__OWNED_ELEMENT:
			return getOwnedElements();
		case UMLPackage.INSTANCE_SPECIFICATION__OWNER:
			if (resolve)
				return getOwner();
			return basicGetOwner();
		case UMLPackage.INSTANCE_SPECIFICATION__CLIENT_DEPENDENCY:
			return getClientDependencies();
		case UMLPackage.INSTANCE_SPECIFICATION__NAME:
			return getName();
		case UMLPackage.INSTANCE_SPECIFICATION__NAME_EXPRESSION:
			if (resolve)
				return getNameExpression();
			return basicGetNameExpression();
		case UMLPackage.INSTANCE_SPECIFICATION__NAMESPACE:
			if (resolve)
				return getNamespace();
			return basicGetNamespace();
		case UMLPackage.INSTANCE_SPECIFICATION__QUALIFIED_NAME:
			return getQualifiedName();
		case UMLPackage.INSTANCE_SPECIFICATION__VISIBILITY:
			return getVisibility();
		case UMLPackage.INSTANCE_SPECIFICATION__DEPLOYED_ELEMENT:
			return getDeployedElements();
		case UMLPackage.INSTANCE_SPECIFICATION__DEPLOYMENT:
			return getDeployments();
		case UMLPackage.INSTANCE_SPECIFICATION__OWNING_TEMPLATE_PARAMETER:
			if (resolve)
				return getOwningTemplateParameter();
			return basicGetOwningTemplateParameter();
		case UMLPackage.INSTANCE_SPECIFICATION__TEMPLATE_PARAMETER:
			if (resolve)
				return getTemplateParameter();
			return basicGetTemplateParameter();
		case UMLPackage.INSTANCE_SPECIFICATION__CLASSIFIER:
			return getClassifiers();
		case UMLPackage.INSTANCE_SPECIFICATION__SLOT:
			return getSlots();
		case UMLPackage.INSTANCE_SPECIFICATION__SPECIFICATION:
			if (resolve)
				return getSpecification();
			return basicGetSpecification();
		}
		return eDynamicGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case UMLPackage.INSTANCE_SPECIFICATION__EANNOTATIONS:
			getEAnnotations().clear();
			getEAnnotations().addAll((Collection<? extends EAnnotation>) newValue);
			return;
		case UMLPackage.INSTANCE_SPECIFICATION__OWNED_COMMENT:
			getOwnedComments().clear();
			getOwnedComments().addAll((Collection<? extends Comment>) newValue);
			return;
		case UMLPackage.INSTANCE_SPECIFICATION__NAME:
			setName((String) newValue);
			return;
		case UMLPackage.INSTANCE_SPECIFICATION__NAME_EXPRESSION:
			setNameExpression((StringExpression) newValue);
			return;
		case UMLPackage.INSTANCE_SPECIFICATION__VISIBILITY:
			setVisibility((VisibilityKind) newValue);
			return;
		case UMLPackage.INSTANCE_SPECIFICATION__DEPLOYMENT:
			getDeployments().clear();
			getDeployments().addAll((Collection<? extends Deployment>) newValue);
			return;
		case UMLPackage.INSTANCE_SPECIFICATION__OWNING_TEMPLATE_PARAMETER:
			setOwningTemplateParameter((TemplateParameter) newValue);
			return;
		case UMLPackage.INSTANCE_SPECIFICATION__TEMPLATE_PARAMETER:
			setTemplateParameter((TemplateParameter) newValue);
			return;
		case UMLPackage.INSTANCE_SPECIFICATION__CLASSIFIER:
			getClassifiers().clear();
			getClassifiers().addAll((Collection<? extends Classifier>) newValue);
			return;
		case UMLPackage.INSTANCE_SPECIFICATION__SLOT:
			getSlots().clear();
			getSlots().addAll((Collection<? extends Slot>) newValue);
			return;
		case UMLPackage.INSTANCE_SPECIFICATION__SPECIFICATION:
			setSpecification((ValueSpecification) newValue);
			return;
		}
		eDynamicSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case UMLPackage.INSTANCE_SPECIFICATION__EANNOTATIONS:
			getEAnnotations().clear();
			return;
		case UMLPackage.INSTANCE_SPECIFICATION__OWNED_COMMENT:
			getOwnedComments().clear();
			return;
		case UMLPackage.INSTANCE_SPECIFICATION__NAME:
			unsetName();
			return;
		case UMLPackage.INSTANCE_SPECIFICATION__NAME_EXPRESSION:
			setNameExpression((StringExpression) null);
			return;
		case UMLPackage.INSTANCE_SPECIFICATION__VISIBILITY:
			unsetVisibility();
			return;
		case UMLPackage.INSTANCE_SPECIFICATION__DEPLOYMENT:
			getDeployments().clear();
			return;
		case UMLPackage.INSTANCE_SPECIFICATION__OWNING_TEMPLATE_PARAMETER:
			setOwningTemplateParameter((TemplateParameter) null);
			return;
		case UMLPackage.INSTANCE_SPECIFICATION__TEMPLATE_PARAMETER:
			setTemplateParameter((TemplateParameter) null);
			return;
		case UMLPackage.INSTANCE_SPECIFICATION__CLASSIFIER:
			getClassifiers().clear();
			return;
		case UMLPackage.INSTANCE_SPECIFICATION__SLOT:
			getSlots().clear();
			return;
		case UMLPackage.INSTANCE_SPECIFICATION__SPECIFICATION:
			setSpecification((ValueSpecification) null);
			return;
		}
		eDynamicUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case UMLPackage.INSTANCE_SPECIFICATION__EANNOTATIONS:
			return !getEAnnotations().isEmpty();
		case UMLPackage.INSTANCE_SPECIFICATION__OWNED_COMMENT:
			return !getOwnedComments().isEmpty();
		case UMLPackage.INSTANCE_SPECIFICATION__OWNED_ELEMENT:
			return isSetOwnedElements();
		case UMLPackage.INSTANCE_SPECIFICATION__OWNER:
			return isSetOwner();
		case UMLPackage.INSTANCE_SPECIFICATION__CLIENT_DEPENDENCY:
			return !getClientDependencies().isEmpty();
		case UMLPackage.INSTANCE_SPECIFICATION__NAME:
			return isSetName();
		case UMLPackage.INSTANCE_SPECIFICATION__NAME_EXPRESSION:
			return basicGetNameExpression() != null;
		case UMLPackage.INSTANCE_SPECIFICATION__NAMESPACE:
			return isSetNamespace();
		case UMLPackage.INSTANCE_SPECIFICATION__QUALIFIED_NAME:
			return QUALIFIED_NAME_EDEFAULT == null ? getQualifiedName() != null : !QUALIFIED_NAME_EDEFAULT.equals(getQualifiedName());
		case UMLPackage.INSTANCE_SPECIFICATION__VISIBILITY:
			return isSetVisibility();
		case UMLPackage.INSTANCE_SPECIFICATION__DEPLOYED_ELEMENT:
			return !getDeployedElements().isEmpty();
		case UMLPackage.INSTANCE_SPECIFICATION__DEPLOYMENT:
			return !getDeployments().isEmpty();
		case UMLPackage.INSTANCE_SPECIFICATION__OWNING_TEMPLATE_PARAMETER:
			return basicGetOwningTemplateParameter() != null;
		case UMLPackage.INSTANCE_SPECIFICATION__TEMPLATE_PARAMETER:
			return basicGetTemplateParameter() != null;
		case UMLPackage.INSTANCE_SPECIFICATION__CLASSIFIER:
			return !getClassifiers().isEmpty();
		case UMLPackage.INSTANCE_SPECIFICATION__SLOT:
			return !getSlots().isEmpty();
		case UMLPackage.INSTANCE_SPECIFICATION__SPECIFICATION:
			return basicGetSpecification() != null;
		}
		return eDynamicIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID,
			Class<?> baseClass) {
		if (baseClass == ParameterableElement.class) {
			switch (derivedFeatureID) {
			case UMLPackage.INSTANCE_SPECIFICATION__OWNING_TEMPLATE_PARAMETER:
				return UMLPackage.PARAMETERABLE_ELEMENT__OWNING_TEMPLATE_PARAMETER;
			case UMLPackage.INSTANCE_SPECIFICATION__TEMPLATE_PARAMETER:
				return UMLPackage.PARAMETERABLE_ELEMENT__TEMPLATE_PARAMETER;
			default:
				return -1;
			}
		}
		if (baseClass == PackageableElement.class) {
			switch (derivedFeatureID) {
			default:
				return -1;
			}
		}
		if (baseClass == DeployedArtifact.class) {
			switch (derivedFeatureID) {
			default:
				return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID,
			Class<?> baseClass) {
		if (baseClass == ParameterableElement.class) {
			switch (baseFeatureID) {
			case UMLPackage.PARAMETERABLE_ELEMENT__OWNING_TEMPLATE_PARAMETER:
				return UMLPackage.INSTANCE_SPECIFICATION__OWNING_TEMPLATE_PARAMETER;
			case UMLPackage.PARAMETERABLE_ELEMENT__TEMPLATE_PARAMETER:
				return UMLPackage.INSTANCE_SPECIFICATION__TEMPLATE_PARAMETER;
			default:
				return -1;
			}
		}
		if (baseClass == PackageableElement.class) {
			switch (baseFeatureID) {
			default:
				return -1;
			}
		}
		if (baseClass == DeployedArtifact.class) {
			switch (baseFeatureID) {
			default:
				return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedOperationID(int baseOperationID, Class<?> baseClass) {
		if (baseClass == ParameterableElement.class) {
			switch (baseOperationID) {
			case UMLPackage.PARAMETERABLE_ELEMENT___IS_COMPATIBLE_WITH__PARAMETERABLEELEMENT:
				return UMLPackage.INSTANCE_SPECIFICATION___IS_COMPATIBLE_WITH__PARAMETERABLEELEMENT;
			case UMLPackage.PARAMETERABLE_ELEMENT___IS_TEMPLATE_PARAMETER:
				return UMLPackage.INSTANCE_SPECIFICATION___IS_TEMPLATE_PARAMETER;
			default:
				return -1;
			}
		}
		if (baseClass == PackageableElement.class) {
			switch (baseOperationID) {
			case UMLPackage.PACKAGEABLE_ELEMENT___VALIDATE_NAMESPACE_NEEDS_VISIBILITY__DIAGNOSTICCHAIN_MAP:
				return UMLPackage.INSTANCE_SPECIFICATION___VALIDATE_NAMESPACE_NEEDS_VISIBILITY__DIAGNOSTICCHAIN_MAP;
			default:
				return -1;
			}
		}
		if (baseClass == DeployedArtifact.class) {
			switch (baseOperationID) {
			default:
				return -1;
			}
		}
		return super.eDerivedOperationID(baseOperationID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	@SuppressWarnings("unchecked")
	public Object eInvoke(int operationID, EList<?> arguments)
			throws InvocationTargetException {
		switch (operationID) {
		case UMLPackage.INSTANCE_SPECIFICATION___GET_EANNOTATION__STRING:
			return getEAnnotation((String) arguments.get(0));
		case UMLPackage.INSTANCE_SPECIFICATION___VALIDATE_HAS_OWNER__DIAGNOSTICCHAIN_MAP:
			return validateHasOwner((DiagnosticChain) arguments.get(0), (Map<Object, Object>) arguments.get(1));
		case UMLPackage.INSTANCE_SPECIFICATION___VALIDATE_NOT_OWN_SELF__DIAGNOSTICCHAIN_MAP:
			return validateNotOwnSelf((DiagnosticChain) arguments.get(0), (Map<Object, Object>) arguments.get(1));
		case UMLPackage.INSTANCE_SPECIFICATION___ADD_KEYWORD__STRING:
			return addKeyword((String) arguments.get(0));
		case UMLPackage.INSTANCE_SPECIFICATION___APPLY_STEREOTYPE__STEREOTYPE:
			return applyStereotype((Stereotype) arguments.get(0));
		case UMLPackage.INSTANCE_SPECIFICATION___CREATE_EANNOTATION__STRING:
			return createEAnnotation((String) arguments.get(0));
		case UMLPackage.INSTANCE_SPECIFICATION___DESTROY:
			destroy();
			return null;
		case UMLPackage.INSTANCE_SPECIFICATION___GET_KEYWORDS:
			return getKeywords();
		case UMLPackage.INSTANCE_SPECIFICATION___GET_APPLICABLE_STEREOTYPE__STRING:
			return getApplicableStereotype((String) arguments.get(0));
		case UMLPackage.INSTANCE_SPECIFICATION___GET_APPLICABLE_STEREOTYPES:
			return getApplicableStereotypes();
		case UMLPackage.INSTANCE_SPECIFICATION___GET_APPLIED_STEREOTYPE__STRING:
			return getAppliedStereotype((String) arguments.get(0));
		case UMLPackage.INSTANCE_SPECIFICATION___GET_APPLIED_STEREOTYPES:
			return getAppliedStereotypes();
		case UMLPackage.INSTANCE_SPECIFICATION___GET_APPLIED_SUBSTEREOTYPE__STEREOTYPE_STRING:
			return getAppliedSubstereotype((Stereotype) arguments.get(0), (String) arguments.get(1));
		case UMLPackage.INSTANCE_SPECIFICATION___GET_APPLIED_SUBSTEREOTYPES__STEREOTYPE:
			return getAppliedSubstereotypes((Stereotype) arguments.get(0));
		case UMLPackage.INSTANCE_SPECIFICATION___GET_MODEL:
			return getModel();
		case UMLPackage.INSTANCE_SPECIFICATION___GET_NEAREST_PACKAGE:
			return getNearestPackage();
		case UMLPackage.INSTANCE_SPECIFICATION___GET_RELATIONSHIPS:
			return getRelationships();
		case UMLPackage.INSTANCE_SPECIFICATION___GET_RELATIONSHIPS__ECLASS:
			return getRelationships((EClass) arguments.get(0));
		case UMLPackage.INSTANCE_SPECIFICATION___GET_REQUIRED_STEREOTYPE__STRING:
			return getRequiredStereotype((String) arguments.get(0));
		case UMLPackage.INSTANCE_SPECIFICATION___GET_REQUIRED_STEREOTYPES:
			return getRequiredStereotypes();
		case UMLPackage.INSTANCE_SPECIFICATION___GET_SOURCE_DIRECTED_RELATIONSHIPS:
			return getSourceDirectedRelationships();
		case UMLPackage.INSTANCE_SPECIFICATION___GET_SOURCE_DIRECTED_RELATIONSHIPS__ECLASS:
			return getSourceDirectedRelationships((EClass) arguments.get(0));
		case UMLPackage.INSTANCE_SPECIFICATION___GET_STEREOTYPE_APPLICATION__STEREOTYPE:
			return getStereotypeApplication((Stereotype) arguments.get(0));
		case UMLPackage.INSTANCE_SPECIFICATION___GET_STEREOTYPE_APPLICATIONS:
			return getStereotypeApplications();
		case UMLPackage.INSTANCE_SPECIFICATION___GET_TARGET_DIRECTED_RELATIONSHIPS:
			return getTargetDirectedRelationships();
		case UMLPackage.INSTANCE_SPECIFICATION___GET_TARGET_DIRECTED_RELATIONSHIPS__ECLASS:
			return getTargetDirectedRelationships((EClass) arguments.get(0));
		case UMLPackage.INSTANCE_SPECIFICATION___GET_VALUE__STEREOTYPE_STRING:
			return getValue((Stereotype) arguments.get(0), (String) arguments.get(1));
		case UMLPackage.INSTANCE_SPECIFICATION___HAS_KEYWORD__STRING:
			return hasKeyword((String) arguments.get(0));
		case UMLPackage.INSTANCE_SPECIFICATION___HAS_VALUE__STEREOTYPE_STRING:
			return hasValue((Stereotype) arguments.get(0), (String) arguments.get(1));
		case UMLPackage.INSTANCE_SPECIFICATION___IS_STEREOTYPE_APPLICABLE__STEREOTYPE:
			return isStereotypeApplicable((Stereotype) arguments.get(0));
		case UMLPackage.INSTANCE_SPECIFICATION___IS_STEREOTYPE_APPLIED__STEREOTYPE:
			return isStereotypeApplied((Stereotype) arguments.get(0));
		case UMLPackage.INSTANCE_SPECIFICATION___IS_STEREOTYPE_REQUIRED__STEREOTYPE:
			return isStereotypeRequired((Stereotype) arguments.get(0));
		case UMLPackage.INSTANCE_SPECIFICATION___REMOVE_KEYWORD__STRING:
			return removeKeyword((String) arguments.get(0));
		case UMLPackage.INSTANCE_SPECIFICATION___SET_VALUE__STEREOTYPE_STRING_OBJECT:
			setValue((Stereotype) arguments.get(0), (String) arguments.get(1), arguments.get(2));
			return null;
		case UMLPackage.INSTANCE_SPECIFICATION___UNAPPLY_STEREOTYPE__STEREOTYPE:
			return unapplyStereotype((Stereotype) arguments.get(0));
		case UMLPackage.INSTANCE_SPECIFICATION___ALL_OWNED_ELEMENTS:
			return allOwnedElements();
		case UMLPackage.INSTANCE_SPECIFICATION___MUST_BE_OWNED:
			return mustBeOwned();
		case UMLPackage.INSTANCE_SPECIFICATION___VALIDATE_VISIBILITY_NEEDS_OWNERSHIP__DIAGNOSTICCHAIN_MAP:
			return validateVisibilityNeedsOwnership((DiagnosticChain) arguments.get(0), (Map<Object, Object>) arguments.get(1));
		case UMLPackage.INSTANCE_SPECIFICATION___VALIDATE_HAS_QUALIFIED_NAME__DIAGNOSTICCHAIN_MAP:
			return validateHasQualifiedName((DiagnosticChain) arguments.get(0), (Map<Object, Object>) arguments.get(1));
		case UMLPackage.INSTANCE_SPECIFICATION___VALIDATE_HAS_NO_QUALIFIED_NAME__DIAGNOSTICCHAIN_MAP:
			return validateHasNoQualifiedName((DiagnosticChain) arguments.get(0), (Map<Object, Object>) arguments.get(1));
		case UMLPackage.INSTANCE_SPECIFICATION___CREATE_DEPENDENCY__NAMEDELEMENT:
			return createDependency((NamedElement) arguments.get(0));
		case UMLPackage.INSTANCE_SPECIFICATION___CREATE_USAGE__NAMEDELEMENT:
			return createUsage((NamedElement) arguments.get(0));
		case UMLPackage.INSTANCE_SPECIFICATION___GET_LABEL:
			return getLabel();
		case UMLPackage.INSTANCE_SPECIFICATION___GET_LABEL__BOOLEAN:
			return getLabel((Boolean) arguments.get(0));
		case UMLPackage.INSTANCE_SPECIFICATION___GET_NAMESPACE:
			return getNamespace();
		case UMLPackage.INSTANCE_SPECIFICATION___ALL_NAMESPACES:
			return allNamespaces();
		case UMLPackage.INSTANCE_SPECIFICATION___ALL_OWNING_PACKAGES:
			return allOwningPackages();
		case UMLPackage.INSTANCE_SPECIFICATION___IS_DISTINGUISHABLE_FROM__NAMEDELEMENT_NAMESPACE:
			return isDistinguishableFrom((NamedElement) arguments.get(0), (Namespace) arguments.get(1));
		case UMLPackage.INSTANCE_SPECIFICATION___GET_QUALIFIED_NAME:
			return getQualifiedName();
		case UMLPackage.INSTANCE_SPECIFICATION___SEPARATOR:
			return separator();
		case UMLPackage.INSTANCE_SPECIFICATION___GET_CLIENT_DEPENDENCIES:
			return getClientDependencies();
		case UMLPackage.INSTANCE_SPECIFICATION___GET_DEPLOYED_ELEMENTS:
			return getDeployedElements();
		case UMLPackage.INSTANCE_SPECIFICATION___IS_COMPATIBLE_WITH__PARAMETERABLEELEMENT:
			return isCompatibleWith((ParameterableElement) arguments.get(0));
		case UMLPackage.INSTANCE_SPECIFICATION___IS_TEMPLATE_PARAMETER:
			return isTemplateParameter();
		case UMLPackage.INSTANCE_SPECIFICATION___VALIDATE_NAMESPACE_NEEDS_VISIBILITY__DIAGNOSTICCHAIN_MAP:
			return validateNamespaceNeedsVisibility((DiagnosticChain) arguments.get(0), (Map<Object, Object>) arguments.get(1));
		case UMLPackage.INSTANCE_SPECIFICATION___VALIDATE_DEPLOYMENT_ARTIFACT__DIAGNOSTICCHAIN_MAP:
			return validateDeploymentArtifact((DiagnosticChain) arguments.get(0), (Map<Object, Object>) arguments.get(1));
		case UMLPackage.INSTANCE_SPECIFICATION___VALIDATE_STRUCTURAL_FEATURE__DIAGNOSTICCHAIN_MAP:
			return validateStructuralFeature((DiagnosticChain) arguments.get(0), (Map<Object, Object>) arguments.get(1));
		case UMLPackage.INSTANCE_SPECIFICATION___VALIDATE_DEFINING_FEATURE__DIAGNOSTICCHAIN_MAP:
			return validateDefiningFeature((DiagnosticChain) arguments.get(0), (Map<Object, Object>) arguments.get(1));
		case UMLPackage.INSTANCE_SPECIFICATION___VALIDATE_DEPLOYMENT_TARGET__DIAGNOSTICCHAIN_MAP:
			return validateDeploymentTarget((DiagnosticChain) arguments.get(0), (Map<Object, Object>) arguments.get(1));
		}
		return eDynamicInvoke(operationID, arguments);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Element basicGetOwner() {
		TemplateParameter owningTemplateParameter = basicGetOwningTemplateParameter();
		if (owningTemplateParameter != null) {
			return owningTemplateParameter;
		}
		return super.basicGetOwner();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isSetOwner() {
		return super.isSetOwner()
				|| eIsSet(UMLPackage.INSTANCE_SPECIFICATION__OWNING_TEMPLATE_PARAMETER);
	}

	/**
	 * The array of subset feature identifiers for the '{@link #getOwnedElements() <em>Owned Element</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOwnedElements()
	 * @generated
	 * @ordered
	 */
	protected static final int[] OWNED_ELEMENT_ESUBSETS = new int[] { UMLPackage.INSTANCE_SPECIFICATION__OWNED_COMMENT, UMLPackage.INSTANCE_SPECIFICATION__NAME_EXPRESSION, UMLPackage.INSTANCE_SPECIFICATION__DEPLOYMENT, UMLPackage.INSTANCE_SPECIFICATION__SLOT,
			UMLPackage.INSTANCE_SPECIFICATION__SPECIFICATION };

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isSetOwnedElements() {
		return super.isSetOwnedElements()
				|| eIsSet(UMLPackage.INSTANCE_SPECIFICATION__SLOT)
				|| eIsSet(UMLPackage.INSTANCE_SPECIFICATION__SPECIFICATION);
	}

} //InstanceSpecificationImpl
