/*
 * Copyright (c) 2005, 2018 IBM Corporation, CEA, and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 *
 * Contributors:
 *   IBM - initial API and implementation
 *   Kenn Hussey (CEA) - 327039, 451350, 485756
 *   Kenn Hussey - 519572, 535301
 *
 */
package org.eclipse.uml2.uml.cdo.internal.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectResolvingEList;

import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.UMLPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Comment</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.uml2.uml.cdo.internal.impl.CommentImpl#getAnnotatedElements <em>Annotated Element</em>}</li>
 *   <li>{@link org.eclipse.uml2.uml.cdo.internal.impl.CommentImpl#getBody <em>Body</em>}</li>
 * </ul>
 *
 * @generated
 */
public class CommentImpl
		extends ElementImpl
		implements Comment {

	/**
	 * The default value of the '{@link #getBody() <em>Body</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBody()
	 * @generated
	 * @ordered
	 */
	protected static final String BODY_EDEFAULT = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CommentImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return UMLPackage.Literals.COMMENT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getBody() {
		return (String) eDynamicGet(UMLPackage.COMMENT__BODY - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.COMMENT__BODY, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setBody(String newBody) {
		eDynamicSet(UMLPackage.COMMENT__BODY - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.COMMENT__BODY, newBody);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetBody() {
		eDynamicUnset(UMLPackage.COMMENT__BODY - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.COMMENT__BODY);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetBody() {
		return eDynamicIsSet(UMLPackage.COMMENT__BODY - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.COMMENT__BODY);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	public EList<Element> getAnnotatedElements() {
		return (EList<Element>) eDynamicGet(UMLPackage.COMMENT__ANNOTATED_ELEMENT - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.COMMENT__ANNOTATED_ELEMENT, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case UMLPackage.COMMENT__EANNOTATIONS:
			return getEAnnotations();
		case UMLPackage.COMMENT__OWNED_COMMENT:
			return getOwnedComments();
		case UMLPackage.COMMENT__OWNED_ELEMENT:
			return getOwnedElements();
		case UMLPackage.COMMENT__OWNER:
			if (resolve)
				return getOwner();
			return basicGetOwner();
		case UMLPackage.COMMENT__ANNOTATED_ELEMENT:
			return getAnnotatedElements();
		case UMLPackage.COMMENT__BODY:
			return getBody();
		}
		return eDynamicGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case UMLPackage.COMMENT__EANNOTATIONS:
			getEAnnotations().clear();
			getEAnnotations().addAll((Collection<? extends EAnnotation>) newValue);
			return;
		case UMLPackage.COMMENT__OWNED_COMMENT:
			getOwnedComments().clear();
			getOwnedComments().addAll((Collection<? extends Comment>) newValue);
			return;
		case UMLPackage.COMMENT__ANNOTATED_ELEMENT:
			getAnnotatedElements().clear();
			getAnnotatedElements().addAll((Collection<? extends Element>) newValue);
			return;
		case UMLPackage.COMMENT__BODY:
			setBody((String) newValue);
			return;
		}
		eDynamicSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case UMLPackage.COMMENT__EANNOTATIONS:
			getEAnnotations().clear();
			return;
		case UMLPackage.COMMENT__OWNED_COMMENT:
			getOwnedComments().clear();
			return;
		case UMLPackage.COMMENT__ANNOTATED_ELEMENT:
			getAnnotatedElements().clear();
			return;
		case UMLPackage.COMMENT__BODY:
			unsetBody();
			return;
		}
		eDynamicUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case UMLPackage.COMMENT__EANNOTATIONS:
			return !getEAnnotations().isEmpty();
		case UMLPackage.COMMENT__OWNED_COMMENT:
			return !getOwnedComments().isEmpty();
		case UMLPackage.COMMENT__OWNED_ELEMENT:
			return isSetOwnedElements();
		case UMLPackage.COMMENT__OWNER:
			return isSetOwner();
		case UMLPackage.COMMENT__ANNOTATED_ELEMENT:
			return !getAnnotatedElements().isEmpty();
		case UMLPackage.COMMENT__BODY:
			return isSetBody();
		}
		return eDynamicIsSet(featureID);
	}

} //CommentImpl
