/**
 * Copyright (c) 2021 CEA LIST.
 * 
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License 2.0
 *  which accompanies this distribution, and is available at
 *  https://www.eclipse.org/legal/epl-2.0/
 * 
 *  SPDX-License-Identifier: EPL-2.0
 * 
 *  Contributors:
 *  Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr - Initial API and implementation
 */
package org.eclipse.papyrus.infra.textedit.cdo.textdocument.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.internal.cdo.CDOObjectImpl;
import org.eclipse.papyrus.infra.textedit.textdocument.TextDocument;
import org.eclipse.papyrus.infra.textedit.textdocument.TextDocumentPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Text Document</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 * <li>{@link org.eclipse.papyrus.infra.textedit.cdo.textdocument.impl.TextDocumentImpl#getSemanticContext <em>Semantic Context</em>}</li>
 * <li>{@link org.eclipse.papyrus.infra.textedit.cdo.textdocument.impl.TextDocumentImpl#getGraphicalContext <em>Graphical Context</em>}</li>
 * <li>{@link org.eclipse.papyrus.infra.textedit.cdo.textdocument.impl.TextDocumentImpl#getName <em>Name</em>}</li>
 * <li>{@link org.eclipse.papyrus.infra.textedit.cdo.textdocument.impl.TextDocumentImpl#getKindId <em>Kind Id</em>}</li>
 * <li>{@link org.eclipse.papyrus.infra.textedit.cdo.textdocument.impl.TextDocumentImpl#getType <em>Type</em>}</li>
 * </ul>
 *
 * @generated
 */
public class TextDocumentImpl extends CDOObjectImpl implements TextDocument {
	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The default value of the '{@link #getKindId() <em>Kind Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getKindId()
	 * @generated
	 * @ordered
	 */
	protected static final String KIND_ID_EDEFAULT = null;

	/**
	 * The default value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected static final String TYPE_EDEFAULT = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected TextDocumentImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return TextDocumentPackage.Literals.TEXT_DOCUMENT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected int eStaticFeatureCount() {
		return 0;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EObject getSemanticContext() {
		return (EObject) eDynamicGet(TextDocumentPackage.TEXT_DOCUMENT__SEMANTIC_CONTEXT, TextDocumentPackage.Literals.TEXT_DOCUMENT__SEMANTIC_CONTEXT, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EObject basicGetSemanticContext() {
		return (EObject) eDynamicGet(TextDocumentPackage.TEXT_DOCUMENT__SEMANTIC_CONTEXT, TextDocumentPackage.Literals.TEXT_DOCUMENT__SEMANTIC_CONTEXT, false, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setSemanticContext(EObject newSemanticContext) {
		eDynamicSet(TextDocumentPackage.TEXT_DOCUMENT__SEMANTIC_CONTEXT, TextDocumentPackage.Literals.TEXT_DOCUMENT__SEMANTIC_CONTEXT, newSemanticContext);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EObject getGraphicalContext() {
		return (EObject) eDynamicGet(TextDocumentPackage.TEXT_DOCUMENT__GRAPHICAL_CONTEXT, TextDocumentPackage.Literals.TEXT_DOCUMENT__GRAPHICAL_CONTEXT, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EObject basicGetGraphicalContext() {
		return (EObject) eDynamicGet(TextDocumentPackage.TEXT_DOCUMENT__GRAPHICAL_CONTEXT, TextDocumentPackage.Literals.TEXT_DOCUMENT__GRAPHICAL_CONTEXT, false, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setGraphicalContext(EObject newGraphicalContext) {
		eDynamicSet(TextDocumentPackage.TEXT_DOCUMENT__GRAPHICAL_CONTEXT, TextDocumentPackage.Literals.TEXT_DOCUMENT__GRAPHICAL_CONTEXT, newGraphicalContext);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String getName() {
		return (String) eDynamicGet(TextDocumentPackage.TEXT_DOCUMENT__NAME, TextDocumentPackage.Literals.TEXT_DOCUMENT__NAME, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setName(String newName) {
		eDynamicSet(TextDocumentPackage.TEXT_DOCUMENT__NAME, TextDocumentPackage.Literals.TEXT_DOCUMENT__NAME, newName);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String getKindId() {
		return (String) eDynamicGet(TextDocumentPackage.TEXT_DOCUMENT__KIND_ID, TextDocumentPackage.Literals.TEXT_DOCUMENT__KIND_ID, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setKindId(String newKindId) {
		eDynamicSet(TextDocumentPackage.TEXT_DOCUMENT__KIND_ID, TextDocumentPackage.Literals.TEXT_DOCUMENT__KIND_ID, newKindId);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String getType() {
		return (String) eDynamicGet(TextDocumentPackage.TEXT_DOCUMENT__TYPE, TextDocumentPackage.Literals.TEXT_DOCUMENT__TYPE, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setType(String newType) {
		eDynamicSet(TextDocumentPackage.TEXT_DOCUMENT__TYPE, TextDocumentPackage.Literals.TEXT_DOCUMENT__TYPE, newType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case TextDocumentPackage.TEXT_DOCUMENT__SEMANTIC_CONTEXT:
			if (resolve)
				return getSemanticContext();
			return basicGetSemanticContext();
		case TextDocumentPackage.TEXT_DOCUMENT__GRAPHICAL_CONTEXT:
			if (resolve)
				return getGraphicalContext();
			return basicGetGraphicalContext();
		case TextDocumentPackage.TEXT_DOCUMENT__NAME:
			return getName();
		case TextDocumentPackage.TEXT_DOCUMENT__KIND_ID:
			return getKindId();
		case TextDocumentPackage.TEXT_DOCUMENT__TYPE:
			return getType();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case TextDocumentPackage.TEXT_DOCUMENT__SEMANTIC_CONTEXT:
			setSemanticContext((EObject) newValue);
			return;
		case TextDocumentPackage.TEXT_DOCUMENT__GRAPHICAL_CONTEXT:
			setGraphicalContext((EObject) newValue);
			return;
		case TextDocumentPackage.TEXT_DOCUMENT__NAME:
			setName((String) newValue);
			return;
		case TextDocumentPackage.TEXT_DOCUMENT__KIND_ID:
			setKindId((String) newValue);
			return;
		case TextDocumentPackage.TEXT_DOCUMENT__TYPE:
			setType((String) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case TextDocumentPackage.TEXT_DOCUMENT__SEMANTIC_CONTEXT:
			setSemanticContext((EObject) null);
			return;
		case TextDocumentPackage.TEXT_DOCUMENT__GRAPHICAL_CONTEXT:
			setGraphicalContext((EObject) null);
			return;
		case TextDocumentPackage.TEXT_DOCUMENT__NAME:
			setName(NAME_EDEFAULT);
			return;
		case TextDocumentPackage.TEXT_DOCUMENT__KIND_ID:
			setKindId(KIND_ID_EDEFAULT);
			return;
		case TextDocumentPackage.TEXT_DOCUMENT__TYPE:
			setType(TYPE_EDEFAULT);
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case TextDocumentPackage.TEXT_DOCUMENT__SEMANTIC_CONTEXT:
			return basicGetSemanticContext() != null;
		case TextDocumentPackage.TEXT_DOCUMENT__GRAPHICAL_CONTEXT:
			return basicGetGraphicalContext() != null;
		case TextDocumentPackage.TEXT_DOCUMENT__NAME:
			return NAME_EDEFAULT == null ? getName() != null : !NAME_EDEFAULT.equals(getName());
		case TextDocumentPackage.TEXT_DOCUMENT__KIND_ID:
			return KIND_ID_EDEFAULT == null ? getKindId() != null : !KIND_ID_EDEFAULT.equals(getKindId());
		case TextDocumentPackage.TEXT_DOCUMENT__TYPE:
			return TYPE_EDEFAULT == null ? getType() != null : !TYPE_EDEFAULT.equals(getType());
		}
		return super.eIsSet(featureID);
	}

} // TextDocumentImpl
