/**
 * Copyright (c) 2013 CEA LIST.
 *
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 * 	Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr - Initial API and implementation
 */
package org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattablestyle.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.DisplayStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestylePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.TableDisplayStyle;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Table Display Style</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 * <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattablestyle.impl.TableDisplayStyleImpl#getDisplayStyle <em>Display Style</em>}</li>
 * </ul>
 *
 * @generated not
 */
public class TableDisplayStyleImpl extends org.eclipse.emf.cdo.ecore.impl.EModelElementImpl implements TableDisplayStyle {

	/**
	 * The default value of the '{@link #getDisplayStyle() <em>Display Style</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getDisplayStyle()
	 * @generated
	 * @ordered
	 */
	protected static final DisplayStyle DISPLAY_STYLE_EDEFAULT = DisplayStyle.NORMAL;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected TableDisplayStyleImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return NattablestylePackage.Literals.TABLE_DISPLAY_STYLE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * Decrease the generated ESTATIC_FEATURE_COUNT from 1 to 0 because the inherited
	 * EModelElement.eAnnotations feature is implemented dynamically, too.
	 * <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	protected static final int ESTATIC_FEATURE_COUNT = 0;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected int eStaticFeatureCount() {
		return ESTATIC_FEATURE_COUNT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public DisplayStyle getDisplayStyle() {
		return (DisplayStyle) eDynamicGet(NattablestylePackage.TABLE_DISPLAY_STYLE__DISPLAY_STYLE - ESTATIC_FEATURE_COUNT, NattablestylePackage.Literals.TABLE_DISPLAY_STYLE__DISPLAY_STYLE, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setDisplayStyle(DisplayStyle newDisplayStyle) {
		eDynamicSet(NattablestylePackage.TABLE_DISPLAY_STYLE__DISPLAY_STYLE - ESTATIC_FEATURE_COUNT, NattablestylePackage.Literals.TABLE_DISPLAY_STYLE__DISPLAY_STYLE, newDisplayStyle);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case NattablestylePackage.TABLE_DISPLAY_STYLE__DISPLAY_STYLE:
			return getDisplayStyle();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case NattablestylePackage.TABLE_DISPLAY_STYLE__DISPLAY_STYLE:
			setDisplayStyle((DisplayStyle) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case NattablestylePackage.TABLE_DISPLAY_STYLE__DISPLAY_STYLE:
			setDisplayStyle(DISPLAY_STYLE_EDEFAULT);
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case NattablestylePackage.TABLE_DISPLAY_STYLE__DISPLAY_STYLE:
			return getDisplayStyle() != DISPLAY_STYLE_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}
} // TableDisplayStyleImpl
