/**
 * Copyright (c) 2013 CEA LIST.
 *
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 * 	Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr - Initial API and implementation
 */
package org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattableproblem.impl;

import java.util.Collection;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableproblem.NattableproblemPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableproblem.StringResolutionProblem;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>String Resolution Problem</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattableproblem.impl.StringResolutionProblemImpl#getValueAsString <em>Value As String</em>}</li>
 *   <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattableproblem.impl.StringResolutionProblemImpl#getUnresolvedString <em>Unresolved String</em>}</li>
 * </ul>
 *
 * @generated
 */
public class StringResolutionProblemImpl extends ProblemImpl implements StringResolutionProblem {

	/**
	 * The default value of the '{@link #getValueAsString() <em>Value As String</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getValueAsString()
	 * @generated
	 * @ordered
	 */
	protected static final String VALUE_AS_STRING_EDEFAULT = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StringResolutionProblemImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return NattableproblemPackage.Literals.STRING_RESOLUTION_PROBLEM;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getValueAsString() {
		return (String)eDynamicGet(NattableproblemPackage.STRING_RESOLUTION_PROBLEM__VALUE_AS_STRING - ESTATIC_FEATURE_COUNT, NattableproblemPackage.Literals.STRING_RESOLUTION_PROBLEM__VALUE_AS_STRING, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setValueAsString(String newValueAsString) {
		eDynamicSet(NattableproblemPackage.STRING_RESOLUTION_PROBLEM__VALUE_AS_STRING - ESTATIC_FEATURE_COUNT, NattableproblemPackage.Literals.STRING_RESOLUTION_PROBLEM__VALUE_AS_STRING, newValueAsString);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public EList<String> getUnresolvedString() {
		return (EList<String>)eDynamicGet(NattableproblemPackage.STRING_RESOLUTION_PROBLEM__UNRESOLVED_STRING - ESTATIC_FEATURE_COUNT, NattableproblemPackage.Literals.STRING_RESOLUTION_PROBLEM__UNRESOLVED_STRING, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case NattableproblemPackage.STRING_RESOLUTION_PROBLEM__VALUE_AS_STRING:
				return getValueAsString();
			case NattableproblemPackage.STRING_RESOLUTION_PROBLEM__UNRESOLVED_STRING:
				return getUnresolvedString();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case NattableproblemPackage.STRING_RESOLUTION_PROBLEM__VALUE_AS_STRING:
				setValueAsString((String)newValue);
				return;
			case NattableproblemPackage.STRING_RESOLUTION_PROBLEM__UNRESOLVED_STRING:
				getUnresolvedString().clear();
				getUnresolvedString().addAll((Collection<? extends String>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case NattableproblemPackage.STRING_RESOLUTION_PROBLEM__VALUE_AS_STRING:
				setValueAsString(VALUE_AS_STRING_EDEFAULT);
				return;
			case NattableproblemPackage.STRING_RESOLUTION_PROBLEM__UNRESOLVED_STRING:
				getUnresolvedString().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case NattableproblemPackage.STRING_RESOLUTION_PROBLEM__VALUE_AS_STRING:
				return VALUE_AS_STRING_EDEFAULT == null ? getValueAsString() != null : !VALUE_AS_STRING_EDEFAULT.equals(getValueAsString());
			case NattableproblemPackage.STRING_RESOLUTION_PROBLEM__UNRESOLVED_STRING:
				return !getUnresolvedString().isEmpty();
		}
		return super.eIsSet(featureID);
	}
} // StringResolutionProblemImpl
