/**
 * Copyright (c) 2013 CEA LIST.
 *
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 * 	Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr - Initial API and implementation
 */
package org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattableaxis.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.FeatureIdTreeItemAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.ITreeItemAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.NattableaxisPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Feature Id Tree Item Axis</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattableaxis.impl.FeatureIdTreeItemAxisImpl#getParent <em>Parent</em>}</li>
 *   <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattableaxis.impl.FeatureIdTreeItemAxisImpl#isExpanded <em>Expanded</em>}</li>
 *   <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattableaxis.impl.FeatureIdTreeItemAxisImpl#getChildren <em>Children</em>}</li>
 * </ul>
 *
 * @generated
 */
public class FeatureIdTreeItemAxisImpl extends FeatureIdAxisImpl implements FeatureIdTreeItemAxis {

	/**
	 * The default value of the '{@link #isExpanded() <em>Expanded</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isExpanded()
	 * @generated
	 * @ordered
	 */
	protected static final boolean EXPANDED_EDEFAULT = false;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FeatureIdTreeItemAxisImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return NattableaxisPackage.Literals.FEATURE_ID_TREE_ITEM_AXIS;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ITreeItemAxis getParent() {
		return (ITreeItemAxis)eDynamicGet(NattableaxisPackage.FEATURE_ID_TREE_ITEM_AXIS__PARENT - ESTATIC_FEATURE_COUNT, NattableaxisPackage.Literals.ITREE_ITEM_AXIS__PARENT, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ITreeItemAxis basicGetParent() {
		return (ITreeItemAxis)eDynamicGet(NattableaxisPackage.FEATURE_ID_TREE_ITEM_AXIS__PARENT - ESTATIC_FEATURE_COUNT, NattableaxisPackage.Literals.ITREE_ITEM_AXIS__PARENT, false, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetParent(ITreeItemAxis newParent, NotificationChain msgs) {
		msgs = eDynamicInverseAdd((InternalEObject)newParent, NattableaxisPackage.FEATURE_ID_TREE_ITEM_AXIS__PARENT, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParent(ITreeItemAxis newParent) {
		eDynamicSet(NattableaxisPackage.FEATURE_ID_TREE_ITEM_AXIS__PARENT - ESTATIC_FEATURE_COUNT, NattableaxisPackage.Literals.ITREE_ITEM_AXIS__PARENT, newParent);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isExpanded() {
		return (Boolean)eDynamicGet(NattableaxisPackage.FEATURE_ID_TREE_ITEM_AXIS__EXPANDED - ESTATIC_FEATURE_COUNT, NattableaxisPackage.Literals.ITREE_ITEM_AXIS__EXPANDED, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setExpanded(boolean newExpanded) {
		eDynamicSet(NattableaxisPackage.FEATURE_ID_TREE_ITEM_AXIS__EXPANDED - ESTATIC_FEATURE_COUNT, NattableaxisPackage.Literals.ITREE_ITEM_AXIS__EXPANDED, newExpanded);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public EList<ITreeItemAxis> getChildren() {
		return (EList<ITreeItemAxis>)eDynamicGet(NattableaxisPackage.FEATURE_ID_TREE_ITEM_AXIS__CHILDREN - ESTATIC_FEATURE_COUNT, NattableaxisPackage.Literals.ITREE_ITEM_AXIS__CHILDREN, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case NattableaxisPackage.FEATURE_ID_TREE_ITEM_AXIS__PARENT:
				ITreeItemAxis parent = basicGetParent();
				if (parent != null)
					msgs = ((InternalEObject)parent).eInverseRemove(this, NattableaxisPackage.ITREE_ITEM_AXIS__CHILDREN, ITreeItemAxis.class, msgs);
				return basicSetParent((ITreeItemAxis)otherEnd, msgs);
			case NattableaxisPackage.FEATURE_ID_TREE_ITEM_AXIS__CHILDREN:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getChildren()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case NattableaxisPackage.FEATURE_ID_TREE_ITEM_AXIS__PARENT:
				return basicSetParent(null, msgs);
			case NattableaxisPackage.FEATURE_ID_TREE_ITEM_AXIS__CHILDREN:
				return ((InternalEList<?>)getChildren()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case NattableaxisPackage.FEATURE_ID_TREE_ITEM_AXIS__PARENT:
				if (resolve) return getParent();
				return basicGetParent();
			case NattableaxisPackage.FEATURE_ID_TREE_ITEM_AXIS__EXPANDED:
				return isExpanded();
			case NattableaxisPackage.FEATURE_ID_TREE_ITEM_AXIS__CHILDREN:
				return getChildren();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case NattableaxisPackage.FEATURE_ID_TREE_ITEM_AXIS__PARENT:
				setParent((ITreeItemAxis)newValue);
				return;
			case NattableaxisPackage.FEATURE_ID_TREE_ITEM_AXIS__EXPANDED:
				setExpanded((Boolean)newValue);
				return;
			case NattableaxisPackage.FEATURE_ID_TREE_ITEM_AXIS__CHILDREN:
				getChildren().clear();
				getChildren().addAll((Collection<? extends ITreeItemAxis>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case NattableaxisPackage.FEATURE_ID_TREE_ITEM_AXIS__PARENT:
				setParent((ITreeItemAxis)null);
				return;
			case NattableaxisPackage.FEATURE_ID_TREE_ITEM_AXIS__EXPANDED:
				setExpanded(EXPANDED_EDEFAULT);
				return;
			case NattableaxisPackage.FEATURE_ID_TREE_ITEM_AXIS__CHILDREN:
				getChildren().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case NattableaxisPackage.FEATURE_ID_TREE_ITEM_AXIS__PARENT:
				return basicGetParent() != null;
			case NattableaxisPackage.FEATURE_ID_TREE_ITEM_AXIS__EXPANDED:
				return isExpanded() != EXPANDED_EDEFAULT;
			case NattableaxisPackage.FEATURE_ID_TREE_ITEM_AXIS__CHILDREN:
				return !getChildren().isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == ITreeItemAxis.class) {
			switch (derivedFeatureID) {
				case NattableaxisPackage.FEATURE_ID_TREE_ITEM_AXIS__PARENT: return NattableaxisPackage.ITREE_ITEM_AXIS__PARENT;
				case NattableaxisPackage.FEATURE_ID_TREE_ITEM_AXIS__EXPANDED: return NattableaxisPackage.ITREE_ITEM_AXIS__EXPANDED;
				case NattableaxisPackage.FEATURE_ID_TREE_ITEM_AXIS__CHILDREN: return NattableaxisPackage.ITREE_ITEM_AXIS__CHILDREN;
				default: return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == ITreeItemAxis.class) {
			switch (baseFeatureID) {
				case NattableaxisPackage.ITREE_ITEM_AXIS__PARENT: return NattableaxisPackage.FEATURE_ID_TREE_ITEM_AXIS__PARENT;
				case NattableaxisPackage.ITREE_ITEM_AXIS__EXPANDED: return NattableaxisPackage.FEATURE_ID_TREE_ITEM_AXIS__EXPANDED;
				case NattableaxisPackage.ITREE_ITEM_AXIS__CHILDREN: return NattableaxisPackage.FEATURE_ID_TREE_ITEM_AXIS__CHILDREN;
				default: return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}
} // FeatureIdTreeItemAxisImpl
