/*****************************************************************************
 * Copyright (c) 2013, 2017 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   CEA LIST - Initial API and implementation
 *****************************************************************************/
package org.eclipse.papyrus.cdo.validation.problems.edit;

import org.eclipse.papyrus.cdo.validation.problems.EProblem;

/**
 * Optional protocol for edit providers to provide a "problem type" for an {@link EProblem}. This is intended for models that extend the CDO Problems
 * model to provide custom problems.
 */
public interface IProblemTypeProvider {

	public String getProblemType(Object object);
}
