/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.uml.diagram.internal.ui.wizards;

import com.google.common.base.Strings;
import com.google.common.eventbus.EventBus;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.cdo.CDOElement;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceLeaf;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.explorer.ui.checkouts.CDOCheckoutContentProvider;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.cdo.uml.diagram.internal.ui.l10n.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewModelPage
extends WizardPage {
    public static final String PAGE_ID = "NewCDOModel";
    private String resourceType = "model";
    private Text folderText;
    private TreeViewer folderViewer;
    private Text nameText;
    private boolean synchronizingFolderSelection;
    private Object selectedElement;
    private boolean selectedElementRevealed;
    private URI newModelResourceURI;

    public NewModelPage(IStructuredSelection selection, EventBus bus, String modelKindName) {
        super(PAGE_ID);
        this.setTitle(NLS.bind((String)Messages.NewModelPage_0, (Object)modelKindName));
        this.setDescription(NLS.bind((String)Messages.NewModelPage_1, (Object)modelKindName));
        this.setSelection(selection);
        bus.register((Object)this);
    }

    public void createControl(Composite parentControl) {
        Composite container = new Composite(parentControl, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)container);
        container.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(container, 0);
        label.setText(Messages.NewModelPage_2);
        GridDataFactory.swtDefaults().span(2, 1).applyTo((Control)label);
        this.folderText = new Text(container, 2048);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.folderText);
        this.updateFolderText();
        this.folderViewer = CDOCheckoutContentProvider.createTreeViewer((Composite)container);
        this.folderViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.folderViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (NewModelPage.this.selectedElementRevealed) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    NewModelPage.this.setSelection(selection);
                }
                NewModelPage.this.validatePage();
            }
        });
        new Label(container, 0).setText(Messages.NewModelPage_3);
        this.nameText = new Text(container, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.nameText);
        this.nameText.setText(this.getUniqueName("di"));
        this.setControl((Control)container);
        this.folderText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewModelPage.this.validatePage();
            }
        });
        this.folderViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                NewModelPage.this.setSelection(selection);
                NewModelPage.this.updateFolderText();
                NewModelPage.this.validatePage();
            }
        });
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewModelPage.this.validatePage();
            }
        });
        parentControl.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                NewModelPage.this.revealSelectedElement();
                NewModelPage.this.validatePage();
            }
        });
    }

    public String getNewResourceName() {
        return this.nameText == null ? null : this.nameText.getText().trim();
    }

    public URI createNewModelResourceURI() {
        return this.newModelResourceURI;
    }

    public URI createSelectedElementURI() {
        if (this.selectedElement instanceof CDOCheckout) {
            CDOCheckout checkout = (CDOCheckout)this.selectedElement;
            return checkout.getURI();
        }
        if (this.selectedElement instanceof CDOResourceNode) {
            CDOResourceNode resourceNode = (CDOResourceNode)this.selectedElement;
            return resourceNode.getURI();
        }
        return null;
    }

    public IStatus diagramExtensionChanged(String newExtension) {
        String currentExtension = this.getExtension();
        if (!newExtension.equals(currentExtension)) {
            String oldFileName;
            String base = oldFileName = this.getNewResourceName();
            if (currentExtension != null) {
                base = base.substring(0, base.length() - currentExtension.length() - 1);
            }
            String newFileName = this.getUniqueName(newExtension);
            this.setNewResourceName(newFileName);
            String message1 = org.eclipse.papyrus.uml.diagram.wizards.messages.Messages.NewModelFilePage_new_diagram_category_needs_specific_extension;
            String message2 = NLS.bind((String)org.eclipse.papyrus.uml.diagram.wizards.messages.Messages.NewModelFilePage_diagram_file_was_renamed, (Object)oldFileName, (Object)newFileName);
            String message = String.valueOf(message1) + message2;
            Status resultStatus = new Status(1, "org.eclipse.papyrus.uml.diagram.wizards", message);
            String errorMessage = this.getErrorMessage();
            if (errorMessage != null) {
                resultStatus = new Status(4, "org.eclipse.papyrus.uml.diagram.wizards", errorMessage);
            }
            return resultStatus;
        }
        return Status.OK_STATUS;
    }

    void setNewResourceName(String newName) {
        this.nameText.setText(newName.trim());
    }

    void validatePage() {
        String fullPath;
        this.newModelResourceURI = null;
        this.setMessage(null, 0);
        this.setPageComplete(true);
        String folder = this.folderText.getText().trim();
        if (Strings.isNullOrEmpty((String)folder)) {
            this.setPageComplete(false);
            return;
        }
        String[] segments = this.getSegments(folder);
        CDOCheckout checkout = CDOExplorerUtil.getCheckoutManager().getCheckoutByLabel(segments[0]);
        if (checkout == null) {
            this.setMessage(NLS.bind((String)Messages.NewModelPage_16, (Object)segments[0]), 3);
            this.setPageComplete(false);
            return;
        }
        CDOView view = checkout.getView();
        String path = "";
        SegmentType segmentType = SegmentType.FOLDER;
        int i = 1;
        while (i < segments.length) {
            String segment = segments[i];
            path = String.valueOf(path) + "/";
            segmentType = SegmentType.of(view, path = String.valueOf(path) + segment);
            if (segmentType == SegmentType.OTHER) {
                this.setMessage(Messages.NewModelPage_20, 3);
                this.setPageComplete(false);
                return;
            }
            ++i;
        }
        String name = this.getNewResourceName();
        if (Strings.isNullOrEmpty((String)name)) {
            this.setMessage(Messages.NewModelPage_17, 3);
            this.setPageComplete(false);
            return;
        }
        if (segmentType != SegmentType.MISSING && SegmentType.of(view, fullPath = String.valueOf(path) + "/" + name) != SegmentType.MISSING) {
            this.setMessage(NLS.bind((String)Messages.NewModelPage_18, (Object)fullPath), 3);
            this.setPageComplete(false);
            return;
        }
        this.newModelResourceURI = checkout.createResourceURI(path).appendSegment(name);
        if (segmentType == SegmentType.MISSING) {
            this.setMessage(Messages.NewModelPage_19, 2);
        }
    }

    private String[] getSegments(String folder) {
        while (folder.startsWith("/")) {
            folder = folder.substring(1);
        }
        while (folder.endsWith("/")) {
            folder = folder.substring(0, folder.length() - 1);
        }
        return folder.split("/");
    }

    private String getExtension() {
        int dot;
        String result = null;
        String name = this.getNewResourceName();
        if (name != null && (dot = name.indexOf(46)) >= 0) {
            result = name.substring(dot + 1);
        }
        return result;
    }

    private void setSelection(IStructuredSelection selection) {
        this.selectedElement = null;
        if (!selection.isEmpty()) {
            Resource resource;
            Object element = selection.getFirstElement();
            if (element instanceof CDOElement) {
                element = ((CDOElement)element).getDelegate();
            }
            if (element instanceof CDOCheckout) {
                this.selectedElement = element;
            } else if (element instanceof CDOResourceLeaf) {
                this.selectedElement = ((CDOResourceLeaf)element).getFolder();
            } else if (element instanceof CDOResourceFolder) {
                this.selectedElement = (CDOResourceFolder)element;
            } else if (element instanceof EObject && (resource = ((EObject)element).eResource()) instanceof CDOResource) {
                this.selectedElement = ((CDOResource)resource).getFolder();
            }
        }
    }

    private void updateFolderText() {
        if (!this.synchronizingFolderSelection) {
            this.synchronizingFolderSelection = true;
            try {
                if (this.selectedElement == null) {
                    this.folderText.setText("");
                } else {
                    StringBuilder builder = new StringBuilder();
                    for (Object node : this.getSelectedSegments()) {
                        builder.append('/');
                        builder.append(CDOExplorerUtil.getName((Object)node));
                    }
                    String path = builder.toString();
                    this.folderText.setText(path);
                }
            }
            finally {
                this.synchronizingFolderSelection = false;
            }
        }
    }

    private void revealSelectedElement() {
        if (this.selectedElement != null) {
            List<Object> segments = this.getSelectedSegments();
            int i = 0;
            while (i < segments.size() - 1) {
                Object segment = segments.get(i);
                this.folderViewer.setExpandedState(segment, true);
                ++i;
            }
            this.selectedElementRevealed = true;
            this.folderViewer.setSelection((ISelection)new StructuredSelection(this.selectedElement), true);
        }
    }

    private List<Object> getSelectedSegments() {
        ArrayList<Object> segments = new ArrayList<Object>();
        this.fillSegments(segments, this.selectedElement);
        return segments;
    }

    private void fillSegments(List<Object> segments, Object element) {
        if (element instanceof CDOCheckout) {
            segments.add(element);
            return;
        }
        if (element instanceof CDOResourceFolder) {
            CDOResourceFolder folder = (CDOResourceFolder)element;
            Adapter adapter = EcoreUtil.getAdapter((List)folder.eAdapters(), CDOCheckout.class);
            if (adapter != null) {
                this.fillSegments(segments, adapter);
            } else {
                CDOResourceFolder parent = folder.getFolder();
                if (parent == null) {
                    parent = EcoreUtil.getAdapter((List)folder.cdoView().getRootResource().eAdapters(), CDOCheckout.class);
                }
                this.fillSegments(segments, parent);
            }
        }
        segments.add(element);
    }

    private EList<EObject> getChildrenOfSelectedElement() {
        if (this.selectedElement instanceof CDOCheckout) {
            CDOCheckout checkout = (CDOCheckout)this.selectedElement;
            return checkout.getRootObject().eContents();
        }
        if (this.selectedElement instanceof CDOResourceFolder) {
            CDOResourceFolder folder = (CDOResourceFolder)this.selectedElement;
            return folder.eContents();
        }
        return ECollections.emptyEList();
    }

    private String getUniqueName(String extension) {
        HashSet<String> names = new HashSet<String>();
        for (EObject eObject : this.getChildrenOfSelectedElement()) {
            CDOResourceNode node;
            String name;
            if (!(eObject instanceof CDOResourceNode) || !(name = (node = (CDOResourceNode)eObject).getName()).startsWith(this.resourceType)) continue;
            names.add(name);
        }
        int i = 1;
        while (i < Integer.MAX_VALUE) {
            String name = String.valueOf(this.resourceType) + (i > 1 ? Integer.valueOf(i) : "") + "." + extension;
            if (!names.contains(name)) {
                return name;
            }
            ++i;
        }
        throw new IllegalStateException("Too many children");
    }

    private static enum SegmentType {
        MISSING,
        FOLDER,
        OTHER;


        public static SegmentType of(CDOView view, String path) {
            try {
                CDOResourceNode resourceNode = view.getResourceNode(path);
                if (resourceNode != null) {
                    if (resourceNode instanceof CDOResourceFolder) {
                        return FOLDER;
                    }
                    return OTHER;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return MISSING;
        }

        private static SegmentType of(CDOResourceNode resourceNode) {
            if (resourceNode == null) {
                return MISSING;
            }
            if (resourceNode instanceof CDOResourceFolder) {
                return FOLDER;
            }
            return OTHER;
        }
    }
}

