/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.hyperlink;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceLeaf;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.cdo.internal.ui.hyperlink.CDOResourceHyperlink;
import org.eclipse.papyrus.cdo.internal.ui.hyperlink.CDOResourceHyperlinkEditorShell;
import org.eclipse.papyrus.cdo.internal.ui.hyperlink.CreateCDOResourceHyperlinkCommand;
import org.eclipse.papyrus.cdo.internal.ui.hyperlink.Messages;
import org.eclipse.papyrus.cdo.internal.ui.views.DIModel;
import org.eclipse.papyrus.infra.core.utils.AdapterUtils;
import org.eclipse.papyrus.infra.hyperlink.helper.AbstractHyperLinkHelper;
import org.eclipse.papyrus.infra.hyperlink.helper.IHyperlinkHelperExtension;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkObject;
import org.eclipse.swt.widgets.Shell;

public class CDOResourceHyperlinkHelper
extends AbstractHyperLinkHelper
implements IHyperlinkHelperExtension {
    public HyperLinkObject getHyperLinkObject(EAnnotation eAnnotation) {
        CDOResourceHyperlink result = null;
        if (eAnnotation.getSource().equals("PapyrusHyperLink_CDO_resource")) {
            result = new CDOResourceHyperlink();
            result.setHyperlink(URI.createURI((String)((String)eAnnotation.getDetails().get((Object)"uri"))));
            result.setTooltipText((String)eAnnotation.getDetails().get((Object)"tooltip_text"));
            if (eAnnotation.getDetails().get((Object)"is_default_navigation") != null) {
                boolean isDefaultNaviagation = Boolean.parseBoolean((String)eAnnotation.getDetails().get((Object)"is_default_navigation"));
                result.setIsDefault(isDefaultNaviagation);
            } else {
                result.setIsDefault(false);
            }
        }
        return result;
    }

    public RecordingCommand getAddHyperLinkCommand(TransactionalEditingDomain domain, EModelElement object, HyperLinkObject hyperlinkObject) {
        CreateCDOResourceHyperlinkCommand result = null;
        if (hyperlinkObject instanceof CDOResourceHyperlink) {
            CDOResourceHyperlink cdoHyperlink = (CDOResourceHyperlink)hyperlinkObject;
            result = new CreateCDOResourceHyperlinkCommand(domain, object, cdoHyperlink.getTooltipText(), cdoHyperlink.getHyperlink(), cdoHyperlink.getIsDefault());
        }
        return result;
    }

    public String getNameofManagedHyperLink() {
        return Messages.CDOResourceHyperlinkHelper_name;
    }

    public void executeNewMousePressed(Shell parentShell, List<HyperLinkObject> list, EObject aModel) {
        CDOResourceHyperlinkEditorShell editor = new CDOResourceHyperlinkEditorShell(parentShell);
        if (editor.open() == 0) {
            list.add(editor.getHyperlink());
        }
    }

    public List<HyperLinkObject> getFilteredObject(List<HyperLinkObject> hyperlinkObjects) {
        return ImmutableList.copyOf((Iterable)Iterables.filter(hyperlinkObjects, (Predicate)Predicates.instanceOf(CDOResourceHyperlink.class)));
    }

    public Command getCreateHyperlinkCommand(TransactionalEditingDomain domain, EModelElement linkOwner, Object linkTarget) {
        CreateCDOResourceHyperlinkCommand result = null;
        CDOResourceNode node = (CDOResourceNode)AdapterUtils.adapt((Object)linkTarget, CDOResourceNode.class, null);
        if (node instanceof CDOResourceLeaf) {
            DIModel di;
            URI uri = node.getURI();
            String tip = uri.lastSegment();
            if (node instanceof CDOResource && (di = DIModel.getInstance((CDOResource)((CDOResource)node), (boolean)false)) != null) {
                tip = di.getName();
            }
            result = new CreateCDOResourceHyperlinkCommand(domain, linkOwner, tip, uri, false);
        }
        return result;
    }
}

