/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.trace.formater;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.moka.trace.Activator;
import org.eclipse.papyrus.moka.trace.interfaces.format.ITraceFileFormater;

public class TraceFileFormaterRegistry {
    public static final TraceFileFormaterRegistry INSTANCE = new TraceFileFormaterRegistry();
    private static final String EXTENSION_POINT = "org.eclipse.papyrus.moka.trace.formater";
    private static final String CLASS_PROPERTY_NAME = "class";
    private static final String NAME_PROPERTY_NAME = "name";
    private static final String ID_PROPERTY_NAME = "id";
    private static final String CAPTURE_ID_PROPERTY_NAME = "captureId";
    private static final String FILE_EXTENSION_PROPERTY_NAME = "fileExtension";
    private Map<String, ITraceFileFormater> formaters = this.getRegisteredFormaters();

    private TraceFileFormaterRegistry() {
    }

    public Collection<ITraceFileFormater> getTraceFileFormater() {
        return this.formaters.values();
    }

    private Map<String, ITraceFileFormater> getRegisteredFormaters() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] config = registry.getConfigurationElementsFor(EXTENSION_POINT);
        HashMap<String, ITraceFileFormater> formaters = new HashMap<String, ITraceFileFormater>();
        int i = 0;
        while (i < config.length) {
            try {
                ITraceFileFormater traceformater = (ITraceFileFormater)config[i].createExecutableExtension(CLASS_PROPERTY_NAME);
                String formaterName = config[i].getAttribute(NAME_PROPERTY_NAME);
                traceformater.setName(formaterName);
                String formaterId = config[i].getAttribute(ID_PROPERTY_NAME);
                traceformater.setId(formaterId);
                String formaterCaptureId = config[i].getAttribute(CAPTURE_ID_PROPERTY_NAME);
                traceformater.setCaptureId(formaterCaptureId);
                String fileExtension = config[i].getAttribute(FILE_EXTENSION_PROPERTY_NAME);
                traceformater.setFileExtension(fileExtension);
                formaters.put(formaterId, traceformater);
            }
            catch (CoreException e) {
                Activator.getDefault().logger.error("Could not create class for " + config[i].getAttribute(CLASS_PROPERTY_NAME), (Throwable)e);
            }
            ++i;
        }
        return formaters;
    }

    public ITraceFileFormater getFormaterFromCaptureID(String id) {
        return this.formaters.get(id);
    }

    public ITraceFileFormater getFormaterFromID(String id) {
        for (ITraceFileFormater formater : this.formaters.values()) {
            if (!formater.getId().equals(id)) continue;
            return formater;
        }
        return null;
    }
}

