/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.pssm.statemachines;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.papyrus.moka.fuml.commonbehavior.IEventOccurrence;
import org.eclipse.papyrus.moka.fuml.loci.ILocus;
import org.eclipse.papyrus.moka.fuml.loci.ISemanticVisitor;
import org.eclipse.papyrus.moka.pssm.profiling.VertexActivationProfiler;
import org.eclipse.papyrus.moka.pssm.statemachines.IPseudostateActivation;
import org.eclipse.papyrus.moka.pssm.statemachines.IRegionActivation;
import org.eclipse.papyrus.moka.pssm.statemachines.IStateActivation;
import org.eclipse.papyrus.moka.pssm.statemachines.IStateMachineExecution;
import org.eclipse.papyrus.moka.pssm.statemachines.ITransitionActivation;
import org.eclipse.papyrus.moka.pssm.statemachines.IVertexActivation;
import org.eclipse.papyrus.moka.pssm.statemachines.InitialPseudostateActivation;
import org.eclipse.papyrus.moka.pssm.statemachines.StateMachineSemanticVisitor;
import org.eclipse.papyrus.moka.pssm.statemachines.TransitionActivation;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Vertex;

public class RegionActivation
extends StateMachineSemanticVisitor
implements IRegionActivation {
    protected List<IVertexActivation> vertexActivations;
    protected List<ITransitionActivation> transitionActivations;
    protected IStateActivation history;
    public boolean isCompleted;

    public void setCompleted(boolean completed) {
        this.isCompleted = completed;
    }

    public List<IVertexActivation> getVertexActivations() {
        return this.vertexActivations;
    }

    public List<ITransitionActivation> getTransitionActivations() {
        return this.transitionActivations;
    }

    public RegionActivation() {
        this.node = null;
        this.isCompleted = false;
        this.vertexActivations = new ArrayList<IVertexActivation>();
        this.transitionActivations = new ArrayList<ITransitionActivation>();
    }

    @Override
    public boolean isVisitorFor(NamedElement node) {
        boolean isVisitor = super.isVisitorFor(node);
        if (!isVisitor) {
            Region region = ((Region)this.node).getExtendedRegion();
            while (!isVisitor && region != null) {
                if (region == node) {
                    isVisitor = true;
                    continue;
                }
                region = region.getExtendedRegion();
            }
        }
        return isVisitor;
    }

    private boolean isRedefined(List<Vertex> vertices, Vertex vertex) {
        boolean isRedefined = false;
        if (vertex instanceof State) {
            int i = 0;
            while (!isRedefined && i < vertices.size()) {
                Vertex currentVertex = vertices.get(i);
                if (currentVertex instanceof State) {
                    State state = ((State)currentVertex).getRedefinedState();
                    while (!isRedefined && state != null) {
                        isRedefined = state == vertex;
                        state = state.getRedefinedState();
                    }
                }
                ++i;
            }
        }
        return isRedefined;
    }

    @Override
    public void activate() {
        ILocus locus = this.getExecutionLocus();
        Region region = (Region)this.getNode();
        IVertexActivation activation = null;
        ArrayList<Vertex> regionVertices = new ArrayList<Vertex>((Collection<Vertex>)region.getSubvertices());
        if (region.getExtendedRegion() != null) {
            while (region.getExtendedRegion() != null) {
                region = region.getExtendedRegion();
                for (Vertex vertex : region.getSubvertices()) {
                    if (this.isRedefined(regionVertices, vertex)) continue;
                    regionVertices.add(vertex);
                }
            }
        }
        for (Vertex vertex : regionVertices) {
            activation = (IVertexActivation)locus.getFactory().instantiateVisitor((Element)vertex);
            activation.setParent((ISemanticVisitor)this);
            activation.setNode((NamedElement)vertex);
            activation.activate();
            this.vertexActivations.add(activation);
        }
    }

    private boolean isRedefined(List<Transition> transitions, Transition transition) {
        boolean isRedefined = false;
        int i = 0;
        while (!isRedefined && i < transitions.size()) {
            Transition currentTransition = transitions.get(i).getRedefinedTransition();
            while (!isRedefined && currentTransition != null) {
                isRedefined = currentTransition == transition;
                currentTransition = currentTransition.getRedefinedTransition();
            }
            ++i;
        }
        return isRedefined;
    }

    @Override
    public void activateTransitions() {
        Region region = (Region)this.getNode();
        IVertexActivation sourceActivation = null;
        IVertexActivation targetActivation = null;
        TransitionActivation transitionActivation = null;
        IStateMachineExecution context = (IStateMachineExecution)this.getStateMachineExecution();
        ArrayList<Transition> transitions = new ArrayList<Transition>((Collection<Transition>)region.getTransitions());
        if (region.getExtendedRegion() != null) {
            while (region.getExtendedRegion() != null) {
                region = region.getExtendedRegion();
                for (Transition transition : region.getTransitions()) {
                    if (this.isRedefined(transitions, transition)) continue;
                    transitions.add(transition);
                }
            }
        }
        for (Transition transition : transitions) {
            sourceActivation = context.getVertexActivation(transition.getSource());
            targetActivation = context.getVertexActivation(transition.getTarget());
            transitionActivation = (TransitionActivation)context.getLocus().getFactory().instantiateVisitor((Element)transition);
            transitionActivation.setNode((NamedElement)transition);
            transitionActivation.setParent((ISemanticVisitor)this);
            transitionActivation.setSourceActivation(sourceActivation);
            transitionActivation.setTargetActivation(targetActivation);
            this.transitionActivations.add(transitionActivation);
            sourceActivation.addOutgoingTransition((ITransitionActivation)transitionActivation);
            targetActivation.addIncomingTransition((ITransitionActivation)transitionActivation);
        }
        for (IVertexActivation activation : this.getVertexActivations()) {
            activation.activateTransitions();
        }
    }

    public IVertexActivation getVertexActivation(Vertex vertex) {
        int i = 0;
        IVertexActivation activation = null;
        while (activation == null && i < this.vertexActivations.size()) {
            if (this.vertexActivations.get(i).isVisitorFor((NamedElement)vertex)) {
                activation = this.vertexActivations.get(i);
            }
            ++i;
        }
        i = 0;
        while (activation == null && i < this.vertexActivations.size()) {
            activation = this.vertexActivations.get(i).isVisitorFor((NamedElement)vertex) ? this.vertexActivations.get(i) : this.vertexActivations.get(i).getVertexActivation(vertex);
            ++i;
        }
        return activation;
    }

    public boolean canPropagateExecution(IEventOccurrence eventOccurrence, ITransitionActivation enteringTransition) {
        IPseudostateActivation initialNodeActivation;
        boolean propagate = true;
        if (this.getVertexActivation((Vertex)enteringTransition.getTargetActivation().getNode()) == null && (initialNodeActivation = this.getOrigin()) != null) {
            propagate = initialNodeActivation.canPropagateExecution(enteringTransition, eventOccurrence, null);
        }
        return propagate;
    }

    public IPseudostateActivation getOrigin() {
        int i = 0;
        IPseudostateActivation initialNodeActivation = null;
        while (initialNodeActivation == null && i < this.vertexActivations.size()) {
            if (this.vertexActivations.get(i) instanceof InitialPseudostateActivation) {
                initialNodeActivation = (IPseudostateActivation)this.vertexActivations.get(i);
                continue;
            }
            ++i;
        }
        return initialNodeActivation;
    }

    public void enter(ITransitionActivation enteringTransition, IEventOccurrence eventOccurrence) {
        IPseudostateActivation initialNodeActivation = this.getOrigin();
        if (initialNodeActivation != null) {
            IRegionActivation iRegionActivation = null;
            IEventOccurrence iEventOccurrence = eventOccurrence;
            ITransitionActivation iTransitionActivation = enteringTransition;
            IPseudostateActivation iPseudostateActivation = initialNodeActivation;
            VertexActivationProfiler.aspectOf().ajc$before$org_eclipse_papyrus_moka_pssm_profiling_VertexActivationProfiler$2$dfc2c037(iPseudostateActivation, iTransitionActivation, iEventOccurrence, iRegionActivation);
            try {
                iPseudostateActivation.enter(iTransitionActivation, iEventOccurrence, iRegionActivation);
            }
            finally {
                if (iPseudostateActivation instanceof IStateActivation) {
                    VertexActivationProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_pssm_profiling_VertexActivationProfiler$1$107a5ab5((IStateActivation)iPseudostateActivation, iTransitionActivation, iEventOccurrence, iRegionActivation);
                }
            }
        } else {
            ISemanticVisitor parent = this.getParent();
            if (parent != null && parent instanceof IStateActivation) {
                IStateActivation parentState = (IStateActivation)parent;
                parentState.getRegionActivation().remove((Object)this);
                if (parentState.hasCompleted()) {
                    parentState.complete();
                }
            }
        }
    }

    public void exit(ITransitionActivation exitingTransition, IEventOccurrence eventOccurrence) {
        for (IVertexActivation vertexActivation : this.getVertexActivations()) {
            if (!vertexActivation.isActive()) continue;
            IRegionActivation iRegionActivation = null;
            IEventOccurrence iEventOccurrence = eventOccurrence;
            ITransitionActivation iTransitionActivation = exitingTransition;
            IVertexActivation iVertexActivation = vertexActivation;
            try {
                iVertexActivation.exit(iTransitionActivation, iEventOccurrence, iRegionActivation);
            }
            finally {
                VertexActivationProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_pssm_profiling_VertexActivationProfiler$3$a1d3df7a(iVertexActivation, iTransitionActivation, iEventOccurrence, iRegionActivation);
            }
        }
        this.isCompleted = false;
    }

    public void terminate() {
        int i = 0;
        while (i < this.vertexActivations.size()) {
            this.vertexActivations.get(i).terminate();
            ++i;
        }
        this.vertexActivations.clear();
        this.transitionActivations.clear();
    }

    public void setHistory(IStateActivation history) {
        this.history = history;
    }

    public IStateActivation getHistory() {
        return this.history;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }
}

